/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util.converter;

import com.oscar.util.TypeConverter;
import java.sql.Time;
import java.util.Calendar;

public class TimetzConverter
extends TypeConverter {
    public static synchronized byte[] convertTimetzToBytes(Time paramTime, Calendar localCalendar) {
        if (paramTime == null) {
            return null;
        }
        byte[] arrayOfByte = new byte[5];
        localCalendar.setTime(paramTime);
        arrayOfByte[0] = (byte)(localCalendar.get(11) + 1);
        arrayOfByte[1] = (byte)(localCalendar.get(12) + 1);
        arrayOfByte[2] = (byte)(localCalendar.get(13) + 1);
        arrayOfByte[3] = (byte)(localCalendar.get(15) / 3600000);
        arrayOfByte[4] = (byte)(localCalendar.get(16) % 3600000);
        return arrayOfByte;
    }

    public static com.oscar.sql.Time convertBytesToTime(byte[] val) {
        com.oscar.sql.Time returnVal = null;
        int hour = TimetzConverter.getTimeHour(val);
        int min = TimetzConverter.getTimeMin(val);
        int sec = TimetzConverter.getTimeSec(val);
        int nano = 0;
        if (val.length >= 7) {
            nano = TimetzConverter.getTimeNanos(val);
        }
        int zone = 15;
        if (val.length >= 9) {
            zone = TimetzConverter.getZone(val, 7);
        }
        returnVal = new com.oscar.sql.Time(hour, min, sec);
        returnVal.setNanos(nano);
        returnVal.setZone(zone);
        return returnVal;
    }

    public static String convertBytesToTimeZoneString(byte[] val) {
        StringBuffer ret = new StringBuffer(TimetzConverter.convertBytesToTimeString(val));
        int zone = 15;
        if (val.length >= 9) {
            zone = TimetzConverter.getZone(val, 7);
        }
        if (zone != 15 && zone != 0) {
            ret.append(" ");
            int zoneHour = zone / 3600;
            if (-10 < zoneHour && zoneHour < 0) {
                ret.append("-0");
                ret.append(-zoneHour);
            } else if (zoneHour >= 0 && zoneHour < 10) {
                ret.append("+0").append(zoneHour);
            } else if (zoneHour >= 10) {
                ret.append("+").append(zoneHour);
            } else if (zoneHour <= -10) {
                ret.append(zoneHour);
            }
            ret.append(":");
            int zoneMin = zone % 3600 / 60;
            if (zoneMin < 0) {
                zoneMin = -zoneMin;
            }
            if (0 <= zoneMin && zoneMin < 10) {
                ret.append("0");
            }
            ret.append(zoneMin);
        } else if (zone == 0) {
            ret.append(" +00:00");
        }
        return ret.toString();
    }

    public static String convertBytesToTimeString(byte[] val) {
        int hour = TimetzConverter.getTimeHour(val);
        int min = TimetzConverter.getTimeMin(val);
        int sec = TimetzConverter.getTimeSec(val);
        int nano = 0;
        if (val.length >= 7 && (nano = TimetzConverter.getTimeNanos(val)) != 0) {
            String zeros = "000000000";
            String nanosString = Integer.toString(nano);
            nanosString = zeros.substring(0, 9 - nanosString.length()) + nanosString;
            char[] nanosChar = new char[nanosString.length()];
            nanosString.getChars(0, nanosString.length(), nanosChar, 0);
            int truncIndex = 8;
            while (nanosChar[truncIndex] == '0') {
                --truncIndex;
            }
            nanosString = new String(nanosChar, 0, truncIndex + 1);
            if (nanosString.endsWith("0")) {
                nanosString = Integer.valueOf(nanosString).toString();
            }
            return String.format("%02d:%02d:%02d.%s", hour, min, sec, nanosString);
        }
        return String.format("%02d:%02d:%02d", hour, min, sec);
    }

    public static com.oscar.sql.Time convertBytesToTime(byte[] val, Calendar cal) {
        com.oscar.sql.Time returnVal = null;
        if (cal == null) {
            return TimetzConverter.convertBytesToTime(val);
        }
        if (val != null && val.length > 0) {
            cal.set(1970, 0, 1, TimetzConverter.getTimeHour(val), TimetzConverter.getTimeMin(val), TimetzConverter.getTimeSec(val));
            cal.set(14, 0);
            if (cal.isSet(0)) {
                cal.set(0, 1);
            }
            if (val.length >= 9) {
                int zone = TimetzConverter.getZone(val, 7);
                int userOffset = cal.get(15) + cal.get(16);
                int offset = userOffset - zone;
                returnVal = new com.oscar.sql.Time(cal.getTimeInMillis() + (long)offset);
            } else {
                returnVal = new com.oscar.sql.Time(cal.getTimeInMillis());
            }
            if (val.length >= 7) {
                returnVal.setNanos(TimetzConverter.getTimeNanos(val));
            }
        }
        return returnVal;
    }
}

