/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.Driver;
import com.oscar.core.BaseResultSet;
import com.oscar.jdbc.ExceptionUtil;
import com.oscar.jdbc.OscarCallableStatement;
import com.oscar.jdbc.OscarJdbc2Connection;
import com.oscar.jdbc.OscarPreparedStatement;
import com.oscar.jdbc.OscarPreparedStatementV2;
import com.oscar.jdbc.OscarStatement;
import com.oscar.jdbc.OscarStatementV2;
import com.oscar.rac.executor.RacCallableStatementV2;
import com.oscar.rac.executor.RacPreparedStatementV2;
import com.oscar.rac.executor.RacStatementV2;
import com.oscar.util.OSQLException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class OscarJdbc2RacConnection
extends OscarJdbc2Connection {
    private volatile boolean retryConnect = true;

    @Override
    public void openConnection(String host, int port, Properties info, String database, String url, Driver driver) throws SQLException {
        this.closed = false;
        super.openConnection(host, port, info, database, url, driver);
        List<String> racInfos = this.initRacInfo();
        if (racInfos.size() > 0) {
            for (String racInfo : racInfos) {
                Driver.getHostSet().add(racInfo);
            }
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.logFlag) {
            Driver.writeLog("session: " + this.sessionID + ", " + OscarJdbc2Connection.class + ",createStatement, paras: resultSetType: " + resultSetType + ", concurrency: " + resultSetConcurrency + ", holdability: " + resultSetHoldability);
        }
        if (resultSetType != 1003 && resultSetType != 1004 && resultSetType != 1005) {
            throw new OSQLException("OSCAR-00422", "88888", 422);
        }
        if (resultSetConcurrency != 1007 && resultSetConcurrency != 1008) {
            throw new OSQLException("OSCAR-00423", "88888", 423);
        }
        if (resultSetHoldability != 2 && resultSetHoldability != 1) {
            throw new OSQLException("OSCAR-00207", "88888", 207);
        }
        if (this.stList == null) {
            this.stList = new LinkedList();
        }
        if (this.version.getProtocolType() == 1) {
            OscarStatement s = new OscarStatement(this);
            s.setResultSetType(resultSetType);
            s.setResultSetConcurrency(resultSetConcurrency);
            s.setResultSetHoldability(resultSetHoldability);
            s.setFetchSize(this.statementFetchSize);
            this.setHoldability(resultSetHoldability);
            this.stList.add(s);
            return s;
        }
        RacStatementV2 s = new RacStatementV2(this);
        s.setResultSetType(resultSetType);
        s.setResultSetConcurrency(resultSetConcurrency);
        s.setResultSetHoldability(resultSetHoldability);
        s.setFetchSize(this.statementFetchSize);
        this.setHoldability(resultSetHoldability);
        this.stList.add(s);
        return s;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType != 1003 && resultSetType != 1004 && resultSetType != 1005) {
            throw new OSQLException("OSCAR-00422", "88888", 422);
        }
        if (resultSetConcurrency != 1007 && resultSetConcurrency != 1008) {
            throw new OSQLException("OSCAR-00423", "88888", 423);
        }
        if (resultSetHoldability != 2 && resultSetHoldability != 1) {
            throw new OSQLException("OSCAR-00207", "88888", 207);
        }
        if (this.stList == null) {
            this.stList = new LinkedList();
        }
        if (this.version.getProtocolType() == 1) {
            OscarCallableStatement s = new OscarCallableStatement(this, sql);
            s.setResultSetType(resultSetType);
            s.setResultSetConcurrency(resultSetConcurrency);
            s.setResultSetHoldability(resultSetHoldability);
            s.setFetchSize(this.statementFetchSize);
            this.setHoldability(resultSetHoldability);
            s.prepare();
            this.stList.add(s);
            return s;
        }
        RacCallableStatementV2 s = new RacCallableStatementV2(this, sql);
        s.setResultSetType(resultSetType);
        s.setResultSetConcurrency(resultSetConcurrency);
        s.setResultSetHoldability(resultSetHoldability);
        s.setFetchSize(this.statementFetchSize);
        this.setHoldability(resultSetHoldability);
        s.prepare();
        s.setLobDisplayMaxSize(this.lobDisplayMaxSize);
        this.stList.add(s);
        return s;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        sql = sql.trim();
        if (this.stLogFlag || this.logFlag) {
            Driver.writeLog("session: " + this.sessionID + ", " + OscarJdbc2Connection.class + ",prepareStatement, paras: sql: " + sql + ", resultSetType: " + resultSetType + ", concurrency: " + resultSetConcurrency + ", holdability: " + resultSetHoldability);
        }
        if (resultSetType != 1003 && resultSetType != 1004 && resultSetType != 1005) {
            throw new OSQLException("OSCAR-00422", "88888", 422);
        }
        if (resultSetConcurrency != 1007 && resultSetConcurrency != 1008) {
            throw new OSQLException("OSCAR-00423", "88888", 423);
        }
        if (resultSetHoldability != 2 && resultSetHoldability != 1) {
            throw new OSQLException("OSCAR-00207", "88888", 207);
        }
        if (this.stList == null) {
            this.stList = new LinkedList();
        }
        if (this.version.getProtocolType() == 1) {
            OscarStatement s = null;
            if (this.statementCache != null) {
                s = (OscarPreparedStatement)this.statementCache.searchImplicitCache(sql, 1, resultSetType);
            }
            if (s == null) {
                s = new OscarPreparedStatement(this, sql);
                if (resultSetConcurrency == 1008) {
                    s.setUseTid(true);
                }
                if (s.isNotSupportPrePare()) {
                    this.stList.add(s);
                    return s;
                }
                ((OscarPreparedStatement)s).prepare();
            }
            s.setFetchSize(this.statementFetchSize);
            s.setResultSetType(resultSetType);
            s.setResultSetConcurrency(resultSetConcurrency);
            s.setResultSetHoldability(resultSetHoldability);
            this.stList.add(s);
            return s;
        }
        OscarStatement s = null;
        if (this.statementCache != null) {
            s = (RacPreparedStatementV2)this.statementCache.searchImplicitCache(sql, 1, resultSetType);
        }
        if (s == null) {
            s = new RacPreparedStatementV2(this, sql);
            if (resultSetConcurrency == 1008) {
                s.setUseTid(true);
            }
            if (s.isNotSupportPrePare()) {
                this.stList.add(s);
                return s;
            }
            ((OscarPreparedStatementV2)s).prepare();
        }
        s.setFetchSize(this.statementFetchSize);
        s.setResultSetType(resultSetType);
        s.setResultSetConcurrency(resultSetConcurrency);
        s.setResultSetHoldability(resultSetHoldability);
        ((OscarStatementV2)s).setLobDisplayMaxSize(this.lobDisplayMaxSize);
        this.stList.add(s);
        return s;
    }

    @Override
    void checkConnectionClosed(Exception e) {
        switch (ExceptionUtil.isConnectionClosed(e)) {
            case 1: {
                try {
                    this.retryConnect = true;
                    this.reConnect(this.getConnectionProperties());
                }
                catch (SQLException e1) {
                    this.retryConnect = true;
                }
                break;
            }
            case 2: {
                this.closed = true;
                break;
            }
        }
    }

    public boolean isRetryConnect() {
        return this.retryConnect;
    }

    public void setRetryConnect(boolean retryConnect) {
        this.retryConnect = retryConnect;
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        super.commit();
    }

    @Override
    public synchronized void rollback() throws SQLException {
        this.checkClosed();
        super.rollback();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        super.setAutoCommit(autoCommit);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        super.rollback(savepoint);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        return super.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        return super.setSavepoint(name);
    }

    public synchronized void reConnect(Properties props) throws SQLException {
        if (!this.retryConnect) {
            return;
        }
        this.closed = true;
        this.resetStatement();
        if (!this.autoCommit) {
            this.planIDVec = null;
            this.cursorVec = null;
        }
        this.getDriver().connect(props.getProperty("URL"), props, this);
        if (!this.autoCommit) {
            this.autoCommit = true;
            super.setAutoCommit(false);
        }
        this.retryConnect = false;
        this.closed = false;
        Driver.writeLog("rac change connection success");
    }

    public void resetStatement() {
        if (this.stList != null && this.stList.size() > 0) {
            for (Object stmt : this.stList) {
                if (!(stmt instanceof OscarStatement)) continue;
                ((OscarStatement)stmt).initParams();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> initRacInfo() {
        ArrayList<String> result = new ArrayList<String>();
        BaseResultSet rs = null;
        StringBuilder sb = new StringBuilder("session: " + this.sessionID + ", " + OscarJdbc2RacConnection.class + ", initRacInfo(), ");
        try {
            rs = this.execSQL("select * from info_schem.v_sys_rac_node_info where dead='f' and JOINED = 't'");
            while (rs.next()) {
                String adddress = rs.getString("ADDRESS");
                long port = rs.getLong("PORT");
                String value = adddress + ":" + port;
                result.add(value);
                sb.append(value).append(",");
            }
        }
        catch (SQLException e) {
            sb.append(" error: ").append(e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                sb.append(" error: ").append(e.getMessage());
            }
        }
        if (this.logFlag) {
            Driver.writeLog(sb.toString());
        }
        return result;
    }
}

