/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.ae;

import com.oscar.Driver;
import com.oscar.ae.CmkManager;
import com.oscar.ae.ColumnMasterKey;
import com.oscar.ae.EncryptionCommon;
import com.oscar.ae.OscarCekStoreProvider;
import com.oscar.util.Hex;
import java.sql.SQLException;
import java.util.Arrays;

public class OscarCekLocalKmsProvider
extends OscarCekStoreProvider {
    protected boolean logFlag = Driver.getLogLevel() >= 2;
    String name = "LOCALKMS";

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public byte[] decryptColumnEncryptionKey(String masterKeyPath, String encryptionAlgorithm, byte[] encryptedColumnEncryptionKey) throws SQLException {
        try {
            ColumnMasterKey cmk = CmkManager.singleton().getCmkOrFind(masterKeyPath, false);
            if (cmk == null) {
                throw new SQLException("\u6ca1\u6709\u627e\u5230CMK\uff1a" + masterKeyPath);
            }
            byte[] publicKeyBytes = cmk.getPublicKeyInfo().getKeyValueRawBytes();
            byte[] afterValue = EncryptionCommon.decryptWithPublicKey(publicKeyBytes, encryptedColumnEncryptionKey, encryptionAlgorithm);
            if (this.logFlag) {
                Driver.writeLog("cmk\u660e\u6587 \u516c\u94a5:" + Arrays.toString(publicKeyBytes));
                Driver.writeLog("cek\u660e\u6587:" + new String(afterValue, EncryptionCommon.ISO_8859_1));
            }
            return afterValue;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean verifyColumnMasterKeyMetadata(String masterKeyPath, byte[] signature) throws SQLException {
        return true;
    }

    @Override
    public byte[] encryptColumnEncryptionKey(String masterKeyPath, String encryptionAlgorithm, byte[] plainTextColumnEncryptionKey) throws SQLException {
        try {
            ColumnMasterKey cmk = CmkManager.singleton().getCmkOrFind(masterKeyPath, true);
            if (cmk == null) {
                throw new SQLException("\u6ca1\u6709\u627e\u5230CMK\uff1a" + masterKeyPath);
            }
            byte[] privateKeyBytes = cmk.getPrivateKeyInfo().getKeyValueRawBytes();
            byte[] afterValue = EncryptionCommon.encryptWithPrivateKey(privateKeyBytes, plainTextColumnEncryptionKey);
            if (this.logFlag) {
                Driver.writeLog("cmk\u660e\u6587 \u79c1\u94a5:" + Arrays.toString(privateKeyBytes));
                Driver.writeLog("cek\u660e\u6587:" + new String(plainTextColumnEncryptionKey));
                Driver.writeLog("cek\u5bc6\u6587\uff1a" + Arrays.toString(afterValue));
            }
            String after = Hex.bytesToHexString(afterValue);
            if (this.logFlag) {
                Driver.writeLog("cek\u5bc6\u6587\u8f6c\u5341\u516d\u8fdb\u5236\uff1a" + after);
            }
            return after.getBytes();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }
}

