/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;

public class Oscar42Helper {
    public static Object convertLocalTo(Object x) {
        if (x instanceof LocalDate) {
            return Date.valueOf((LocalDate)x);
        }
        if (x instanceof LocalDateTime) {
            return Timestamp.valueOf((LocalDateTime)x);
        }
        if (x instanceof LocalTime) {
            return Time.valueOf((LocalTime)x);
        }
        if (x instanceof OffsetTime) {
            return x.toString();
        }
        if (x instanceof OffsetDateTime) {
            return x.toString();
        }
        if (x instanceof Period) {
            return ((Period)x).getYears() + "-" + ((Period)x).getMonths();
        }
        if (x instanceof Duration) {
            Duration d = (Duration)x;
            return Oscar42Helper.formatDuration(d);
        }
        return x;
    }

    public static String formatPeriod(Period period) {
        long years = period.getYears();
        long months = period.getMonths();
        return String.format("%d-%02d", years, months);
    }

    public static String formatDuration(Duration duration) {
        long days = duration.toDays();
        long hours = duration.toHours() % 24L;
        long minutes = duration.toMinutes() % 60L;
        long seconds = duration.getSeconds() % 60L;
        return String.format("%d %02d:%02d:%02d", days, hours, minutes, seconds);
    }

    public static void main(String[] args) {
        System.out.println(Oscar42Helper.formatPeriod(Period.ofDays(1000)));
    }
}

