/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.protocol.packets;

import com.oscar.Driver;
import com.oscar.protocol.packets.BasePacket;
import com.oscar.protocol.packets.ScramSupport;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class AuthenticationPacket
extends BasePacket {
    private static final char tag = 'R';
    private static final int SM_AUTHPOLICY = 4;
    private static final int SM_SALT = 2;
    private static final int SM_MD5SALT = 4;
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_MD5 = 5;
    private static final int AUTH_REQ_SCM = 6;
    public static final int AUTH_REQ_SM3 = 7;
    private int authenPolicy;
    private Object salt = null;
    private ScramSupport scramnSupport;

    public int getAuthenPolicy() {
        return this.authenPolicy;
    }

    public Object getSalt() {
        return this.salt;
    }

    @Override
    public void sendTo(BufferedOutputStream stream) throws IOException, SQLException {
        if (this.scramnSupport != null && ScramSupport.isScramPolicy(this.authenPolicy)) {
            this.scramnSupport.sendTo(stream, this.authenPolicy);
        }
    }

    @Override
    public void receiveFrom(InputStream stream) throws IOException, SQLException {
        if (this.logFlag) {
            this.sb.delete(0, this.sb.length());
            this.sb.append("***********************************************************").append("\n");
        }
        this.authenPolicy = BasePacket.ReceiveIntegerR(stream, 4);
        if (this.logFlag) {
            this.sb.append("conid: ").append(this.conn.getSessionID()).append(", /*Session ").append(this.conn.getPlanID()).append("*/ ").append("receive : ");
            this.sb.append("authenPolicy: ").append(this.authenPolicy).append(", send 'R': ").append("\n");
        }
        if (this.authenPolicy == 5 || this.authenPolicy == 7) {
            byte[] md5Salt = new byte[]{(byte)BasePacket.ReceiveChar(stream), (byte)BasePacket.ReceiveChar(stream), (byte)BasePacket.ReceiveChar(stream), (byte)BasePacket.ReceiveChar(stream)};
            this.salt = md5Salt;
            if (this.logFlag) {
                for (int i = 0; i < md5Salt.length; ++i) {
                    this.sb.append(md5Salt[i]).append(" ");
                }
            }
        } else if (ScramSupport.isScramPolicy(this.authenPolicy)) {
            if (this.scramnSupport == null) {
                this.scramnSupport = new ScramSupport();
            }
            this.scramnSupport.receiveFrom(stream, this.authenPolicy);
        }
        if (this.logFlag) {
            this.sb.append("\n").append("***********************************************************");
            Driver.writeLog(this.sb.toString());
        }
    }

    public ScramSupport getScramSupport() {
        return this.scramnSupport;
    }

    @Override
    public char getTag() {
        return 'R';
    }
}

