/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc;

import com.oscar.core.BaseConnection;
import com.oscar.core.BaseStatement;
import com.oscar.core.Encoding;
import com.oscar.core.Field;
import com.oscar.jdbc.OscarResultSetV2;
import com.oscar.sql.Time;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.TimeZone;

public class Oscar42ResultSetV2
extends OscarResultSetV2 {
    public Oscar42ResultSetV2(BaseStatement statement, BaseConnection connection, boolean netDataByStr, boolean numericKeepPrecision, int resultSetType, int resultSetConcurrency, boolean canUpdateable, int fetchDirection, Encoding encoding, String curSorName, Field[] fields, List<byte[][]> tuples, String status, long updateCount, long insertOID, int fetchSize, int maxRows) {
        super(statement, connection, netDataByStr, numericKeepPrecision, resultSetType, resultSetConcurrency, canUpdateable, fetchDirection, encoding, curSorName, fields, tuples, status, updateCount, insertOID, fetchSize, maxRows);
    }

    public Oscar42ResultSetV2(BaseStatement statement, Field[] fields, List<byte[][]> tuples, String status, long updateCount, long insertOID, int fetchSize, int maxRows) throws SQLException {
        super(statement, fields, tuples, status, updateCount, insertOID, fetchSize, maxRows);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        Timestamp timeStamp;
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (type == null) {
            throw new SQLException("OSCAR-00319", "88888", 319);
        }
        Field field = this.fields[columnIndex - 1];
        int sqlType = field.getSQLType();
        if (type.equals(LocalDate.class)) {
            Date date;
            if (sqlType == 91 && (date = this.getDate(columnIndex)) != null) {
                return (T)LocalDate.of(date.getYear() + 1900, date.getMonth() + 1, date.getDate());
            }
            Timestamp timeStamp2 = this.getOscarTimestamp(columnIndex);
            if (timeStamp2 != null) {
                if (timeStamp2 instanceof com.oscar.sql.Timestamp) {
                    com.oscar.sql.Timestamp oscarTimeStamp = (com.oscar.sql.Timestamp)timeStamp2;
                    oscarTimeStamp.stringValue();
                    return (T)LocalDate.of(oscarTimeStamp.fetchYearString(), oscarTimeStamp.fetchMonthString(), oscarTimeStamp.fetchDayString());
                }
                return (T)timeStamp2.toLocalDateTime().toLocalDate();
            }
        } else if (type.equals(LocalDateTime.class)) {
            Timestamp timeStamp3 = this.getOscarTimestamp(columnIndex);
            if (timeStamp3 != null) {
                if (timeStamp3 instanceof com.oscar.sql.Timestamp) {
                    com.oscar.sql.Timestamp oscarTimeStamp = (com.oscar.sql.Timestamp)timeStamp3;
                    oscarTimeStamp.stringValue();
                    return (T)LocalDateTime.of(oscarTimeStamp.fetchYearString(), oscarTimeStamp.fetchMonthString(), oscarTimeStamp.fetchDayString(), oscarTimeStamp.fetchHourString(), oscarTimeStamp.fetchMinuteString(), oscarTimeStamp.fetchSecondString(), oscarTimeStamp.fetchNanosString());
                }
                return (T)timeStamp3.toLocalDateTime();
            }
        } else if (type.equals(LocalTime.class)) {
            java.sql.Time time;
            if (sqlType == 92 && (time = this.getTime(columnIndex)) != null) {
                if (time instanceof Time) {
                    return (T)LocalTime.of(time.getHours(), time.getMinutes(), time.getSeconds());
                }
                return (T)LocalTime.parse(time.toString());
            }
            Timestamp timeStamp4 = this.getOscarTimestamp(columnIndex);
            if (timeStamp4 != null) {
                if (timeStamp4 instanceof com.oscar.sql.Timestamp) {
                    com.oscar.sql.Timestamp oscarTimeStamp = (com.oscar.sql.Timestamp)timeStamp4;
                    oscarTimeStamp.stringValue();
                    return (T)LocalTime.of(oscarTimeStamp.fetchHourString(), oscarTimeStamp.fetchMinuteString(), oscarTimeStamp.fetchSecondString());
                }
                return (T)timeStamp4.toLocalDateTime().toLocalTime();
            }
        } else if (type.equals(OffsetDateTime.class)) {
            Timestamp timeStamp5 = this.getOscarTimestamp(columnIndex);
            if (timeStamp5 != null) {
                if (timeStamp5 instanceof com.oscar.sql.Timestamp) {
                    com.oscar.sql.Timestamp oscarTimeStamp = (com.oscar.sql.Timestamp)timeStamp5;
                    oscarTimeStamp.stringValue();
                    String offsetId = ((com.oscar.sql.Timestamp)timeStamp5).fetchZoneString();
                    ZoneOffset zoneOffset = null;
                    zoneOffset = offsetId.isEmpty() ? LocalDateTime.now(ZoneOffset.systemDefault()).atZone(ZoneOffset.systemDefault()).getOffset() : ZoneOffset.of(offsetId);
                    return (T)OffsetDateTime.of(oscarTimeStamp.fetchYearString(), oscarTimeStamp.fetchMonthString(), oscarTimeStamp.fetchDayString(), oscarTimeStamp.fetchHourString(), oscarTimeStamp.fetchMinuteString(), oscarTimeStamp.fetchSecondString(), oscarTimeStamp.getNanos(), zoneOffset);
                }
                ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(timeStamp5.getTimezoneOffset());
                return (T)OffsetDateTime.of(timeStamp5.getYear(), timeStamp5.getMonth(), timeStamp5.getDay(), timeStamp5.getHours(), timeStamp5.getMinutes(), timeStamp5.getSeconds(), timeStamp5.getNanos(), zoneOffset);
            }
        } else if (type.equals(OffsetTime.class)) {
            java.sql.Time time;
            if ((sqlType == 92 || sqlType == 27) && (time = this.getOscarTime(columnIndex)) != null) {
                if (time instanceof Time) {
                    Time oscarTime = (Time)time;
                    String offsetId = oscarTime.getZoneString();
                    ZoneOffset zoneOffset = null;
                    zoneOffset = offsetId.isEmpty() ? LocalDateTime.now(ZoneOffset.systemDefault()).atZone(ZoneOffset.systemDefault()).getOffset() : ZoneOffset.of(offsetId);
                    return (T)OffsetTime.of(time.getHours(), time.getMinutes(), time.getSeconds(), oscarTime.getNanos(), zoneOffset);
                }
                return (T)OffsetTime.of(LocalTime.parse(time.toString()), LocalDateTime.now(ZoneOffset.systemDefault()).atZone(ZoneOffset.systemDefault()).getOffset());
            }
            Timestamp timeStamp6 = this.getOscarTimestamp(columnIndex);
            if (timeStamp6 != null) {
                if (timeStamp6 instanceof com.oscar.sql.Timestamp) {
                    com.oscar.sql.Timestamp oscarTimeStamp = (com.oscar.sql.Timestamp)timeStamp6;
                    oscarTimeStamp.stringValue();
                    String offsetId = ((com.oscar.sql.Timestamp)timeStamp6).fetchZoneString();
                    ZoneOffset zoneOffset = null;
                    zoneOffset = offsetId.isEmpty() ? LocalDateTime.now(ZoneOffset.systemDefault()).atZone(ZoneOffset.systemDefault()).getOffset() : ZoneOffset.of(offsetId);
                    return (T)OffsetTime.of(oscarTimeStamp.fetchHourString(), oscarTimeStamp.fetchMinuteString(), oscarTimeStamp.fetchSecondString(), oscarTimeStamp.fetchNanosString(), zoneOffset);
                }
                return (T)OffsetDateTime.of(timeStamp6.toLocalDateTime(), LocalDateTime.now(ZoneOffset.systemDefault()).atZone(ZoneOffset.systemDefault()).getOffset());
            }
        } else if (type.equals(ZonedDateTime.class) && (timeStamp = this.getOscarTimestamp(columnIndex)) != null) {
            if (timeStamp instanceof com.oscar.sql.Timestamp) {
                com.oscar.sql.Timestamp oscarTimeStamp = (com.oscar.sql.Timestamp)timeStamp;
                oscarTimeStamp.stringValue();
                ZoneId zoneId = null;
                zoneId = oscarTimeStamp.fetchZoneString().isEmpty() ? TimeZone.getDefault().toZoneId() : ZoneId.of(oscarTimeStamp.fetchZoneString());
                return (T)ZonedDateTime.of(oscarTimeStamp.fetchYearString(), oscarTimeStamp.fetchMonthString(), oscarTimeStamp.fetchDayString(), oscarTimeStamp.fetchHourString(), oscarTimeStamp.fetchMinuteString(), oscarTimeStamp.fetchSecondString(), oscarTimeStamp.fetchNanosString(), zoneId);
            }
            return (T)ZonedDateTime.ofInstant(timeStamp.toInstant(), TimeZone.getDefault().toZoneId());
        }
        return super.getObject(columnIndex, type);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkIndex(columnIndex);
        this.checkNull();
        if (this.this_row[columnIndex - 1] == null) {
            return null;
        }
        Field field = this.fields[columnIndex - 1];
        switch (field.getSQLType()) {
            case 27: {
                return this.getObject(columnIndex, OffsetTime.class);
            }
            case 29: {
                return this.getObject(columnIndex, OffsetDateTime.class);
            }
        }
        return super.getObject(columnIndex);
    }
}

