/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis.binary;

public abstract class ByteSetter {
    public abstract void set(byte var1, int var2);

    public static class StringByteSetter
    extends ByteSetter {
        private static final char[] hextypes = "0123456789ABCDEF".toCharArray();
        private char[] rep;

        public StringByteSetter(int length) {
            this.rep = new char[length * 2];
        }

        @Override
        public void set(byte b, int index) {
            this.rep[index *= 2] = hextypes[b >>> 4 & 0xF];
            this.rep[index + 1] = hextypes[b & 0xF];
        }

        public char[] resultAsArray() {
            return this.rep;
        }

        public String result() {
            return new String(this.rep);
        }

        public String toString() {
            return new String(this.rep);
        }
    }

    public static class BinaryByteSetter
    extends ByteSetter {
        private byte[] array;

        public BinaryByteSetter(int length) {
            this.array = new byte[length];
        }

        @Override
        public void set(byte b, int index) {
            this.array[index] = b;
        }

        public byte[] result() {
            return this.array;
        }

        public String toString() {
            char[] arr = new char[this.array.length];
            for (int i = 0; i < this.array.length; ++i) {
                arr[i] = (char)(this.array[i] & 0xFF);
            }
            return new String(arr);
        }
    }
}

