/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import com.oscar.util.ColumnData;
import com.oscar.util.ImportStream;
import com.oscar.util.OSCARbyte;
import com.oscar.util.OSQLException;
import com.oscar.util.ReaderInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.SQLException;

public class StreamData
extends ColumnData {
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    public static final int MAX_BYTE_SIZE = 32765;
    private int length = 0;
    private InputStream in;
    private boolean toOscarString;

    public void read(InputStream in, int o_length) throws SQLException {
        this.read(in, o_length, false);
    }

    public void read(InputStream in, int o_length, boolean toOscarString) throws SQLException {
        if (in == null) {
            throw new NullPointerException();
        }
        if (o_length < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.in = in;
        this.length = o_length;
        this.toOscarString = toOscarString;
    }

    public void read(Reader in, int o_length, String connEncoding) throws SQLException {
        if (in == null) {
            throw new NullPointerException();
        }
        if (o_length < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.in = new ReaderInputStream(in, Charset.forName(connEncoding));
        this.length = o_length;
    }

    public void read(Reader in, String connEncoding) throws SQLException {
        if (in == null) {
            throw new NullPointerException();
        }
        this.in = new ReaderInputStream(in, Charset.forName(connEncoding));
    }

    public void read(InputStream in) throws SQLException {
        this.read(in, false);
    }

    public void read(InputStream in, boolean toOscarString) throws SQLException {
        if (in == null) {
            throw new NullPointerException();
        }
        this.toOscarString = toOscarString;
    }

    @Override
    public void preWrite(ImportStream out) throws SQLException {
        out.writeInteger(-2, 2);
    }

    @Override
    public void endWrite(ImportStream out) throws SQLException {
        try {
            this.doWrite(out);
        }
        catch (IOException e) {
            throw new OSQLException("OSCAR-00804", "88888", 804, e);
        }
        finally {
            out.writeInteger(-2, 2);
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void doWrite(ImportStream out) throws IOException, SQLException {
        if (this.in == null || out == null) {
            throw new OSQLException("InputStream handle is invalid", "00804");
        }
        int bufferSize = this.toOscarString ? 16381 : 16384;
        int readLength = 0;
        if (this.length <= 0) {
            boolean first = true;
            byte[] buffer = new byte[bufferSize];
            while ((readLength = this.in.read(buffer, 0, bufferSize)) != -1) {
                this.writeBuffer(out, buffer, readLength, first);
                if (!first) continue;
                first = false;
            }
        } else {
            int remain = this.length;
            byte[] buffer = null;
            if (remain < bufferSize) {
                bufferSize = remain;
                buffer = new byte[remain];
            } else {
                buffer = new byte[bufferSize];
            }
            boolean first = true;
            while ((readLength = this.in.read(buffer, 0, bufferSize)) != -1 && remain > 0) {
                this.writeBuffer(out, buffer, readLength, first);
                if (first) {
                    first = false;
                }
                remain -= readLength;
            }
        }
    }

    private void writeBuffer(ImportStream out, byte[] buffer, int length, boolean begin0x) throws SQLException {
        if (this.toOscarString) {
            byte[] data = buffer;
            if (buffer.length != length) {
                data = new byte[length];
                System.arraycopy(buffer, 0, data, 0, length);
            }
            byte[] newBuffer = OSCARbyte.getOscarHexBytes(data, begin0x);
            assert (newBuffer.length < 32765);
            out.writeInteger(newBuffer.length + 2, 2);
            out.write(newBuffer);
        } else {
            out.writeInteger(length + 2, 2);
            out.write(buffer, 0, length);
        }
    }

    @Override
    public void clear() throws SQLException {
        this.length = 0;
        this.in = null;
        this.toOscarString = false;
    }

    @Override
    public void preWriteBlock(ImportStream out) throws SQLException {
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }
}

