/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.jdbc.ae.valuehandler;

import com.oscar.Driver;
import com.oscar.ae.CekManager;
import com.oscar.ae.ColumnEncryptionKey;
import com.oscar.ae.EncryptionCommon;
import com.oscar.core.BaseResultSet;
import com.oscar.core.Field;
import com.oscar.jdbc.ae.ParameterEncryptionDesc;
import com.oscar.jdbc.ae.valuehandler.ValueHandler;
import com.oscar.util.Hex;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Arrays;

public abstract class AbstractValueHandler<T>
implements ValueHandler<T> {
    protected boolean logFlag = Driver.getLogLevel() >= 2;
    final byte[] vectorBytes = new byte[]{49, -116, 89, -89, -108, 63, 15, -23, -113, 57, -71, 54, 50, 102, 55, 50};

    @Override
    public String encrypt(ParameterEncryptionDesc desc, Object originalValue, int originalSqlType) throws SQLException {
        try {
            ColumnEncryptionKey cek = CekManager.singleton().getCek(new String(desc.getCekEncryptedValue(), EncryptionCommon.ISO_8859_1), desc.getCmkPath(), desc.getCekAlgorithm());
            if (cek == null) {
                throw new SQLException("\u6ca1\u6709\u627e\u5230CEK");
            }
            CekManager.singleton().cache(cek);
            if (this.logFlag) {
                Driver.writeLog("\u539f\u503c\uff1a" + originalValue);
            }
            byte[] afterBytes = EncryptionCommon.encryptKey_AES128_CBC_HMAC_SHA256(originalValue.toString().getBytes(EncryptionCommon.ISO_8859_1), cek.getKeyValueRaw(), this.vectorBytes);
            if (this.logFlag) {
                Driver.writeLog("\u52a0\u5bc6\u540e\u7684\u503c\uff1a" + Arrays.toString(afterBytes));
            }
            String after16 = Hex.bytesToHexString(afterBytes);
            if (this.logFlag) {
                Driver.writeLog("\u5341\u516d\u8fdb\u5236\u503c\uff1a" + after16);
            }
            after16 = "0x01" + after16;
            if (this.logFlag) {
                Driver.writeLog("\u6700\u7ec8\u503c\uff1a" + after16);
            }
            return after16;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.logFlag) {
                Driver.writeLog("\u89e3\u5bc6\u503c\u53d1\u751f\u9519\u8bef\uff0c\u503c\uff1a" + originalValue, e);
            }
            throw new SQLException("\u89e3\u5bc6\u503c\u53d1\u751f\u9519\u8bef\uff0c\u503c\uff1a" + originalValue + ", \u8be6\u7ec6\uff1a" + e.toString(), e);
        }
    }

    protected String revertValue(Field field, byte[] encryptKeyValue, Object[] args) throws SQLException {
        String string;
        String hex = new String(encryptKeyValue, EncryptionCommon.ISO_8859_1);
        hex = hex.substring(4);
        byte[] before16 = Hex.hexStringToByte(hex);
        if (this.logFlag) {
            Driver.writeLog("\u539f\u6587\uff1a\uff1a\uff1a" + hex);
            Driver.writeLog("16\u8fdb\u5236\u8fd8\u539f\uff1a\uff1a\uff1a" + Arrays.toString(before16));
        }
        try {
            string = this.decryptionValue(field, before16);
        }
        catch (Exception e) {
            if (this.logFlag) {
                Driver.writeLog("\u89e3\u5bc6\u503c\u53d1\u751f\u9519\u8bef\uff0c\u503c\uff1a" + hex, e);
            }
            throw new SQLException("\u89e3\u5bc6\u503c\u53d1\u751f\u9519\u8bef\uff0c\u503c\uff1a" + hex + " ,\u539f\u56e0\uff1a" + e.toString(), e);
        }
        if (this.logFlag) {
            Driver.writeLog("cek\u89e3\u5bc6\u540e\uff1a\uff1a\uff1a" + string);
        }
        return string;
    }

    protected String decryptionValue(Field field, byte[] encryptKeyValue) throws Exception {
        EncryptionCommon.ColumnEncryptionAlgorithm algorithm;
        ColumnEncryptionKey cek = CekManager.singleton().getCek(field.getColumnEncryptKeyValue(), field.getColumnMasterKeyPath(), field.getColumnEncryptKeyMode());
        try {
            algorithm = EncryptionCommon.ColumnEncryptionAlgorithm.valueOf(field.getColumnEncryptType());
        }
        catch (Exception e) {
            if (field.getColumnEncryptType().startsWith("AEAD_AES_256_CBC_HMAC")) {
                algorithm = EncryptionCommon.ColumnEncryptionAlgorithm.AEAD_AES_128_CBC_HMAC_SHA256;
            }
            throw new SQLException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5:" + field.getColumnEncryptType());
        }
        if (algorithm == EncryptionCommon.ColumnEncryptionAlgorithm.AEAD_AES_128_CBC_HMAC_SHA256) {
            if (this.logFlag) {
                Driver.writeLog("cek\u660e\u6587\uff1a" + cek.getKeyValueRaw());
            }
            byte[] after = EncryptionCommon.decryptKey_AES128_CBC_HMAC_SHA256(encryptKeyValue, cek.getKeyValueRaw(), this.vectorBytes);
            return new String(after, EncryptionCommon.ISO_8859_1);
        }
        if (algorithm == EncryptionCommon.ColumnEncryptionAlgorithm.AEAD_AES_256_CBC_HMAC_SHA256) {
            if (this.logFlag) {
                Driver.writeLog("cek\u660e\u6587\uff1a" + cek.getKeyValueRaw());
            }
            byte[] after = EncryptionCommon.decryptKey_AES256_CBC_HMAC_SHA256(encryptKeyValue, cek.getKeyValueRaw(), this.vectorBytes);
            return new String(after, EncryptionCommon.ISO_8859_1);
        }
        throw new SQLException("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5:" + field.getColumnEncryptType());
    }

    protected byte[] normalizeValue(byte[] encryptKeyValue) throws Exception {
        byte[] normalizeValue = new byte[encryptKeyValue.length - 4];
        System.arraycopy(encryptKeyValue, 4, normalizeValue, 0, normalizeValue.length);
        return normalizeValue;
    }

    protected Object invokeOriginalMethod(BaseResultSet delegate, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return method.invoke((Object)delegate, args);
    }
}

