/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.gis;

import com.oscar.gis.OscarObject;
import com.oscar.util.OscarTokenizer;
import com.oscar.util.converter.ByteConverter;
import java.awt.Point;
import java.io.Serializable;
import java.sql.SQLException;

public class OscarPoint
extends OscarObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -6446184397348989573L;
    protected double x;
    protected double y;

    public OscarPoint(double x, double y) {
        this();
        this.x = x;
        this.y = y;
    }

    public OscarPoint(String value) throws SQLException {
        this();
        this.setValue(value);
    }

    public OscarPoint() {
        this.setType("point");
    }

    @Override
    public void setValue(String s) throws SQLException {
        OscarTokenizer t = new OscarTokenizer(OscarTokenizer.removePara(s), ',');
        try {
            this.x = Double.parseDouble(t.getToken(0));
            this.y = Double.parseDouble(t.getToken(1));
        }
        catch (NumberFormatException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public void setByteValue(byte[] b, int offset) {
        this.x = ByteConverter.float8(b, offset);
        this.y = ByteConverter.float8(b, offset + 8);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OscarPoint) {
            OscarPoint p = (OscarPoint)obj;
            return this.x == p.x && this.y == p.y;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long v1 = Double.doubleToLongBits(this.x);
        long v2 = Double.doubleToLongBits(this.y);
        return (int)(v1 ^ v2 ^ v1 >>> 32 ^ v2 >>> 32);
    }

    @Override
    public String getValue() {
        return "(" + this.x + "," + this.y + ")";
    }

    public int lengthInBytes() {
        return 16;
    }

    public void toBytes(byte[] b, int offset) {
        ByteConverter.float8(b, offset, this.x);
        ByteConverter.float8(b, offset + 8, this.y);
    }

    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    public void translate(double x, double y) {
        this.x += x;
        this.y += y;
    }

    public void move(int x, int y) {
        this.setLocation(x, y);
    }

    public void move(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setLocation(int x, int y) {
        this.move((double)x, (double)y);
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }
}

