/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.replication.fluent;

import com.kingbase8.core.BaseConnection;
import com.kingbase8.core.ReplicationProtocol;
import com.kingbase8.replication.KBReplicationStream;
import com.kingbase8.replication.fluent.ChainedStreamBuilder;
import com.kingbase8.replication.fluent.logical.ChainedLogicalStreamBuilder;
import com.kingbase8.replication.fluent.logical.LogicalReplicationOptions;
import com.kingbase8.replication.fluent.logical.LogicalStreamBuilder;
import com.kingbase8.replication.fluent.logical.StartLogicalReplicationCallback;
import com.kingbase8.replication.fluent.physical.ChainedPhysicalStreamBuilder;
import com.kingbase8.replication.fluent.physical.PhysicalReplicationOptions;
import com.kingbase8.replication.fluent.physical.PhysicalStreamBuilder;
import com.kingbase8.replication.fluent.physical.StartPhysicalReplicationCallback;
import com.kingbase8.util.TraceLogger;
import java.sql.SQLException;
import java.util.logging.Level;

public class ReplicationStreamBuilder
implements ChainedStreamBuilder {
    private final BaseConnection baseConn;

    public ReplicationStreamBuilder(BaseConnection _connection) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.baseConn = _connection;
    }

    @Override
    public ChainedLogicalStreamBuilder logical() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new LogicalStreamBuilder(new StartLogicalReplicationCallback(){

            @Override
            public KBReplicationStream start(LogicalReplicationOptions options) throws SQLException {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConn.getReplicationProtocol();
                return protocol.startLogical(options);
            }
        });
    }

    @Override
    public ChainedPhysicalStreamBuilder physical() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new PhysicalStreamBuilder(new StartPhysicalReplicationCallback(){

            @Override
            public KBReplicationStream start(PhysicalReplicationOptions options) throws SQLException {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConn.getReplicationProtocol();
                return protocol.startPhysical(options);
            }
        });
    }
}

