/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.largeobject;

import java.io.IOException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class ClobWriter
extends Writer {
    private StringBuffer _buf;
    private Clob largeObj;
    private int bposition;
    private int clobposition;

    public ClobWriter(Clob largeObj, int position) {
        this.largeObj = largeObj;
        this.clobposition = position;
        this._buf = new StringBuffer();
        this.bposition = 0;
    }

    @Override
    public void write(int c) throws IOException {
        this._buf.append((char)c);
        this.write(this._buf.toString());
    }

    @Override
    public void write(char[] c_buf, int off, int leng) throws IOException {
        if (off < 0 || off > c_buf.length || leng < 0 || off + leng > c_buf.length || off + leng < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (leng == 0) {
            return;
        }
        this._buf.append(c_buf, off, leng);
        this.write(this._buf.toString());
    }

    @Override
    public void write(String str) throws IOException {
        this.checkIsClosed();
        try {
            if (this.bposition > 0) {
                this.flush();
            }
            this.largeObj.setString(this.clobposition, str);
            this.clobposition += str.length();
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    @Override
    public void write(String str, int off, int leng) throws IOException {
        this._buf.append(str.substring(off, off + leng));
        this.write(this._buf.toString());
    }

    @Override
    public ClobWriter append(CharSequence charSequence) throws IOException {
        if (charSequence == null) {
            this.write("null");
        } else {
            this.write(charSequence.toString());
        }
        return this;
    }

    @Override
    public ClobWriter append(CharSequence charSequence, int start, int end) throws IOException {
        CharSequence cs = charSequence == null ? "null" : charSequence;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public ClobWriter append(char c) throws IOException {
        this.write(c);
        return this;
    }

    public String toString() {
        return this._buf.toString();
    }

    public StringBuffer getBuffer() {
        return this._buf;
    }

    @Override
    public void flush() throws IOException {
        this.checkIsClosed();
        try {
            if (this.bposition > 0) {
                this.largeObj.setString(this.clobposition, String.valueOf(this._buf).trim(), 0, this.bposition);
                this.clobposition += this.bposition;
            }
            this.bposition = 0;
        }
        catch (SQLException se) {
            throw new IOException(se.toString());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.largeObj != null) {
            this.flush();
            this.largeObj = null;
        }
    }

    private void checkIsClosed() throws IOException {
        if (this.largeObj == null) {
            throw new IOException("ClobWriter is closed");
        }
    }
}

