/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.core.Field;
import com.kingbase8.core.ParameterList;
import com.kingbase8.core.Query;
import com.kingbase8.core.ResultCursor;
import com.kingbase8.core.ResultHandlerBase;
import com.kingbase8.core.v3.BatchedQuery;
import com.kingbase8.jdbc.KbResultSet;
import com.kingbase8.jdbc.KbStatement;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

public class BatchResultHandler
extends ResultHandlerBase {
    private final KbStatement kbStatement;
    private int _resultIndex = 0;
    private final Query[] queries;
    private final long[] _longUpdateCounts;
    private final ParameterList[] _parameterLists;
    private final boolean expectGeneratedKeysT;
    private KbResultSet generatedKeysT;
    private int committedRows;
    private final List<List<byte[][]>> _allGeneratedRows;
    private List<byte[][]> latestGeneratedRows;
    private KbResultSet latestGeneratedKeysRsT;

    BatchResultHandler(KbStatement kbStatement, Query[] queries, ParameterList[] _parameterLists, boolean expectGeneratedKeys) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStatement = kbStatement;
        this.queries = queries;
        this._parameterLists = _parameterLists;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._longUpdateCounts = new long[queries.length];
        this.expectGeneratedKeysT = expectGeneratedKeys;
        this._allGeneratedRows = !expectGeneratedKeys ? null : new ArrayList();
    }

    @Override
    public void handleResultRows(Query fromQuery, Field[] _fields, List<byte[][]> _tuples, ResultCursor cursor) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ++this._resultIndex;
        if (!this.expectGeneratedKeysT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        if (this.generatedKeysT == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.latestGeneratedKeysRsT = (KbResultSet)this.kbStatement.createResultSet(fromQuery, _fields, new ArrayList<byte[][]>(), cursor);
            }
            catch (SQLException e) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.handleError(e);
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.latestGeneratedRows = _tuples;
    }

    @Override
    public void handleResultRows(Query fromQuery, Field[] fields, List<byte[][]> tuples, ResultCursor cursor, boolean isLast) {
        this.handleResultRows(fromQuery, fields, tuples, cursor);
    }

    @Override
    public void handleCommandStatus(String status, long updateNum, long insertOID) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.latestGeneratedRows != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            --this._resultIndex;
            if (updateNum > 0L && (this.getException() == null || this.kbStatement.reWriteBind || this.isAutoCommit())) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this._allGeneratedRows.add(this.latestGeneratedRows);
                if (this.generatedKeysT == null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.generatedKeysT = this.latestGeneratedKeysRsT;
                }
            }
            this.latestGeneratedRows = null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._resultIndex >= this.queries.length) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.handleError(new KSQLException(GT.tr("Too many update _results were returned.", new Object[0]), KSQLState.TOO_MANY_RESULTS));
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.latestGeneratedKeysRsT = null;
        this._longUpdateCounts[this._resultIndex++] = updateNum;
    }

    private boolean isAutoCommit() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            return this.kbStatement.getConnection().getAutoCommit();
        }
        catch (SQLException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            assert (false) : "kbStatement.getConnection().getAutoCommit() should not throw";
            return false;
        }
    }

    @Override
    public void secureProgress() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.isAutoCommit()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.committedRows = this._resultIndex;
            this.updateGeneratedKeys();
        }
    }

    private void updateGeneratedKeys() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._allGeneratedRows == null || this._allGeneratedRows.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        for (List<byte[][]> rows : this._allGeneratedRows) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.generatedKeysT.addRows(rows);
        }
        this._allGeneratedRows.clear();
    }

    @Override
    public void handleWarning(SQLWarning _warning) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbStatement.addWarning(_warning);
    }

    @Override
    public void handleError(SQLException newError) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.getException() == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!this.kbStatement.reWriteBind) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Arrays.fill(this._longUpdateCounts, this.committedRows, this._longUpdateCounts.length, -3L);
                if (this._allGeneratedRows != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this._allGeneratedRows.clear();
                }
            }
            String queryString = "<unknown>";
            if (!this.kbStatement.reWriteBind) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this._resultIndex < this.queries.length) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    queryString = this.queries[this._resultIndex].toString(this._parameterLists[this._resultIndex]);
                }
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                queryString = this.queries[this._resultIndex].toString();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            BatchUpdateException batchexception = new BatchUpdateException(GT.tr("Batch entry {0} {1} was aborted: {2}  Call getNextException to see other _errors in the batch.", this._resultIndex, queryString, newError.getMessage()), newError.getSQLState(), 0, this._uncompressLongUpdateCount(), (Throwable)newError);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            super.handleError(batchexception);
        }
        if (!this.kbStatement.reWriteBind) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ++this._resultIndex;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        super.handleError(newError);
    }

    @Override
    public void handleCompletion() throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.updateGeneratedKeys();
        SQLException batchexception = this.getException();
        if (batchexception != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.kbStatement.reWriteBind || this.isAutoCommit()) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                BatchUpdateException newException = new BatchUpdateException(batchexception.getMessage(), batchexception.getSQLState(), 0, this._uncompressLongUpdateCount(), batchexception.getCause());
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                SQLException next = batchexception.getNextException();
                if (next != null) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    newException.setNextException(next);
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                batchexception = newException;
            }
            throw batchexception;
        }
    }

    public ResultSet getGeneratedKeys() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.generatedKeysT;
    }

    private int[] uncompressUpdateCount_() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long[] originT = this._uncompressLongUpdateCount();
        int[] copyT = new int[originT.length];
        for (int i = 0; i < originT.length; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            copyT[i] = originT[i] > Integer.MAX_VALUE ? -2 : (int)originT[i];
        }
        return copyT;
    }

    public int[] getUpdateCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.uncompressUpdateCount_();
    }

    private long[] _uncompressLongUpdateCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!(this.queries[0] instanceof BatchedQuery)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this._longUpdateCounts;
        }
        int _totalRows = 0;
        boolean hasRewritesT = false;
        for (Query query : this.queries) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int batchSize = query.getBatchSize();
            _totalRows += batchSize;
            hasRewritesT |= batchSize > 1;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!hasRewritesT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return this._longUpdateCounts;
        }
        long[] newUpdateCountsT = new long[_totalRows];
        int _offset = 0;
        for (int i = 0; i < this.queries.length; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Query queryT = this.queries[i];
            int batchSizeT = queryT.getBatchSize();
            long superBatchResult = this._longUpdateCounts[i];
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (batchSizeT == 1) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                newUpdateCountsT[_offset++] = superBatchResult;
                continue;
            }
            if (superBatchResult > 0L) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                superBatchResult = -2L;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Arrays.fill(newUpdateCountsT, _offset, _offset + batchSizeT, superBatchResult);
            _offset += batchSizeT;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return newUpdateCountsT;
    }

    public long[] getLargeUpdateCount() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._uncompressLongUpdateCount();
    }
}

