/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.geometric;

import com.kingbase8.geometric.KBpoint;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KBtokenizer;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.logging.Level;

public class KBlseg
extends KBobject
implements Serializable,
Cloneable {
    public KBpoint[] pointArray = new KBpoint[2];

    public KBlseg(double x1, double y1, double x2, double y2) {
        this(new KBpoint(x1, y1), new KBpoint(x2, y2));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public KBlseg(KBpoint point1, KBpoint point2) {
        this();
        this.pointArray[0] = point1;
        this.pointArray[1] = point2;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public KBlseg(String value) throws SQLException {
        this();
        this.setValue(value);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public KBlseg() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setType("lseg");
    }

    @Override
    public void setValue(String value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBtokenizer t = new KBtokenizer(KBtokenizer.removeBox(value), ',');
        if (t.getSize() != 2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Con_version to type {0} failed: {1}.", this.type, value), KSQLState.DATA_TYPE_MISMATCH);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.pointArray[0] = new KBpoint(t.getToken(0));
        this.pointArray[1] = new KBpoint(t.getToken(1));
    }

    @Override
    public boolean equals(Object objt) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean v = false;
        if (objt instanceof KBlseg) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            KBlseg lseg = (KBlseg)objt;
            return lseg.pointArray[0].equals(this.pointArray[0]) && lseg.pointArray[1].equals(this.pointArray[1]) || lseg.pointArray[0].equals(this.pointArray[1]) && lseg.pointArray[1].equals(this.pointArray[0]);
        }
        return v;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBlseg newKBlseg = (KBlseg)super.clone();
        if (newKBlseg.pointArray != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            newKBlseg.pointArray = (KBpoint[])newKBlseg.pointArray.clone();
            for (int i = 0; i < newKBlseg.pointArray.length; ++i) {
                if (newKBlseg.pointArray[i] == null) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                newKBlseg.pointArray[i] = (KBpoint)newKBlseg.pointArray[i].clone();
            }
        }
        return newKBlseg;
    }

    @Override
    public int hashCode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.pointArray[1].hashCode() ^ this.pointArray[0].hashCode();
    }

    @Override
    public String getValue() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return "[" + this.pointArray[0] + "," + this.pointArray[1] + "]";
    }
}

