/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.geometric;

import com.kingbase8.geometric.KBpoint;
import com.kingbase8.util.GT;
import com.kingbase8.util.KBBinaryObject;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KBtokenizer;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.logging.Level;

public class KBbox
extends KBobject
implements KBBinaryObject,
Serializable,
Cloneable {
    public KBpoint[] point = new KBpoint[2];

    public KBbox(double x1, double y1, double x2, double y2) {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.point[0] = new KBpoint(x1, y1);
        this.point[1] = new KBpoint(x2, y2);
    }

    public KBbox(KBpoint p1, KBpoint p2) {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.point[0] = p1;
        this.point[1] = p2;
    }

    public KBbox(String s) throws SQLException {
        this();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setValue(s);
    }

    public KBbox() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.setType("box");
    }

    @Override
    public void setValue(String _value) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBtokenizer t = new KBtokenizer(_value, ',');
        if (t.getSize() != 2) {
            throw new KSQLException(GT.tr("Con_version to type {0} failed: {1}.", this.type, _value), KSQLState.DATA_TYPE_MISMATCH);
        }
        this.point[0] = new KBpoint(t.getToken(0));
        this.point[1] = new KBpoint(t.getToken(1));
    }

    @Override
    public void setByteValue(byte[] b, int _offset) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.point[0] = new KBpoint();
        this.point[0].setByteValue(b, _offset);
        this.point[1] = new KBpoint();
        this.point[1].setByteValue(b, _offset + this.point[0].lengthInBytes());
    }

    @Override
    public boolean equals(Object objt) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (objt instanceof KBbox) {
            KBbox pnt = (KBbox)objt;
            if (pnt.point[0].equals(this.point[0]) && pnt.point[1].equals(this.point[1])) {
                return true;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (pnt.point[0].equals(this.point[1]) && pnt.point[1].equals(this.point[0])) {
                return true;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (pnt.point[0].x == this.point[0].x && pnt.point[0].y == this.point[1].y && pnt.point[1].x == this.point[1].x && pnt.point[1].y == this.point[0].y) {
                return true;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (pnt.point[0].x == this.point[1].x && pnt.point[0].y == this.point[0].y && pnt.point[1].x == this.point[0].x && pnt.point[1].y == this.point[1].y) {
                return true;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return false;
    }

    @Override
    public int hashCode() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.point[0].hashCode() ^ this.point[1].hashCode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBbox newKBbox = (KBbox)super.clone();
        if (newKBbox.point != null) {
            newKBbox.point = (KBpoint[])newKBbox.point.clone();
            for (int i = 0; i < newKBbox.point.length; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (newKBbox.point[i] == null) continue;
                newKBbox.point[i] = (KBpoint)newKBbox.point[i].clone();
            }
        }
        return newKBbox;
    }

    @Override
    public String getValue() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.point[0].toString() + "," + this.point[1].toString();
    }

    @Override
    public int lengthInBytes() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.point[0].lengthInBytes() + this.point[1].lengthInBytes();
    }

    @Override
    public void toBytes(byte[] _bytes, int _offset) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.point[0].toBytes(_bytes, _offset);
        this.point[1].toBytes(_bytes, _offset + this.point[0].lengthInBytes());
    }
}

