/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core;

import com.kingbase8.core.Encoding;
import com.kingbase8.core.EncodingPredictor;
import com.kingbase8.core.KBBindException;
import com.kingbase8.core.VisibleBufferedInputStream;
import com.kingbase8.dispatcher.core.ConnectionMangerV2;
import com.kingbase8.util.DataCompress;
import com.kingbase8.util.GT;
import com.kingbase8.util.HostSpec;
import com.kingbase8.util.KBByteBuffer;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.net.SocketFactory;

public class KBStream
implements Closeable,
Flushable {
    private final SocketFactory socketFactory;
    private final HostSpec _hostSpec;
    private final byte[] int4Buffer;
    private final byte[] int2Buffer;
    private Socket connectionSocket;
    private VisibleBufferedInputStream kbInput;
    private OutputStream kbOutput;
    private byte[] streamBufferT;
    private long nextStreamAvailableCheckTime;
    private int minStreamAvailableCheckDelay = 1000;
    private Encoding _encoding;
    private Writer _encodingWriter;
    private boolean useDispatch;
    private int _version;
    public ConnectionMangerV2 pCMV2;
    private int zipLevel = 0;
    private int compressLevel = 0;
    private int compressMin = 128;
    private int socketBufferSize = 8192;
    private byte[] input_cache;
    private int receivePos = 0;
    private KBByteBuffer output_cache = new KBByteBuffer();

    public KBStream(SocketFactory socketFactory, HostSpec _hostSpec, int _timeout, boolean useDispatch, int _version, Object cCMV2) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.socketFactory = socketFactory;
        this._hostSpec = _hostSpec;
        this.useDispatch = useDispatch;
        this._version = _version;
        this.pCMV2 = (ConnectionMangerV2)cCMV2;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Socket socketT = socketFactory.createSocket();
        if (!socketT.isConnected()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            InetSocketAddress address = _hostSpec.shouldResolve() != false ? new InetSocketAddress(_hostSpec.getHost(), _hostSpec.getPort()) : InetSocketAddress.createUnresolved(_hostSpec.getHost(), _hostSpec.getPort());
            socketT.connect(address, _timeout);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.changeSocket(socketT);
        this.setEncoding(Encoding.getJVMEncoding("UTF-8"));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.int2Buffer = new byte[2];
        this.int4Buffer = new byte[4];
    }

    @Deprecated
    public KBStream(SocketFactory socketFactory, HostSpec _hostSpec) throws IOException {
        this(socketFactory, _hostSpec, 0, false, -1, null);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public HostSpec getHostSpec() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._hostSpec;
    }

    public boolean isUseDispatch() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.useDispatch;
    }

    public int getVersion() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._version;
    }

    public Socket getSocket() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.connectionSocket;
    }

    public SocketFactory getSocketFactory() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMessagePending() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean avail = false;
        if (this.kbInput.available() > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return true;
        }
        long now = System.nanoTime() / 1000000L;
        if (now < this.nextStreamAvailableCheckTime && this.minStreamAvailableCheckDelay != 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int socketTimeout = this.getNetworkTimeout();
        this.setNetworkTimeout(1);
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            avail = this.kbInput.peek() != -1;
        }
        catch (SocketTimeoutException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            boolean bl = false;
            return bl;
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setNetworkTimeout(socketTimeout);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!avail) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.nextStreamAvailableCheckTime = now + (long)this.minStreamAvailableCheckDelay;
        }
        return avail;
    }

    public void setMinStreamAvailableCheckDelay(int delay) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.minStreamAvailableCheckDelay = delay;
    }

    public void changeSocket(Socket socket) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.connectionSocket = socket;
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.connectionSocket.setTcpNoDelay(true);
        }
        catch (SocketException e) {
            KBLOGGER.log(Level.FINEST, "Ignoring exception on unix domain socket:", e);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String nodename = "";
        if (this.pCMV2 != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            nodename = this.pCMV2.nodeMap.get(this._hostSpec.getHost() + ":" + this._hostSpec.getPort());
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbInput = new VisibleBufferedInputStream(this.connectionSocket.getInputStream(), this.socketBufferSize, nodename, this.useDispatch, this._version, this.pCMV2);
        this.kbOutput = new BufferedOutputStream(this.connectionSocket.getOutputStream(), this.socketBufferSize);
        if (this._encoding != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.setEncoding(this._encoding);
        }
    }

    public void setSocketTimeout(int socketTimeout) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbInput.setSocketTimeout(socketTimeout);
    }

    public Encoding getEncoding() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._encoding;
    }

    public void setEncoding(Encoding _encoding) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._encoding != null && this._encoding.name().equals(_encoding.name())) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        if (this._encodingWriter != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._encodingWriter.close();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._encoding = _encoding;
        FilterOutputStream interceptor = new FilterOutputStream(this.kbOutput){

            @Override
            public void flush() throws IOException {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }

            @Override
            public void close() throws IOException {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                super.flush();
            }
        };
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this._encodingWriter = _encoding.getEncodingWriter(interceptor);
    }

    public Writer getEncodingWriter() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._encodingWriter == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IOException("No _encoding has been set on this _connection");
        }
        return this._encodingWriter;
    }

    public void sendChar(int value) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.zipLevel > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte[] temp = new byte[]{(byte)value};
            this.writeCache(temp, 0, 1);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.kbOutput.write(value);
        }
    }

    public void sendInteger4(int value) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.int4Buffer[0] = (byte)(value >>> 24);
        this.int4Buffer[1] = (byte)(value >>> 16);
        this.int4Buffer[2] = (byte)(value >>> 8);
        this.int4Buffer[3] = (byte)value;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.zipLevel > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.writeCache(this.int4Buffer, 0, 4);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.kbOutput.write(this.int4Buffer);
        }
    }

    public void sendInteger42(int val) throws IOException {
        this.int4Buffer[3] = (byte)(val >>> 24);
        this.int4Buffer[2] = (byte)(val >>> 16);
        this.int4Buffer[1] = (byte)(val >>> 8);
        this.int4Buffer[0] = (byte)val;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.zipLevel > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.writeCache(this.int4Buffer, 0, 4);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.kbOutput.write(this.int4Buffer);
        }
    }

    public void sendInteger2(int value) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (value < 0 || value > 65535) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IOException("Tried to send an out-of-range integer as a 2-byte _value: " + value);
        }
        this.int2Buffer[0] = (byte)(value >>> 8);
        this.int2Buffer[1] = (byte)value;
        if (this.zipLevel > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.writeCache(this.int2Buffer, 0, 2);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.kbOutput.write(this.int2Buffer);
        }
    }

    public void send(byte[] _buf) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.zipLevel > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int leng = 0;
            while (_buf.length - leng >= this.socketBufferSize) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.writeCache(_buf, leng, this.socketBufferSize);
                leng += this.socketBufferSize;
            }
            this.writeCache(_buf, leng, _buf.length - leng);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.kbOutput.write(_buf);
        }
    }

    public void send(byte[] _buf, int siz) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.send(_buf, 0, siz);
    }

    public void send(byte[] _buf, int off, int siz) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.zipLevel > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int leng = 0;
            while (siz - leng >= this.socketBufferSize) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.writeCache(_buf, off + leng, this.socketBufferSize);
                leng += this.socketBufferSize;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.writeCache(_buf, off + leng, siz - leng);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int _bufamt = _buf.length - off;
            this.kbOutput.write(_buf, off, _bufamt < siz ? _bufamt : siz);
            for (int i = _bufamt; i < siz; ++i) {
                this.kbOutput.write(0);
            }
        }
    }

    public int peekChar() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.zipLevel > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte ch = 0;
            if (this.input_cache == null || this.receivePos == this.input_cache.length) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.receiveData();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ch = this.input_cache[this.receivePos];
            return ch;
        }
        int ch = this.kbInput.peek();
        if (ch < 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new EOFException();
        }
        return ch;
    }

    public int receiveChar() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.zipLevel > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte ch = 0;
            if (this.input_cache == null || this.receivePos == this.input_cache.length) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.receiveData();
            }
            ch = this.input_cache[this.receivePos++];
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return ch;
        }
        int ch = this.kbInput.read();
        if (ch < 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new EOFException();
        }
        return ch;
    }

    public int receiveInteger4() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.zipLevel > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int i = 0;
            while (i < 4) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this.input_cache == null || this.receivePos == this.input_cache.length) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.receiveData();
                }
                this.int4Buffer[i++] = this.input_cache[this.receivePos++];
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.kbInput.read(this.int4Buffer) != 4) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new EOFException();
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (this.int4Buffer[0] & 0xFF) << 24 | (this.int4Buffer[1] & 0xFF) << 16 | (this.int4Buffer[2] & 0xFF) << 8 | this.int4Buffer[3] & 0xFF;
    }

    public int receiveInteger42() throws IOException {
        if (this.zipLevel > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int i = 0;
            while (i < 4) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this.input_cache == null || this.receivePos == this.input_cache.length) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.receiveData();
                }
                this.int4Buffer[i++] = this.input_cache[this.receivePos++];
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.kbInput.read(this.int4Buffer) != 4) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new EOFException();
            }
        }
        return (this.int4Buffer[3] & 0xFF) << 24 | (this.int4Buffer[2] & 0xFF) << 16 | (this.int4Buffer[1] & 0xFF) << 8 | this.int4Buffer[0] & 0xFF;
    }

    public int receiveInteger2() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.zipLevel > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int i = 0;
            while (i < 2) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this.input_cache == null || this.receivePos == this.input_cache.length) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.receiveData();
                }
                this.int2Buffer[i++] = this.input_cache[this.receivePos++];
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.kbInput.read(this.int2Buffer) != 2) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new EOFException();
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (this.int2Buffer[0] & 0xFF) << 8 | this.int2Buffer[1] & 0xFF;
    }

    public String receiveString(int leng) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.zipLevel > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte[] _result = this.receive(leng);
            String res = this._encoding.decode(_result, 0, leng);
            return res;
        }
        if (!this.kbInput.ensureBytes(leng)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new EOFException();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String res = this._encoding.decode(this.kbInput.getBuffer(), this.kbInput.getIndex(), leng);
        this.kbInput.skip(leng);
        return res;
    }

    public EncodingPredictor.DecodeResult receiveErrorString(int leng) throws IOException {
        EncodingPredictor.DecodeResult res;
        block7: {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.zipLevel > 0) {
                EncodingPredictor.DecodeResult res2;
                block6: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    byte[] _result = this.receive(leng);
                    try {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        String _value = this._encoding.decode(_result, 0, leng);
                        res2 = new EncodingPredictor.DecodeResult(_value, null);
                    }
                    catch (IOException e) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        res2 = EncodingPredictor.decode(_result, 0, leng);
                        if (res2 != null) break block6;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        Encoding enc = Encoding.defaultEncoding();
                        String _value = enc.decode(_result, 0, leng);
                        res2 = new EncodingPredictor.DecodeResult(_value, enc.name());
                    }
                }
                return res2;
            }
            if (!this.kbInput.ensureBytes(leng)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new EOFException();
            }
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                String _value = this._encoding.decode(this.kbInput.getBuffer(), this.kbInput.getIndex(), leng);
                res = new EncodingPredictor.DecodeResult(_value, null);
            }
            catch (IOException e) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                res = EncodingPredictor.decode(this.kbInput.getBuffer(), this.kbInput.getIndex(), leng);
                if (res != null) break block7;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Encoding enc = Encoding.defaultEncoding();
                String _value = enc.decode(this.kbInput.getBuffer(), this.kbInput.getIndex(), leng);
                res = new EncodingPredictor.DecodeResult(_value, enc.name());
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbInput.skip(leng);
        return res;
    }

    public String receiveString() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.zipLevel > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int strLen = this.socketBufferSize;
            byte[] strVal = new byte[strLen];
            int i = 0;
            byte ch = 1;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while (ch != 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (i == strLen + 1) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    byte[] newValue = new byte[strLen *= 2];
                    System.arraycopy(strVal, 0, newValue, 0, strVal.length);
                    strVal = newValue;
                }
                if (this.input_cache == null || this.receivePos == this.input_cache.length) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.receiveData();
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int n = i++;
                byte by = this.input_cache[this.receivePos++];
                strVal[n] = by;
                ch = by;
            }
            return this._encoding.decode(strVal, 0, i - 1);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int leng = this.kbInput.scanCStringLength();
        String res = this._encoding.decode(this.kbInput.getBuffer(), this.kbInput.getIndex(), leng - 1);
        this.kbInput.skip(leng);
        return res;
    }

    public byte[][] receiveTupleV3() throws IOException, OutOfMemoryError {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.receiveInteger4();
        int integer2 = this.receiveInteger2();
        byte[][] answerT = new byte[integer2][];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        OutOfMemoryError outOfMemoryError = null;
        for (int i = 0; i < integer2; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int sizeT = this.receiveInteger4();
            if (sizeT == -1) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                answerT[i] = new byte[sizeT];
                this.receive(answerT[i], 0, sizeT);
                continue;
            }
            catch (OutOfMemoryError outOfMemoryErrore) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                outOfMemoryError = outOfMemoryErrore;
                if (this.zipLevel > 0) {
                    throw outOfMemoryError;
                }
                this.skip(sizeT);
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (outOfMemoryError != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw outOfMemoryError;
        }
        return answerT;
    }

    public byte[] receive(int siz) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] answer = new byte[siz];
        this.receive(answer, 0, siz);
        return answer;
    }

    public void receive(byte[] _buf, int off, int size) throws IOException {
        int wT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.zipLevel > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int i = 0;
            while (i++ < size) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (this.input_cache == null || this.receivePos == this.input_cache.length) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.receiveData();
                }
                _buf[off++] = this.input_cache[this.receivePos++];
            }
            return;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (int sT = 0; sT < size; sT += wT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            wT = this.kbInput.read(_buf, off + sT, size - sT);
            if (wT >= 0) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new EOFException();
        }
    }

    public void skip(int size) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.zipLevel > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.skipCache(size);
            return;
        }
        for (long sT = 0L; sT < (long)size; sT += this.kbInput.skip((long)size - sT)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
    }

    public void sendStream(InputStream inputStream, int remainingT) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int expectedLengthT = remainingT;
        if (this.streamBufferT == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.streamBufferT = new byte[this.socketBufferSize];
        }
        while (remainingT > 0) {
            int readCountNum;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int countNum = remainingT > this.streamBufferT.length ? this.streamBufferT.length : remainingT;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                readCountNum = inputStream.read(this.streamBufferT, 0, countNum);
                if (readCountNum < 0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    throw new EOFException(GT.tr("Premature end of input stream, expected {0} _bytes, but only read {1}.", expectedLengthT, expectedLengthT - remainingT));
                }
            }
            catch (IOException ioException) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                while (remainingT > 0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.send(this.streamBufferT, countNum);
                    countNum = (remainingT -= countNum) > this.streamBufferT.length ? this.streamBufferT.length : remainingT;
                }
                throw new KBBindException(ioException);
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.send(this.streamBufferT, readCountNum);
            remainingT -= readCountNum;
        }
    }

    @Override
    public void flush() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.zipLevel > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.flushCache();
        }
        if (this._encodingWriter != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._encodingWriter.flush();
        }
        this.kbOutput.flush();
    }

    public void receiveEOF() throws SQLException, IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int ch = 0;
        if (this.zipLevel > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.input_cache == null || this.receivePos == this.input_cache.length) {
                try {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this.receiveData();
                }
                catch (EOFException e) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return;
                }
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ch = this.input_cache[this.receivePos++];
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ch = this.kbInput.read();
            if (ch < 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        throw new KSQLException(GT.tr("Expected an EOF from server, got: {0}", ch), KSQLState.COMMUNICATION_ERROR);
    }

    @Override
    public void close() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this._encodingWriter != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this._encodingWriter.close();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.kbOutput.close();
        this.kbInput.close();
        this.connectionSocket.close();
    }

    public void setNetworkTimeout(int millisecs) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.isUseDispatch()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.connectionSocket.setSoTimeout(1000);
            this.setSocketTimeout(millisecs % 1000 == 0 ? millisecs / 1000 : millisecs / 1000 + 1);
            KBLOGGER.log(Level.INFO, "Dispatch : socketTimeout is " + millisecs, new Object[0]);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.connectionSocket.setSoTimeout(millisecs);
            KBLOGGER.log(Level.INFO, "Single or Monitor : socketTimeout is " + millisecs, new Object[0]);
        }
    }

    public int getNetworkTimeout() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.connectionSocket.getSoTimeout();
    }

    public void sendData(byte[] data) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        byte[] zip = data;
        if (data.length > this.compressMin) {
            zip = DataCompress.packMessage(data, this.zipLevel);
        }
        int zipLen = zip.length;
        int siz = 4;
        byte[] _buf = new byte[siz];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        while (siz-- > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _buf[siz] = (byte)(zipLen & 0xFF);
            zipLen >>= 8;
        }
        int compressIdentificationSize = 1;
        byte[] identification = new byte[compressIdentificationSize];
        this.kbOutput.write(_buf);
        identification[0] = data.length > this.compressMin ? (byte)1 : 0;
        this.kbOutput.write(identification);
        this.kbOutput.write(zip);
    }

    public void receiveData() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            int w;
            int size = 0;
            for (int i = 0; i < 4; ++i) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int b = this.kbInput.read();
                if (b < 0) {
                    throw new EOFException();
                }
                size = b | size << 8;
            }
            int compressIdentification = this.kbInput.read();
            if (size > this.socketBufferSize) {
                throw new IOException(" zipLevel: " + this.zipLevel + ", incompatible compression version please update the driver");
            }
            byte[] temp = new byte[size];
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (int s = 0; s < size; s += w) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                w = this.kbInput.read(temp, s, size - s);
                if (w >= 0) continue;
                throw new EOFException();
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.input_cache = compressIdentification == 1 ? DataCompress.unPackMessage(temp) : temp;
        }
        catch (IOException e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw e;
        }
        this.receivePos = 0;
    }

    public void flushCache() throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.output_cache.getEndPos() > 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.sendData(this.output_cache.getBuffer());
            this.output_cache.clear();
        }
    }

    public void skipCache(int leng) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int i = 0;
        while (i < leng) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (this.input_cache == null || this.receivePos == this.input_cache.length) {
                this.receiveData();
                continue;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int l = this.input_cache.length - this.receivePos;
            if (l >= leng) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.receivePos += leng;
                i += leng;
                continue;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.receivePos = this.input_cache.length;
            i += l;
        }
    }

    public void writeCache(byte[] _buf, int off, int siz) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (this.output_cache.getEndPos() + siz > this.socketBufferSize) {
            this.flushCache();
        }
        if (_buf.length - off >= siz) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.output_cache.copy(_buf, off, siz);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            byte[] temp = new byte[siz + off - _buf.length];
            this.output_cache.copy(_buf, off, _buf.length - off);
            this.output_cache.copy(temp, 0, temp.length);
        }
    }

    public void setZipLevel(int zipLevel) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.zipLevel = zipLevel;
    }

    public void setCompressLevel(int compressLevel) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.compressLevel = compressLevel;
    }

    public void setCompressMin(int compressMin) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.compressMin = compressMin;
    }

    public void setSocketBufferSize(int socketBufferSize) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.socketBufferSize = socketBufferSize;
    }

    public void setOutPutCache(KBByteBuffer kbByteBuffer) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.output_cache = kbByteBuffer;
    }
}

