/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core;

import com.kingbase8.core.UTF8Encoding;
import com.kingbase8.util.KBLOGGER;
import com.kingbase8.util.TraceLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.logging.Level;

public class Encoding {
    private static final HashMap<String, String[]> encodingsMap = new HashMap();
    private static final Encoding UTF8_ENCODING_T = new Encoding("UTF-8");
    private static final Encoding DEFAULT_ENCODING_T = new Encoding();
    private final String _encoding;
    private final boolean fastASCIINumbers;

    private Encoding() {
        this(Charset.defaultCharset().name());
    }

    protected Encoding(String _encoding, boolean fastASCIINumbers) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_encoding == null) {
            throw new NullPointerException("Null _encoding charset not supported");
        }
        this._encoding = _encoding;
        this.fastASCIINumbers = fastASCIINumbers;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (KBLOGGER.isLoggable(Level.FINEST)) {
            KBLOGGER.log(Level.FINEST, "Creating new Encoding {0} with fastASCIINumbers {1}", _encoding, fastASCIINumbers);
        }
    }

    protected Encoding(String _encoding) {
        this(_encoding, Encoding.testAsciiNumbers(_encoding));
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
    }

    public boolean hasAsciiNumbers() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.fastASCIINumbers;
    }

    public static Encoding getJVMEncoding(String encoding) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if ("UTF-8".equals(encoding)) {
            return new UTF8Encoding();
        }
        if (Charset.isSupported(encoding)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new Encoding(encoding);
        }
        return DEFAULT_ENCODING_T;
    }

    public static Encoding getDatabaseEncoding(String databaseEncoding) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if ("UTF8".equals(databaseEncoding)) {
            return UTF8_ENCODING_T;
        }
        String[] candidates = encodingsMap.get(databaseEncoding);
        if (candidates != null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (String candidate : candidates) {
                KBLOGGER.log(Level.FINEST, "Search _encoding candidate {0}", candidate);
                if (!Charset.isSupported(candidate)) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return new Encoding(candidate);
            }
        }
        if (Charset.isSupported(databaseEncoding)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new Encoding(databaseEncoding);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        KBLOGGER.log(Level.FINEST, "{0} _encoding not found, returning default _encoding", databaseEncoding);
        return DEFAULT_ENCODING_T;
    }

    public String name() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return Charset.isSupported(this._encoding) ? Charset.forName(this._encoding).name() : this._encoding;
    }

    public byte[] encode(String s) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (s == null) {
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return s.getBytes(this._encoding);
    }

    public String decode(byte[] _encodedString, int _offset, int length) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new String(_encodedString, _offset, length, this._encoding);
    }

    public String decode(byte[] _encodedString) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this.decode(_encodedString, 0, _encodedString.length);
    }

    public Reader getDecodingReader(InputStream in) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new InputStreamReader(in, this._encoding);
    }

    public Writer getEncodingWriter(OutputStream out) throws IOException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return new OutputStreamWriter(out, this._encoding);
    }

    public static Encoding defaultEncoding() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return DEFAULT_ENCODING_T;
    }

    public String toString() {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return this._encoding;
    }

    private static boolean testAsciiNumbers(String _encoding) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            String test = "-0123456789";
            byte[] _bytes = test.getBytes(_encoding);
            String res = new String(_bytes, "US-ASCII");
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return test.equals(res);
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }

    static {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        encodingsMap.put("SQL_ASCII", new String[]{"ASCII", "US-ASCII"});
        encodingsMap.put("UNICODE", new String[]{"UTF-8", "UTF8"});
        encodingsMap.put("UTF8", new String[]{"UTF-8", "UTF8"});
        encodingsMap.put("LATIN1", new String[]{"ISO8859_1"});
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        encodingsMap.put("LATIN2", new String[]{"ISO8859_2"});
        encodingsMap.put("LATIN3", new String[]{"ISO8859_3"});
        encodingsMap.put("LATIN4", new String[]{"ISO8859_4"});
        encodingsMap.put("ISO_8859_5", new String[]{"ISO8859_5"});
        encodingsMap.put("ISO_8859_6", new String[]{"ISO8859_6"});
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        encodingsMap.put("ISO_8859_7", new String[]{"ISO8859_7"});
        encodingsMap.put("ISO_8859_8", new String[]{"ISO8859_8"});
        encodingsMap.put("LATIN5", new String[]{"ISO8859_9"});
        encodingsMap.put("LATIN7", new String[]{"ISO8859_13"});
        encodingsMap.put("LATIN9", new String[]{"ISO8859_15_FDIS"});
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        encodingsMap.put("EUC_JP", new String[]{"EUC_JP"});
        encodingsMap.put("EUC_CN", new String[]{"EUC_CN"});
        encodingsMap.put("EUC_KR", new String[]{"EUC_KR"});
        encodingsMap.put("JOHAB", new String[]{"Johab"});
        encodingsMap.put("EUC_TW", new String[]{"EUC_TW"});
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        encodingsMap.put("SJIS", new String[]{"MS932", "SJIS"});
        encodingsMap.put("BIG5", new String[]{"Big5", "MS950", "Cp950"});
        encodingsMap.put("GBK", new String[]{"GBK", "MS936"});
        encodingsMap.put("UHC", new String[]{"MS949", "Cp949", "Cp949C"});
        encodingsMap.put("TCVN", new String[]{"Cp1258"});
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        encodingsMap.put("WIN1256", new String[]{"Cp1256"});
        encodingsMap.put("WIN1250", new String[]{"Cp1250"});
        encodingsMap.put("WIN874", new String[]{"MS874", "Cp874"});
        encodingsMap.put("WIN", new String[]{"Cp1251"});
        encodingsMap.put("ALT", new String[]{"Cp866"});
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        encodingsMap.put("KOI8", new String[]{"KOI8_U", "KOI8_R"});
        encodingsMap.put("UNKNOWN", new String[0]);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        encodingsMap.put("MULE_INTERNAL", new String[0]);
        encodingsMap.put("LATIN6", new String[0]);
        encodingsMap.put("LATIN8", new String[0]);
        encodingsMap.put("LATIN10", new String[0]);
    }
}

