/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.nacos.datasource.plugin.kingbase.impl;

import java.util.HashMap;
import java.util.Map;

public enum TrustedKingBaseFunctionEnum {
    NOW("NOW()", "CURRENT_TIMESTAMP");

    private static final Map<String, TrustedKingBaseFunctionEnum> LOOKUP_MAP;
    private final String functionName;
    private final String function;

    private TrustedKingBaseFunctionEnum(String functionName, String function) {
        this.functionName = functionName;
        this.function = function;
    }

    public static String getFunctionByName(String functionName) {
        TrustedKingBaseFunctionEnum entry = LOOKUP_MAP.get(functionName);
        if (entry != null) {
            return entry.function;
        }
        throw new IllegalArgumentException(String.format("Invalid function name: %s", functionName));
    }

    static {
        LOOKUP_MAP = new HashMap<String, TrustedKingBaseFunctionEnum>();
        for (TrustedKingBaseFunctionEnum entry : TrustedKingBaseFunctionEnum.values()) {
            LOOKUP_MAP.put(entry.functionName, entry);
        }
    }
}

