/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.util;

import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;

public class StreamWrapper {
    private static final int MAX_MEMORY_BUFFER_BYTES_T = 51200;
    private static final String TEMP_FILE_PREFIX = "kingbase8-kbjdbc-stream";
    private final InputStream streamT;
    private final byte[] rawdataT;
    private final int _offset;
    private final int lengthT;

    public StreamWrapper(byte[] data, int _offset, int length) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.streamT = null;
        this.rawdataT = data;
        this._offset = _offset;
        this.lengthT = length;
    }

    public StreamWrapper(InputStream stream, int length) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        this.streamT = stream;
        this.rawdataT = null;
        this._offset = 0;
        this.lengthT = length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamWrapper(InputStream stream) throws KSQLException {
        block8: {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            try {
                ByteArrayOutputStream memoryOutputStream = new ByteArrayOutputStream();
                int memoryLength = StreamWrapper.copyStream(stream, memoryOutputStream, 51200);
                byte[] rawdata = memoryOutputStream.toByteArray();
                if (memoryLength == -1) {
                    int diskLength;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    boolean jdkVersionSupport = false;
                    jdkVersionSupport = true;
                    File intermediateFile = null;
                    intermediateFile = jdkVersionSupport ? Files.createTempFile(TEMP_FILE_PREFIX, null, new FileAttribute[0]).toFile() : File.createTempFile(TEMP_FILE_PREFIX, null);
                    final File tmpFile = intermediateFile;
                    diskOutputStream.write(rawdata);
                    try (FileOutputStream diskOutputStream = new FileOutputStream(tmpFile);){
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        diskLength = StreamWrapper.copyStream(stream, diskOutputStream, Integer.MAX_VALUE - rawdata.length);
                        if (diskLength == -1) {
                            throw new KSQLException(GT.tr("Object is too large to send over the protocol.", new Object[0]), KSQLState.NUMERIC_CONSTANT_OUT_OF_RANGE);
                        }
                        diskOutputStream.flush();
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    this._offset = 0;
                    this.lengthT = rawdata.length + diskLength;
                    this.rawdataT = null;
                    this.streamT = new FileInputStream(tmpFile){
                        private boolean hasClosed;
                        private int pos;
                        {
                            super(x0);
                            this.hasClosed = false;
                            this.pos = 0;
                        }

                        private void checkShouldClose_(int readResultT) throws IOException {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            if (readResultT == -1) {
                                this.close();
                            } else {
                                this.pos += readResultT;
                                if (this.pos >= StreamWrapper.this.lengthT) {
                                    this.close();
                                }
                            }
                        }

                        @Override
                        public int read(byte[] bytes) throws IOException {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            if (this.hasClosed) {
                                return -1;
                            }
                            int _result = super.read(bytes);
                            this.checkShouldClose_(_result);
                            return _result;
                        }

                        @Override
                        public int read(byte[] bytes, int off, int leng) throws IOException {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            if (this.hasClosed) {
                                return -1;
                            }
                            int _result = super.read(bytes, off, leng);
                            this.checkShouldClose_(_result);
                            return _result;
                        }

                        @Override
                        public void close() throws IOException {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            if (!this.hasClosed) {
                                super.close();
                                tmpFile.delete();
                                this.hasClosed = true;
                            }
                        }

                        protected void finalize() throws IOException {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            this.close();
                            super.finalize();
                        }
                    };
                    break block8;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                this.rawdataT = rawdata;
                this.streamT = null;
                this._offset = 0;
                this.lengthT = rawdata.length;
            }
            catch (IOException e) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw new KSQLException(GT.tr("An I/O error occurred while sending to the backend.", new Object[0]), KSQLState.IO_ERROR, (Throwable)e);
            }
        }
    }

    public InputStream getStream() {
        if (this.streamT != null) {
            return this.streamT;
        }
        return new ByteArrayInputStream(this.rawdataT, this._offset, this.lengthT);
    }

    public int getLength() {
        return this.lengthT;
    }

    public int getOffset() {
        return this._offset;
    }

    public byte[] getBytes() {
        return this.rawdataT;
    }

    public String toString() {
        return "<stream of " + this.lengthT + " _bytes>";
    }

    private static int copyStream(InputStream inputStream, OutputStream outputStream, int limit) throws IOException {
        int totalLengthT = 0;
        byte[] _buffer = new byte[2048];
        int readLengthT = inputStream.read(_buffer);
        while (readLengthT > 0) {
            outputStream.write(_buffer, 0, readLengthT);
            if ((totalLengthT += readLengthT) >= limit) {
                return -1;
            }
            readLengthT = inputStream.read(_buffer);
        }
        return totalLengthT;
    }
}

