/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.jdbc;

import com.kingbase8.Driver;
import com.kingbase8.core.BaseConnection;
import com.kingbase8.core.CachedQuery;
import com.kingbase8.core.ParameterList;
import com.kingbase8.core.Query;
import com.kingbase8.core.ServerVersion;
import com.kingbase8.core.TypeInfo;
import com.kingbase8.core.v3.BatchedQuery;
import com.kingbase8.core.v3.SimpleQuery;
import com.kingbase8.jdbc.BooleanTypeUtil;
import com.kingbase8.jdbc.KbArray;
import com.kingbase8.jdbc.KbConnection;
import com.kingbase8.jdbc.KbParameterMetaData;
import com.kingbase8.jdbc.KbResultSet;
import com.kingbase8.jdbc.KbSQLXML;
import com.kingbase8.jdbc.KbStatement;
import com.kingbase8.jdbc.PreferQueryMode;
import com.kingbase8.jdbc.PrimitiveArraySupport;
import com.kingbase8.jdbc.ResultWrapper;
import com.kingbase8.jdbc.TimestampUtils;
import com.kingbase8.largeobject.LargeObject;
import com.kingbase8.largeobject.LargeObjectManager;
import com.kingbase8.util.ByteConverter;
import com.kingbase8.util.GT;
import com.kingbase8.util.HStoreConverter;
import com.kingbase8.util.KBBinaryObject;
import com.kingbase8.util.KBTime;
import com.kingbase8.util.KBTimestamp;
import com.kingbase8.util.KBobject;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.LOGGER;
import com.kingbase8.util.ReaderInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.logging.Level;

public class KbPreparedStatement
extends KbStatement
implements PreparedStatement {
    protected final CachedQuery preparedQuery;
    protected ParameterList preparedParameters;
    protected List<String> preparedParameterNames = new ArrayList<String>();
    private TimeZone defaultTimeZone;

    KbPreparedStatement(KbConnection connection, String sql, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        this(connection, connection.borrowQuery(sql), rsType, rsConcurrency, rsHoldability);
    }

    KbPreparedStatement(KbConnection connection, CachedQuery query, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(connection, rsType, rsConcurrency, rsHoldability);
        this.preparedQuery = query;
        this.preparedParameters = this.preparedQuery.query.createParameterList();
        Query[] queries = this.preparedQuery.query.getSubqueries();
        if (queries == null) {
            this.preparedParameterNames.addAll(((SimpleQuery)this.preparedQuery.query).getNativeQuery().bindParamNames);
        } else {
            for (int i = 0; i < queries.length; ++i) {
                this.preparedParameterNames.addAll(((SimpleQuery)queries[i]).getNativeQuery().bindParamNames);
            }
        }
        if (connection.isOptimizeBatchedDML() && connection.getPreferQueryMode().compareTo(PreferQueryMode.SIMPLE) > 0 && this.preparedQuery.query.getSqlCommand() != null && this.preparedQuery.query.getSqlCommand().isDML() && this.preparedParameters.getParameterCount() > 0) {
            this.reWriteBind = true;
        }
        this.setPoolable(true);
    }

    public void copyPreparedStatementInfo(KbPreparedStatement stnew) {
        this.preparedParameters = stnew.preparedParameters;
        this.defaultTimeZone = stnew.defaultTimeZone;
    }

    public ParameterList getPreParmlist() {
        return this.preparedParameters;
    }

    public void setPreParmlist(ParameterList preParm) {
        this.preparedParameters = preParm;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new KSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), KSQLState.WRONG_OBJECT_TYPE);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (!this.executeWithFlags(0)) {
            throw new KSQLException(GT.tr("No results were returned by the query.", new Object[0]), KSQLState.NO_DATA);
        }
        return this.getSingleResultSet();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new KSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), KSQLState.WRONG_OBJECT_TYPE);
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.executeWithFlags(4);
        this.checkNoResultUpdate();
        return this.getUpdateCount();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.executeWithFlags(4);
        this.checkNoResultUpdate();
        return this.getLargeUpdateCount();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new KSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), KSQLState.WRONG_OBJECT_TYPE);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeWithFlags(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeWithFlags(int flags) throws SQLException {
        try {
            this.checkClosed();
            if (this.connection.getPreferQueryMode() == PreferQueryMode.SIMPLE) {
                flags |= 0x400;
            }
            this.execute(this.preparedQuery, this.preparedParameters, flags);
            KbPreparedStatement kbPreparedStatement = this;
            synchronized (kbPreparedStatement) {
                this.checkClosed();
                boolean bl = this.result != null && this.result.getResultSet() != null;
                return bl;
            }
        }
        finally {
            this.defaultTimeZone = null;
        }
    }

    @Override
    protected boolean isOneShotQuery(CachedQuery cachedQuery) {
        if (cachedQuery == null) {
            cachedQuery = this.preparedQuery;
        }
        return super.isOneShotQuery(cachedQuery);
    }

    @Override
    public void closeImpl() throws SQLException {
        if (this.preparedQuery != null) {
            ((KbConnection)this.connection).releaseQuery(this.preparedQuery);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        int oid;
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, sqlType: {1}", parameterIndex, sqlType);
        }
        if (parameterIndex < 1 || parameterIndex > this.preparedParameters.getParameterCount()) {
            throw new KSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", parameterIndex, this.preparedParameters.getInParameterCount()), KSQLState.INVALID_PARAMETER_VALUE);
        }
        switch (sqlType) {
            case 2009: {
                oid = 142;
                break;
            }
            case 4: {
                oid = 23;
                break;
            }
            case -6: 
            case 5: {
                oid = 21;
                break;
            }
            case -5: {
                oid = 20;
                break;
            }
            case 7: {
                oid = 700;
                break;
            }
            case 6: 
            case 8: {
                oid = 701;
                break;
            }
            case 2: 
            case 3: {
                oid = 1700;
                break;
            }
            case 1: {
                oid = 1042;
                break;
            }
            case -9: 
            case -1: 
            case 12: {
                oid = this.connection.getStringVarcharFlag() ? 1043 : 0;
                break;
            }
            case 91: {
                oid = 1082;
                break;
            }
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                oid = 0;
                break;
            }
            case -7: 
            case 16: {
                oid = 16;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                oid = 0;
                break;
            }
            case 2004: {
                if ("oracle".equals(this.connection.getCompatibleLevel())) {
                    oid = 8013;
                    break;
                }
                oid = 26;
                break;
            }
            case 2005: {
                if ("oracle".equals(this.connection.getCompatibleLevel())) {
                    oid = 8014;
                    break;
                }
                oid = 26;
                break;
            }
            case 2011: {
                if ("oracle".equals(this.connection.getCompatibleLevel())) {
                    oid = 8015;
                    break;
                }
                throw new KSQLException(GT.tr("Unknown Types value.", new Object[0]), KSQLState.INVALID_PARAMETER_TYPE);
            }
            case 0: 
            case 1111: 
            case 2001: 
            case 2002: 
            case 2003: {
                oid = 0;
                break;
            }
            default: {
                throw new KSQLException(GT.tr("Unknown Types value.", new Object[0]), KSQLState.INVALID_PARAMETER_TYPE);
            }
        }
        this.preparedParameters.setNull(parameterIndex, oid);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}", parameterIndex, x);
        }
        if ("oracle".equals(this.connection.getCompatibleLevel())) {
            this.bindLiteral(parameterIndex, x ? "1" : "0", 0);
        } else {
            this.bindLiteral(parameterIndex, x ? "TRUE" : "FALSE", 16);
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}", parameterIndex, x);
        }
        this.setShort(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}", parameterIndex, x);
        }
        if (this.connection.binaryTransferSend(21)) {
            byte[] val = new byte[2];
            ByteConverter.int2(val, 0, x);
            this.bindBytes(parameterIndex, val, 21);
            return;
        }
        this.bindLiteral(parameterIndex, Integer.toString(x), 21);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}", parameterIndex, x);
        }
        if (this.connection.binaryTransferSend(23)) {
            byte[] val = new byte[4];
            ByteConverter.int4(val, 0, x);
            this.bindBytes(parameterIndex, val, 23);
            return;
        }
        this.bindLiteral(parameterIndex, Integer.toString(x), 23);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}", parameterIndex, x);
        }
        if (this.connection.binaryTransferSend(20)) {
            byte[] val = new byte[8];
            ByteConverter.int8(val, 0, x);
            this.bindBytes(parameterIndex, val, 20);
            return;
        }
        this.bindLiteral(parameterIndex, Long.toString(x), 20);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}", parameterIndex, Float.valueOf(x));
        }
        if (this.connection.binaryTransferSend(700)) {
            byte[] val = new byte[4];
            ByteConverter.float4(val, 0, x);
            this.bindBytes(parameterIndex, val, 700);
            return;
        }
        this.bindLiteral(parameterIndex, Float.toString(x), 701);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}", parameterIndex, x);
        }
        if (this.connection.binaryTransferSend(701)) {
            byte[] val = new byte[8];
            ByteConverter.float8(val, 0, x);
            this.bindBytes(parameterIndex, val, 701);
            return;
        }
        this.bindLiteral(parameterIndex, Double.toString(x), 701);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}", parameterIndex, x);
        }
        this.setNumber(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}", parameterIndex, x);
        }
        this.setString(parameterIndex, x, this.getStringType());
    }

    private int getStringType() {
        return this.connection.getStringVarcharFlag() ? 1043 : 0;
    }

    protected void setString(int parameterIndex, String x, int oid) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.preparedParameters.setNull(parameterIndex, oid);
        } else {
            this.bindString(parameterIndex, x, oid);
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}", parameterIndex, x);
        }
        if (null == x) {
            this.setNull(parameterIndex, -3);
            return;
        }
        byte[] copy = new byte[x.length];
        System.arraycopy(x, 0, copy, 0, x.length);
        this.preparedParameters.setBytea(parameterIndex, copy, 0, x.length);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}", parameterIndex, x);
        }
        this.setDate(parameterIndex, x, null);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}", parameterIndex, x);
        }
        this.setTime(parameterIndex, x, null);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}", parameterIndex, x);
        }
        this.setTimestamp(parameterIndex, x, null);
    }

    private void setCharacterStreamPost71(int parameterIndex, InputStream x, int length, String encoding) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 12);
            return;
        }
        if (length < 0) {
            throw new KSQLException(GT.tr("Invalid stream length {0}.", length), KSQLState.INVALID_PARAMETER_VALUE);
        }
        try {
            int n;
            InputStreamReader inStream = new InputStreamReader(x, encoding);
            char[] chars = new char[length];
            int charsRead = 0;
            while ((n = inStream.read(chars, charsRead, length - charsRead)) != -1 && (charsRead += n) != length) {
            }
            this.setString(parameterIndex, new String(chars, 0, charsRead), 1043);
        }
        catch (UnsupportedEncodingException uee) {
            throw new KSQLException(GT.tr("The JVM claims not to support the {0} encoding.", encoding), KSQLState.UNEXPECTED_ERROR, (Throwable)uee);
        }
        catch (IOException ioe) {
            throw new KSQLException(GT.tr("Provided InputStream failed.", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}, length: {2}", parameterIndex, x, length);
        }
        this.setCharacterStreamPost71(parameterIndex, x, length, "ASCII");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}, length: {2}", parameterIndex, x, length);
        }
        this.setCharacterStreamPost71(parameterIndex, x, length, "UTF-8");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}, length: {2}", parameterIndex, x, length);
        }
        if (x == null) {
            this.setNull(parameterIndex, -3);
            return;
        }
        if (length < 0) {
            throw new KSQLException(GT.tr("Invalid stream length {0}.", length), KSQLState.INVALID_PARAMETER_VALUE);
        }
        this.preparedParameters.setBytea(parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.preparedParameters.clear();
    }

    private void setKBobject(int parameterIndex, KBobject x) throws SQLException {
        String typename = x.getType();
        int oid = this.connection.getTypeInfo().getKBType(typename);
        if (oid == 0) {
            throw new KSQLException(GT.tr("Unknown type {0}.", typename), KSQLState.INVALID_PARAMETER_TYPE);
        }
        if (x instanceof KBBinaryObject && this.connection.binaryTransferSend(oid)) {
            KBBinaryObject binObj = (KBBinaryObject)((Object)x);
            byte[] data = new byte[binObj.lengthInBytes()];
            binObj.toBytes(data, 0);
            this.bindBytes(parameterIndex, data, oid);
        } else {
            this.setString(parameterIndex, x.getValue(), oid);
        }
    }

    private void setMap(int parameterIndex, Map<?, ?> x) throws SQLException {
        int oid = this.connection.getTypeInfo().getKBType("hstore");
        if (oid == 0) {
            throw new KSQLException(GT.tr("No hstore extension installed.", new Object[0]), KSQLState.INVALID_PARAMETER_TYPE);
        }
        if (this.connection.binaryTransferSend(oid)) {
            byte[] data = HStoreConverter.toBytes(x, this.connection.getEncoding());
            this.bindBytes(parameterIndex, data, oid);
        } else {
            this.setString(parameterIndex, HStoreConverter.toString(x), oid);
        }
    }

    private void setNumber(int parameterIndex, Number x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, 3);
        } else {
            this.bindLiteral(parameterIndex, x.toString(), 1700);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object in, int targetSqlType, int scale) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}, targetSqlType: {2}, scale: {3}", parameterIndex, in, targetSqlType, scale);
        }
        if (in == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        if (targetSqlType == 1111 && in instanceof UUID && this.connection.haveMinimumServerVersion(ServerVersion.v8_3)) {
            this.setUuid(parameterIndex, (UUID)in);
            return;
        }
        switch (targetSqlType) {
            case 2009: {
                if (in instanceof SQLXML) {
                    this.setSQLXML(parameterIndex, (SQLXML)in);
                    break;
                }
                this.setSQLXML(parameterIndex, new KbSQLXML(this.connection, in.toString()));
                break;
            }
            case 4: {
                this.setInt(parameterIndex, KbPreparedStatement.castToInt(in));
                break;
            }
            case -6: 
            case 5: {
                this.setShort(parameterIndex, KbPreparedStatement.castToShort(in));
                break;
            }
            case -5: {
                this.setLong(parameterIndex, KbPreparedStatement.castToLong(in));
                break;
            }
            case 7: {
                this.setFloat(parameterIndex, KbPreparedStatement.castToFloat(in));
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(parameterIndex, KbPreparedStatement.castToDouble(in));
                break;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(parameterIndex, KbPreparedStatement.castToBigDecimal(in, scale));
                break;
            }
            case 1: {
                this.setString(parameterIndex, KbPreparedStatement.castToString(in), 1042);
                break;
            }
            case -9: 
            case 12: {
                this.setString(parameterIndex, KbPreparedStatement.castToString(in), this.getStringType());
                break;
            }
            case -1: {
                if (in instanceof InputStream) {
                    this.preparedParameters.setText(parameterIndex, (InputStream)in);
                    break;
                }
                this.setString(parameterIndex, KbPreparedStatement.castToString(in), this.getStringType());
                break;
            }
            case 91: {
                Date tmpd;
                if (in instanceof Date) {
                    this.setDate(parameterIndex, (Date)in);
                    break;
                }
                if (in instanceof java.util.Date) {
                    tmpd = new Date(((java.util.Date)in).getTime());
                } else {
                    if (in instanceof LocalDate) {
                        this.setDate(parameterIndex, (LocalDate)in);
                        break;
                    }
                    tmpd = this.connection.getTimestampUtils().toDate(this.getDefaultCalendar(), in.toString());
                }
                this.setDate(parameterIndex, tmpd);
                break;
            }
            case 92: {
                Time tmpt;
                if (in instanceof Time) {
                    this.setTime(parameterIndex, (Time)in);
                    break;
                }
                if (in instanceof java.util.Date) {
                    tmpt = new Time(((java.util.Date)in).getTime());
                } else {
                    if (in instanceof LocalTime) {
                        this.setTime(parameterIndex, (LocalTime)in);
                        break;
                    }
                    tmpt = this.connection.getTimestampUtils().toTime(this.getDefaultCalendar(), in.toString());
                }
                this.setTime(parameterIndex, tmpt);
                break;
            }
            case 93: {
                Timestamp tmpts;
                if (in instanceof KBTimestamp) {
                    this.setObject(parameterIndex, in);
                    break;
                }
                if (in instanceof Timestamp) {
                    this.setTimestamp(parameterIndex, (Timestamp)in);
                    break;
                }
                if (in instanceof java.util.Date) {
                    tmpts = new Timestamp(((java.util.Date)in).getTime());
                } else {
                    if (in instanceof LocalDateTime) {
                        this.setTimestamp(parameterIndex, (LocalDateTime)in);
                        break;
                    }
                    tmpts = this.connection.getTimestampUtils().toTimestamp(this.getDefaultCalendar(), in.toString());
                }
                this.setTimestamp(parameterIndex, tmpts);
                break;
            }
            case 2014: {
                if (in instanceof OffsetDateTime) {
                    this.setTimestamp(parameterIndex, (OffsetDateTime)in);
                    break;
                }
                if (in instanceof KBTimestamp) {
                    this.setObject(parameterIndex, in);
                    break;
                }
                throw new KSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", in.getClass().getName(), "Types.TIMESTAMP_WITH_TIMEZONE"), KSQLState.INVALID_PARAMETER_TYPE);
            }
            case -7: {
                if ("oracle".equals(this.connection.getCompatibleLevel())) {
                    if (in instanceof Boolean) {
                        this.setBoolean(parameterIndex, BooleanTypeUtil.castToBoolean(in, this.connection.getCompatibleLevel()));
                        break;
                    }
                    this.setString(parameterIndex, in.toString(), 0);
                    break;
                }
            }
            case 16: {
                this.setBoolean(parameterIndex, BooleanTypeUtil.castToBoolean(in, this.connection.getCompatibleLevel()));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setObject(parameterIndex, in);
                break;
            }
            case 2004: {
                if (in instanceof Blob) {
                    this.setBlob(parameterIndex, (Blob)in);
                    break;
                }
                if (in instanceof InputStream) {
                    if ("oracle".equals(this.connection.getCompatibleLevel())) {
                        this.setBinaryStream(parameterIndex, (InputStream)in);
                        break;
                    }
                    long oid = this.createBlob(parameterIndex, (InputStream)in, -1L);
                    this.setLong(parameterIndex, oid);
                    break;
                }
                if (in instanceof byte[] && "oracle".equals(this.connection.getCompatibleLevel())) {
                    this.setBytes(parameterIndex, (byte[])in);
                    break;
                }
                throw new KSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", in.getClass().getName(), "Types.BLOB"), KSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2005: 
            case 2011: {
                if (in instanceof Clob) {
                    this.setClob(parameterIndex, (Clob)in);
                    break;
                }
                if (in instanceof String && "oracle".equals(this.connection.getCompatibleLevel())) {
                    this.setString(parameterIndex, (String)in);
                    break;
                }
                throw new KSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", in.getClass().getName(), "Types.CLOB"), KSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2003: {
                if (in instanceof Array) {
                    this.setArray(parameterIndex, (Array)in);
                    break;
                }
                if (PrimitiveArraySupport.isSupportedPrimitiveArray(in)) {
                    this.setPrimitiveArray(parameterIndex, in);
                    break;
                }
                throw new KSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", in.getClass().getName(), "Types.ARRAY"), KSQLState.INVALID_PARAMETER_TYPE);
            }
            case 2001: {
                this.bindString(parameterIndex, in.toString(), 0);
                break;
            }
            case 1111: {
                if (in instanceof KBobject) {
                    this.setKBobject(parameterIndex, (KBobject)in);
                    break;
                }
                if (in instanceof Map) {
                    this.setMap(parameterIndex, (Map)in);
                    break;
                }
                this.bindString(parameterIndex, in.toString(), 0);
                break;
            }
            case 2002: {
                if (in instanceof KBobject) {
                    this.setKBobject(parameterIndex, (KBobject)in);
                    break;
                }
                if (!(in instanceof Struct)) break;
                this.setStruct(parameterIndex, (Struct)in);
                break;
            }
            case -8: {
                if (in instanceof RowId) {
                    this.setRowId(parameterIndex, (RowId)in);
                    break;
                }
                if (in instanceof KBobject) {
                    this.setKBobject(parameterIndex, (KBobject)in);
                    break;
                }
                this.bindString(parameterIndex, in.toString(), 0);
                break;
            }
            default: {
                throw new KSQLException(GT.tr("Unsupported Types value: {0}", targetSqlType), KSQLState.INVALID_PARAMETER_TYPE);
            }
        }
    }

    private <A> void setPrimitiveArray(int parameterIndex, A in) throws SQLException {
        PrimitiveArraySupport<A> arrayToString = PrimitiveArraySupport.getArraySupport(in);
        TypeInfo typeInfo = this.connection.getTypeInfo();
        int oid = arrayToString.getDefaultArrayTypeOid(typeInfo);
        if (arrayToString.supportBinaryRepresentation() && this.connection.getPreferQueryMode() != PreferQueryMode.SIMPLE) {
            this.bindBytes(parameterIndex, arrayToString.toBinaryRepresentation(this.connection, in), oid);
        } else {
            char delim = typeInfo.getArrayDelimiter(oid);
            this.setString(parameterIndex, arrayToString.toArrayString(delim, in), oid);
        }
    }

    private static String asString(Clob in) throws SQLException {
        return in.getSubString(1L, (int)in.length());
    }

    private static int castToInt(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Integer.parseInt((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).intValue();
            }
            if (in instanceof java.util.Date) {
                return (int)((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1 : 0;
            }
            if (in instanceof Clob) {
                return Integer.parseInt(KbPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Integer.parseInt(in.toString());
            }
        }
        catch (Exception e) {
            throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "int", e);
        }
        throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "int");
    }

    private static short castToShort(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Short.parseShort((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).shortValue();
            }
            if (in instanceof java.util.Date) {
                return (short)((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? (short)1 : 0;
            }
            if (in instanceof Clob) {
                return Short.parseShort(KbPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Short.parseShort(in.toString());
            }
        }
        catch (Exception e) {
            throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "short", e);
        }
        throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "short");
    }

    private static long castToLong(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Long.parseLong((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).longValue();
            }
            if (in instanceof java.util.Date) {
                return ((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1L : 0L;
            }
            if (in instanceof Clob) {
                return Long.parseLong(KbPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Long.parseLong(in.toString());
            }
        }
        catch (Exception e) {
            throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "long", e);
        }
        throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "long");
    }

    private static float castToFloat(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Float.parseFloat((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).floatValue();
            }
            if (in instanceof java.util.Date) {
                return ((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1.0f : 0.0f;
            }
            if (in instanceof Clob) {
                return Float.parseFloat(KbPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Float.parseFloat(in.toString());
            }
        }
        catch (Exception e) {
            throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "float", e);
        }
        throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "float");
    }

    private static double castToDouble(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Double.parseDouble((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).doubleValue();
            }
            if (in instanceof java.util.Date) {
                return ((java.util.Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1.0 : 0.0;
            }
            if (in instanceof Clob) {
                return Double.parseDouble(KbPreparedStatement.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Double.parseDouble(in.toString());
            }
        }
        catch (Exception e) {
            throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "double", e);
        }
        throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "double");
    }

    private static BigDecimal castToBigDecimal(Object in, int scale) throws SQLException {
        try {
            BigDecimal rc = null;
            if (in instanceof String) {
                rc = new BigDecimal((String)in);
            } else if (in instanceof BigDecimal) {
                rc = (BigDecimal)in;
            } else if (in instanceof BigInteger) {
                rc = new BigDecimal((BigInteger)in);
            } else if (in instanceof Long || in instanceof Integer || in instanceof Short || in instanceof Byte) {
                rc = BigDecimal.valueOf(((Number)in).longValue());
            } else if (in instanceof Double || in instanceof Float) {
                rc = BigDecimal.valueOf(((Number)in).doubleValue());
            } else if (in instanceof java.util.Date) {
                rc = BigDecimal.valueOf(((java.util.Date)in).getTime());
            } else if (in instanceof Boolean) {
                rc = (Boolean)in != false ? BigDecimal.ONE : BigDecimal.ZERO;
            } else if (in instanceof Clob) {
                rc = new BigDecimal(KbPreparedStatement.asString((Clob)in));
            } else if (in instanceof Character) {
                rc = new BigDecimal(new char[]{((Character)in).charValue()});
            }
            if (rc != null) {
                if (scale >= 0) {
                    rc = rc.setScale(scale, RoundingMode.HALF_UP);
                }
                return rc;
            }
        }
        catch (Exception e) {
            throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "BigDecimal", e);
        }
        throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "BigDecimal");
    }

    private static String castToString(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return (String)in;
            }
            if (in instanceof Clob) {
                return KbPreparedStatement.asString((Clob)in);
            }
            return in.toString();
        }
        catch (Exception e) {
            throw KbPreparedStatement.cannotCastException(in.getClass().getName(), "String", e);
        }
    }

    private static KSQLException cannotCastException(String fromType, String toType) {
        return KbPreparedStatement.cannotCastException(fromType, toType, null);
    }

    private static KSQLException cannotCastException(String fromType, String toType, Exception cause) {
        return new KSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", fromType, toType), KSQLState.INVALID_PARAMETER_TYPE, (Throwable)cause);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}, targetSqlType: {2}", parameterIndex, x, targetSqlType);
        }
        this.setObject(parameterIndex, x, targetSqlType, -1);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}", parameterIndex, x);
        }
        if (x == null) {
            this.setNull(parameterIndex, 1111);
        } else if (x instanceof UUID && this.connection.haveMinimumServerVersion(ServerVersion.v8_3)) {
            this.setUuid(parameterIndex, (UUID)x);
        } else if (x instanceof SQLXML) {
            this.setSQLXML(parameterIndex, (SQLXML)x);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x, 0);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
        } else if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
        } else if (x instanceof Array) {
            this.setArray(parameterIndex, (Array)x);
        } else if (x instanceof KBobject) {
            this.setKBobject(parameterIndex, (KBobject)x);
        } else if (x instanceof Character) {
            this.setString(parameterIndex, ((Character)x).toString());
        } else if (x instanceof LocalDate) {
            this.setDate(parameterIndex, (LocalDate)x);
        } else if (x instanceof LocalTime) {
            this.setTime(parameterIndex, (LocalTime)x);
        } else if (x instanceof LocalDateTime) {
            this.setTimestamp(parameterIndex, (LocalDateTime)x);
        } else if (x instanceof OffsetDateTime) {
            this.setTimestamp(parameterIndex, (OffsetDateTime)x);
        } else if (x instanceof Map) {
            this.setMap(parameterIndex, (Map)x);
        } else if (x instanceof Number) {
            this.setNumber(parameterIndex, (Number)x);
        } else if (PrimitiveArraySupport.isSupportedPrimitiveArray(x)) {
            this.setPrimitiveArray(parameterIndex, x);
        } else if (x instanceof Struct) {
            this.setStruct(parameterIndex, (Struct)x);
        } else {
            if ("oracle".equals(this.connection.getCompatibleLevel())) {
                this.setString(parameterIndex, x.toString(), 0);
                return;
            }
            throw new KSQLException(GT.tr("Can''t infer the SQL type to use for an instance of {0}. Use setObject() with an explicit Types value to specify the type to use.", x.getClass().getName()), KSQLState.INVALID_PARAMETER_TYPE);
        }
    }

    public String toString() {
        if (this.preparedQuery == null) {
            return super.toString();
        }
        return this.preparedQuery.query.toString(this.preparedParameters);
    }

    protected void bindLiteral(int paramIndex, String s, int oid) throws SQLException {
        this.preparedParameters.setLiteralParameter(paramIndex, s, oid);
    }

    protected void bindBytes(int paramIndex, byte[] b, int oid) throws SQLException {
        this.preparedParameters.setBinaryParameter(paramIndex, b, oid);
    }

    private void bindString(int paramIndex, String s, int oid) throws SQLException {
        this.preparedParameters.setStringParameter(paramIndex, s, oid);
    }

    @Override
    public boolean isUseServerPrepare() {
        return this.preparedQuery != null && this.mPrepareThreshold != 0 && this.preparedQuery.getExecuteCount() + 1 >= this.mPrepareThreshold;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkClosed();
        throw new KSQLException(GT.tr("Can''t use query methods that take a query string on a PreparedStatement.", new Object[0]), KSQLState.WRONG_OBJECT_TYPE);
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkClosed();
        if (this.batchStatements == null) {
            this.batchStatements = new ArrayList();
            this.batchParameters = new ArrayList();
        }
        this.batchParameters.add(this.preparedParameters.copy());
        Query query = this.preparedQuery.query;
        if (!(query instanceof BatchedQuery) || this.batchStatements.isEmpty()) {
            this.batchStatements.add(query);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        ResultSet rs = this.getResultSet();
        if (rs == null || ((KbResultSet)rs).isResultSetClosed()) {
            int flags = 49;
            KbStatement.StatementResultHandler handler = new KbStatement.StatementResultHandler(this);
            this.connection.getQueryExecutor().execute(this.preparedQuery.query, this.preparedParameters, handler, 0, 0, flags);
            ResultWrapper wrapper = handler.getResults();
            if (wrapper != null) {
                rs = wrapper.getResultSet();
            }
        }
        if (rs != null) {
            return rs.getMetaData();
        }
        return null;
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        KbArray arr;
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}", i, x);
        }
        if (null == x) {
            this.setNull(i, 2003);
            return;
        }
        String typename = x.getBaseTypeName();
        int oid = this.connection.getTypeInfo().getPGArrayType(typename);
        if (oid == 0) {
            throw new KSQLException(GT.tr("Unknown type {0}.", typename), KSQLState.INVALID_PARAMETER_TYPE);
        }
        if (x instanceof KbArray && (arr = (KbArray)x).isBinary()) {
            this.bindBytes(i, arr.toBytes(), oid);
            return;
        }
        this.setString(i, x.toString(), oid);
    }

    protected long createBlob(int i, InputStream inputStream, long length) throws SQLException {
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        long oid = lom.createLO();
        LargeObject lob = lom.open(oid);
        OutputStream outputStream = lob.getOutputStream();
        byte[] buf = new byte[4096];
        try {
            long remaining = length > 0L ? length : Long.MAX_VALUE;
            int numRead = inputStream.read(buf, 0, length > 0L && remaining < (long)buf.length ? (int)remaining : buf.length);
            while (numRead != -1 && remaining > 0L) {
                outputStream.write(buf, 0, numRead);
                numRead = inputStream.read(buf, 0, length > 0L && remaining < (long)buf.length ? (int)(remaining -= (long)numRead) : buf.length);
            }
        }
        catch (IOException se) {
            throw new KSQLException(GT.tr("Unexpected error writing large object to database.", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)se);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
        return oid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}", i, x);
        }
        if (x == null) {
            this.setNull(i, 2004);
            return;
        }
        if ("oracle".equals(this.connection.getCompatibleLevel())) {
            this.setBinaryStream(i, x.getBinaryStream());
            return;
        }
        InputStream inStream = x.getBinaryStream();
        try {
            long oid = this.createBlob(i, inStream, x.length());
            this.setLong(i, oid);
        }
        finally {
            try {
                inStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private String readerToString(Reader value, int maxLength) throws SQLException {
        try {
            int bufferSize = Math.min(maxLength, 1024);
            StringBuilder v = new StringBuilder(bufferSize);
            char[] buf = new char[bufferSize];
            int nRead = 0;
            while (nRead > -1 && v.length() < maxLength) {
                nRead = value.read(buf, 0, Math.min(bufferSize, maxLength - v.length()));
                if (nRead <= 0) continue;
                v.append(buf, 0, nRead);
            }
            return v.toString();
        }
        catch (IOException ioe) {
            throw new KSQLException(GT.tr("Provided Reader failed.", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
    }

    @Override
    public void setCharacterStream(int i, Reader x, int length) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}, length: {2}", i, x, length);
        }
        if (x == null) {
            this.setNull(i, 12);
            return;
        }
        if (length < 0) {
            throw new KSQLException(GT.tr("Invalid stream length {0}.", length), KSQLState.INVALID_PARAMETER_VALUE);
        }
        this.setString(i, this.readerToString(x, length));
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}", i, x);
        }
        if (x == null) {
            this.setNull(i, 2005);
            return;
        }
        if ("oracle".equals(this.connection.getCompatibleLevel())) {
            this.setCharacterStream(i, x.getCharacterStream());
            return;
        }
        Reader inStream = x.getCharacterStream();
        int length = (int)x.length();
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        long oid = lom.createLO();
        LargeObject lob = lom.open(oid);
        Charset connectionCharset = Charset.forName(this.connection.getEncoding().name());
        OutputStream los = lob.getOutputStream();
        OutputStreamWriter lw = new OutputStreamWriter(los, connectionCharset);
        try {
            int c = inStream.read();
            for (int p = 0; c > -1 && p < length; ++p) {
                ((Writer)lw).write(c);
                c = inStream.read();
            }
            ((Writer)lw).close();
        }
        catch (IOException se) {
            throw new KSQLException(GT.tr("Unexpected error writing large object to database.", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)se);
        }
        this.setLong(i, oid);
    }

    @Override
    public void setNull(int parameterIndex, int t, String typeName) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, sqlType: {1}, typeName: {2}", parameterIndex, t, typeName);
        }
        if (typeName == null) {
            this.setNull(parameterIndex, t);
            return;
        }
        this.checkClosed();
        TypeInfo typeInfo = this.connection.getTypeInfo();
        int oid = typeInfo.getKBType(typeName);
        this.preparedParameters.setNull(parameterIndex, oid);
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setRef(int,Ref)");
    }

    @Override
    public void setDate(int i, Date d, Calendar cal) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, d: {1}, cal: {2}", i, d, cal);
        }
        if (d == null) {
            this.setNull(i, 91);
            return;
        }
        if (this.connection.binaryTransferSend(1082)) {
            byte[] val = new byte[4];
            TimeZone tz = cal != null ? cal.getTimeZone() : null;
            this.connection.getTimestampUtils().toBinDate(tz, val, d);
            this.preparedParameters.setBinaryParameter(i, val, 1082);
            return;
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        if ("oracle".equals(this.connection.getCompatibleLevel())) {
            Timestamp ts = new Timestamp(d.getTime());
            this.bindString(i, this.connection.getTimestampUtils().toString(cal, ts), 0);
            return;
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, d), 0);
    }

    @Override
    public void setTime(int i, Time t, Calendar cal) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, t: {1}, cal: {2}", i, t, cal);
        }
        if (t == null) {
            this.setNull(i, 92);
            return;
        }
        int oid = 0;
        if (t instanceof KBTime) {
            KBTime pgTime = (KBTime)t;
            if (pgTime.getCalendar() == null) {
                oid = 1083;
            } else {
                oid = 1266;
                cal = pgTime.getCalendar();
            }
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, t), oid);
    }

    @Override
    public void setTimestamp(int i, Timestamp t, Calendar cal) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, t: {1}, cal: {2}", i, t, cal);
        }
        if (t == null) {
            this.setNull(i, 93);
            return;
        }
        int oid = 0;
        if (t instanceof KBTimestamp) {
            KBTimestamp pgTimestamp = (KBTimestamp)t;
            if (pgTimestamp.getCalendar() == null) {
                oid = 1114;
            } else {
                oid = 1184;
                cal = pgTimestamp.getCalendar();
            }
        }
        if (cal == null) {
            cal = this.getDefaultCalendar();
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, t), oid);
    }

    private void setDate(int i, LocalDate localDate) throws SQLException {
        int oid = 1082;
        this.bindString(i, this.connection.getTimestampUtils().toString(localDate), oid);
    }

    private void setTime(int i, LocalTime localTime) throws SQLException {
        int oid = 1083;
        this.bindString(i, this.connection.getTimestampUtils().toString(localTime), oid);
    }

    private void setTimestamp(int i, LocalDateTime localDateTime) throws SQLException {
        int oid = 1114;
        this.bindString(i, this.connection.getTimestampUtils().toString(localDateTime), oid);
    }

    private void setTimestamp(int i, OffsetDateTime offsetDateTime) throws SQLException {
        int oid = 1184;
        this.bindString(i, this.connection.getTimestampUtils().toString(offsetDateTime), oid);
    }

    public ParameterMetaData createParameterMetaData(BaseConnection conn, int[] oids) throws SQLException {
        return new KbParameterMetaData(conn, oids);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setObject");
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setObject");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        if ("oracle".equals(this.connection.getCompatibleLevel())) {
            int oid = 27;
            this.bindString(parameterIndex, x.toString(), oid);
            return;
        }
        throw Driver.notImplemented(this.getClass(), "setRowId(int, RowId)");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        if ("oracle".equals(this.connection.getCompatibleLevel())) {
            this.setString(parameterIndex, value);
            return;
        }
        throw Driver.notImplemented(this.getClass(), "setNString(int, String)");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(int, Reader, long)");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setNCharacterStream(int, Reader)");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setCharacterStream(int, Reader, long)");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader value) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}", parameterIndex, value);
        }
        if (this.connection.getPreferQueryMode() == PreferQueryMode.SIMPLE) {
            String s = value != null ? this.readerToString(value, Integer.MAX_VALUE) : null;
            this.setString(parameterIndex, s);
            return;
        }
        ReaderInputStream is = value != null ? new ReaderInputStream(value, this.connection.getEncoding().name()) : null;
        this.setObject(parameterIndex, (Object)is, -1);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value, long length) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw new KSQLException(GT.tr("Object is too large to send over the protocol.", new Object[0]), KSQLState.NUMERIC_CONSTANT_OUT_OF_RANGE);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}, length: {2}", parameterIndex, value, length);
        }
        this.preparedParameters.setBytea(parameterIndex, value, (int)length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream value) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}", parameterIndex, value);
        }
        this.preparedParameters.setBytea(parameterIndex, value);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream value, long length) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(int, InputStream, long)");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream value) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(int, InputStream)");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        if ("oracle".equals(this.connection.getCompatibleLevel())) {
            this.setClob(parameterIndex, value);
            return;
        }
        throw Driver.notImplemented(this.getClass(), "setNClob(int, NClob)");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if ("oracle".equals(this.connection.getCompatibleLevel())) {
            this.setCharacterStream(parameterIndex, reader, (int)length);
            return;
        }
        throw Driver.notImplemented(this.getClass(), "setClob(int, Reader, long)");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        if ("oracle".equals(this.connection.getCompatibleLevel())) {
            this.setCharacterStream(parameterIndex, reader);
            return;
        }
        throw Driver.notImplemented(this.getClass(), "setClob(int, Reader)");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}, length: {2}", parameterIndex, inputStream, length);
        }
        if (inputStream == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        if (length < 0L) {
            throw new KSQLException(GT.tr("Invalid stream length {0}.", length), KSQLState.INVALID_PARAMETER_VALUE);
        }
        if ("oracle".equals(this.connection.getCompatibleLevel())) {
            this.setBinaryStream(parameterIndex, inputStream, length);
            return;
        }
        long oid = this.createBlob(parameterIndex, inputStream, length);
        this.setLong(parameterIndex, oid);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}", parameterIndex, inputStream);
        }
        if (inputStream == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        if ("oracle".equals(this.connection.getCompatibleLevel())) {
            this.setBinaryStream(parameterIndex, inputStream);
            return;
        }
        long oid = this.createBlob(parameterIndex, inputStream, -1L);
        this.setLong(parameterIndex, oid);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if ("oracle".equals(this.connection.getCompatibleLevel())) {
            this.setClob(parameterIndex, reader, length);
            return;
        }
        throw Driver.notImplemented(this.getClass(), "setNClob(int, Reader, long)");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        if ("oracle".equals(this.connection.getCompatibleLevel())) {
            this.setClob(parameterIndex, reader);
            return;
        }
        throw Driver.notImplemented(this.getClass(), "setNClob(int, Reader)");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        String stringValue;
        this.checkClosed();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterIndex: {0}, parameter: {1}", parameterIndex, xmlObject);
        }
        String string = stringValue = xmlObject == null ? null : xmlObject.getString();
        if (stringValue == null) {
            this.setNull(parameterIndex, 2009);
        } else {
            this.setString(parameterIndex, stringValue, 142);
        }
    }

    private void setUuid(int parameterIndex, UUID uuid) throws SQLException {
        if (this.connection.binaryTransferSend(2950)) {
            byte[] val = new byte[16];
            ByteConverter.int8(val, 0, uuid.getMostSignificantBits());
            ByteConverter.int8(val, 8, uuid.getLeastSignificantBits());
            this.bindBytes(parameterIndex, val, 2950);
        } else {
            this.bindLiteral(parameterIndex, uuid.toString(), 2950);
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "setURL(int,URL)");
    }

    private void setStruct(int parameterIndex, Struct x) throws SQLException {
        String typename = x.getSQLTypeName();
        int oid = this.connection.getTypeInfo().getKBType(typename);
        if (oid == 0) {
            throw new KSQLException(GT.tr("Unknown type {0}.", typename), KSQLState.INVALID_PARAMETER_TYPE);
        }
        this.setString(parameterIndex, x.toString(), oid);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            if (this.batchParameters != null && this.batchParameters.size() > 1 && this.mPrepareThreshold > 0) {
                this.preparedQuery.increaseExecuteCount(this.mPrepareThreshold);
            }
            int[] nArray = super.executeBatch();
            return nArray;
        }
        finally {
            this.defaultTimeZone = null;
        }
    }

    private Calendar getDefaultCalendar() {
        TimestampUtils timestampUtils = this.connection.getTimestampUtils();
        if (timestampUtils.hasFastDefaultTimeZone()) {
            return timestampUtils.getSharedCalendar(null);
        }
        Calendar sharedCalendar = timestampUtils.getSharedCalendar(this.defaultTimeZone);
        if (this.defaultTimeZone == null) {
            this.defaultTimeZone = sharedCalendar.getTimeZone();
        }
        return sharedCalendar;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        int flags = 49;
        KbStatement.StatementResultHandler handler = new KbStatement.StatementResultHandler(this);
        this.connection.getQueryExecutor().execute(this.preparedQuery.query, this.preparedParameters, handler, 0, 0, flags);
        int[] oids = this.preparedParameters.getTypeOIDs();
        if (oids != null) {
            return this.createParameterMetaData(this.connection, oids);
        }
        return null;
    }

    @Override
    protected void transformQueriesAndParameters() throws SQLException {
        if (this.batchParameters.size() <= 1 || !(this.preparedQuery.query instanceof BatchedQuery)) {
            return;
        }
        BatchedQuery originalQuery = (BatchedQuery)this.preparedQuery.query;
        int bindCount = originalQuery.getBindCount();
        int highestBlockCount = 128;
        int maxValueBlocks = bindCount == 0 ? 1024 : Integer.highestOneBit(Math.min(Math.max(1, 32766 / bindCount), 128));
        int unprocessedBatchCount = this.batchParameters.size();
        int fullValueBlocksCount = unprocessedBatchCount / maxValueBlocks;
        int partialValueBlocksCount = Integer.bitCount(unprocessedBatchCount % maxValueBlocks);
        int count = fullValueBlocksCount + partialValueBlocksCount;
        ArrayList<BatchedQuery> newBatchStatements = new ArrayList<BatchedQuery>(count);
        ArrayList<ParameterList> newBatchParameters = new ArrayList<ParameterList>(count);
        int offset = 0;
        for (int i = 0; i < count; ++i) {
            int valueBlock = unprocessedBatchCount >= maxValueBlocks ? maxValueBlocks : Integer.highestOneBit(unprocessedBatchCount);
            BatchedQuery bq = originalQuery.deriveForMultiBatch(valueBlock);
            ParameterList newPl = bq.createParameterList();
            for (int j = 0; j < valueBlock; ++j) {
                ParameterList pl = (ParameterList)this.batchParameters.get(offset++);
                newPl.appendAll(pl);
            }
            newBatchStatements.add(bq);
            newBatchParameters.add(newPl);
            unprocessedBatchCount -= valueBlock;
        }
        this.batchStatements = newBatchStatements;
        this.batchParameters = newBatchParameters;
    }

    public List<Integer> findIndexByName(String name, List<String> parameterNames) throws SQLException {
        if (parameterNames == null || parameterNames.isEmpty()) {
            throw new KSQLException(GT.tr("Attempt to obtain a parameter name {0} that does not appear in SQL.", name), KSQLState.INVALID_NAME);
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < parameterNames.size(); ++i) {
            if (!name.equals(parameterNames.get(i))) continue;
            indexes.add(i + 1);
        }
        if (indexes.isEmpty()) {
            throw new KSQLException(GT.tr("Attempt to obtain a parameter name {0} that does not appear in SQL.", name), KSQLState.INVALID_NAME);
        }
        return indexes;
    }

    public void setIntAtName(String parameterName, int x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, x);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setInt(index, x);
        }
    }

    public void setArrayAtName(String parameterName, Array x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, x);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setArray(index, x);
        }
    }

    public void setAsciiStreamAtName(String parameterName, InputStream value) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, value);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setAsciiStream(index, value);
        }
    }

    public void setAsciiStreamAtName(String parameterName, InputStream x, int length) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}, length: {2}", parameterName, x, length);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setAsciiStream(index, x, length);
        }
    }

    public void setAsciiStreamAtName(String parameterName, InputStream value, long length) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}, length: {2}", parameterName, value, length);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setAsciiStream(index, value, length);
        }
    }

    public void setBigDecimalAtName(String parameterName, BigDecimal x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, x);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setBigDecimal(index, x);
        }
    }

    public void setBinaryStreamAtName(String parameterName, InputStream value) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, value);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setBinaryStream(index, value);
        }
    }

    public void setBinaryStreamAtName(String parameterName, InputStream x, int length) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}, length: {2}", parameterName, x, length);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setBinaryStream(index, x, length);
        }
    }

    public void setBinaryStreamAtName(String parameterName, InputStream value, long length) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}, length: {2}", parameterName, value, length);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setBinaryStream(index, value, length);
        }
    }

    public void setBlobAtName(String parameterName, Blob x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, x);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setBlob(index, x);
        }
    }

    public void setBlobAtName(String parameterName, InputStream inputStream) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, inputStream);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setBlob(index, inputStream);
        }
    }

    public void setBlobAtName(String parameterName, InputStream inputStream, long length) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}, length: {2}", parameterName, inputStream, length);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setBlob(index, inputStream, length);
        }
    }

    public void setBooleanAtName(String parameterName, boolean x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, x);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setBoolean(index, x);
        }
    }

    public void setByteAtName(String parameterName, byte x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, x);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setByte(index, x);
        }
    }

    public void setBytesAtName(String parameterName, byte[] x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, x);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setBytes(index, x);
        }
    }

    public void setCharacterStreamAtName(String parameterName, Reader x, int length) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}, length: {2}", parameterName, x, length);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setCharacterStream(index, x, length);
        }
    }

    public void setCharacterStreamAtName(String parameterName, Reader value) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, value);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setCharacterStream(index, value);
        }
    }

    public void setCharacterStreamAtName(String parameterName, Reader value, long length) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}, length: {2}", parameterName, value, length);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setCharacterStream(index, value, length);
        }
    }

    public void setClobAtName(String parameterName, Clob x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, x);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setClob(index, x);
        }
    }

    public void setClobAtName(String parameterName, Reader reader) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, reader);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setClob(index, reader);
        }
    }

    public void setClobAtName(String parameterName, Reader reader, long length) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}, length: {2}", parameterName, reader, length);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setClob(index, reader, length);
        }
    }

    public void setDateAtName(String parameterName, Date x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, x);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setDate(index, x);
        }
    }

    public void setDateAtName(String parameterName, Date d, Calendar cal) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}, cal: {2}", parameterName, d, cal);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setDate(index, d, cal);
        }
    }

    public void setDoubleAtName(String parameterName, double x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, x);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setDouble(index, x);
        }
    }

    public void setFloatAtName(String parameterName, float x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, Float.valueOf(x));
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setFloat(index, x);
        }
    }

    public void setLongAtName(String parameterName, long x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, x);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setLong(index, x);
        }
    }

    public void setNCharacterStreamAtName(String parameterName, Reader value) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, value);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setNCharacterStream(index, value);
        }
    }

    public void setNCharacterStreamAtName(String parameterName, Reader value, long length) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}, length: {2}", parameterName, value, length);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setNCharacterStream(index, value, length);
        }
    }

    public void setNClobAtName(String parameterName, NClob value) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, value);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setNClob(index, value);
        }
    }

    public void setNClobAtName(String parameterName, Reader reader) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, reader);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setNClob(index, reader);
        }
    }

    public void setNClobAtName(String parameterName, Reader reader, long length) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}, length: {2}", parameterName, reader, length);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setClob(index, reader, length);
        }
    }

    public void setNStringAtName(String parameterName, String value) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, value);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setNString(index, value);
        }
    }

    public void setNullAtName(String parameterName, int sqlType) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, sqlType: {1}", parameterName, sqlType);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setNull(index, sqlType);
        }
    }

    public void setNullAtName(String parameterName, int t, String typeName) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, sqlType: {1}, typeName: {2}", parameterName, t, typeName);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setNull(index, t, typeName);
        }
    }

    public void setObjectAtName(String parameterName, Object x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, x);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setObject(index, x);
        }
    }

    public void setObjectAtName(String parameterName, Object x, int targetSqlType) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}, targetSqlType: {2}", parameterName, x, targetSqlType);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setObject(index, x, targetSqlType);
        }
    }

    public void setObjectAtName(String parameterName, Object in, int targetSqlType, int scale) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}, targetSqlType: {2}, scale: {3}", parameterName, in, targetSqlType, scale);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setObject(index, in, targetSqlType, scale);
        }
    }

    public void setObjectAtName(String parameterName, Object x, SQLType targetSqlType) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}, targetSqlType: {2}", parameterName, x, targetSqlType);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setObject(index, x, targetSqlType);
        }
    }

    public void setObjectAtName(String parameterName, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}, targetSqlType: {2}, scaleOrLength: {3}", parameterName, x, targetSqlType, scaleOrLength);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setObject(index, x, targetSqlType, scaleOrLength);
        }
    }

    public void setRefAtName(String parameterName, Ref x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, x);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setRef(index, x);
        }
    }

    public void setRowIdAtName(String parameterName, RowId x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, x);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setRowId(index, x);
        }
    }

    public void setShortAtName(String parameterName, short x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, x);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setShort(index, x);
        }
    }

    public void setSQLXMLAtName(String parameterName, SQLXML xmlObject) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, xmlObject);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setSQLXML(index, xmlObject);
        }
    }

    public void setStringAtName(String parameterName, String x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, x);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setString(index, x);
        }
    }

    public void setTimeAtName(String parameterName, Time x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, x);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setTime(index, x);
        }
    }

    public void setTimeAtName(String parameterName, Time t, Calendar cal) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}, cal: {2}", parameterName, t, cal);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setTime(index, t, cal);
        }
    }

    public void setTimestampAtName(String parameterName, Timestamp x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, x);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setTimestamp(index, x);
        }
    }

    public void setTimestampAtName(String parameterName, Timestamp t, Calendar cal) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}, cal: {2}", parameterName, t, cal);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setTimestamp(index, t, cal);
        }
    }

    public void setUnicodeStreamAtName(String parameterName, InputStream x, int length) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}, length: {2}", parameterName, x, length);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setUnicodeStream(index, x, length);
        }
    }

    public void setURLAtName(String parameterName, URL x) throws SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "parameterName: {0}, parameter: {1}", parameterName, x);
        }
        List<Integer> indexes = this.findIndexByName(parameterName, this.preparedParameterNames);
        for (int index : indexes) {
            this.setURL(index, x);
        }
    }
}

