/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8;

import com.kingbase8.KBProperty;
import com.kingbase8.dispatcher.core.ConnectionMangerV2;
import com.kingbase8.dispatcher.entity.DispatchConnection;
import com.kingbase8.jdbc.KbConnection;
import com.kingbase8.util.Base64;
import com.kingbase8.util.ExpressionProperties;
import com.kingbase8.util.GT;
import com.kingbase8.util.HostSpec;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.LOGGER;
import com.kingbase8.util.SharedTimer;
import com.kingbase8.util.URLCoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Driver
implements java.sql.Driver {
    private static Driver registeredDriver;
    private static final Logger PARENT_LOGGER;
    private static SharedTimer sharedTimer;
    public static AtomicLong ttotal;
    private static boolean isDebug;
    private static final String DEFAULT_PORT = "54321";
    private Properties defaultProperties;

    private synchronized Properties getDefaultProperties() throws IOException {
        if (this.defaultProperties != null) {
            return this.defaultProperties;
        }
        try {
            this.defaultProperties = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                @Override
                public Properties run() throws IOException {
                    return Driver.this.loadDefaultProperties();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        return this.defaultProperties;
    }

    private Properties loadDefaultProperties() throws IOException {
        Properties merged = new Properties();
        try {
            KBProperty.USER.set(merged, System.getProperty("user.name"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            LOGGER.log(Level.FINE, "Can't find our classloader for the Driver; attempt to use the system class loader", new Object[0]);
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl == null) {
            LOGGER.log(Level.WARNING, "Can't find a classloader for the Driver; not loading driver configuration from com/kingbase8/driverconfig.properties", new Object[0]);
            return merged;
        }
        LOGGER.log(Level.FINE, "Loading driver configuration via classloader {0}", cl);
        ArrayList<URL> urls = new ArrayList<URL>();
        Enumeration<URL> urlEnum = cl.getResources("com/kingbase8/driverconfig.properties");
        while (urlEnum.hasMoreElements()) {
            urls.add(urlEnum.nextElement());
        }
        for (int i = urls.size() - 1; i >= 0; --i) {
            URL url = (URL)urls.get(i);
            LOGGER.log(Level.FINE, "Loading driver configuration from: {0}", url);
            InputStream is = url.openStream();
            merged.load(is);
            is.close();
        }
        return merged;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Properties defaults;
        if (url == null) {
            throw new SQLException("url is null");
        }
        if (!url.startsWith("jdbc:kingbase8:")) {
            return null;
        }
        try {
            defaults = this.getDefaultProperties();
        }
        catch (IOException ioe) {
            throw new KSQLException(GT.tr("Error loading default settings from driverconfig.properties", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
        Properties props = new Properties(defaults);
        if (info != null) {
            Set<String> e = info.stringPropertyNames();
            for (String propName : e) {
                String propValue = info.getProperty(propName);
                if (propValue == null) {
                    throw new KSQLException(GT.tr("Properties for the driver contains a non-string value for the key ", new Object[0]) + propName, KSQLState.UNEXPECTED_ERROR);
                }
                props.setProperty(propName, propValue);
            }
        }
        if ((props = Driver.parseURL(url, props)) == null) {
            return null;
        }
        try {
            String password;
            String passwordEncryption;
            if (KBProperty.CONFIGUREPATH.get(props) != null) {
                try {
                    props = Driver.initJDBCCONF(props);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "initJDBCCONF Exception: " + e.getMessage(), new Object[0]);
                    throw new KSQLException(GT.tr(e.getMessage(), new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)e);
                }
            }
            if ((passwordEncryption = KBProperty.PASSWORD_ENCRYPTION.get(props)) != null && (password = props.getProperty("password")) != null && passwordEncryption.equalsIgnoreCase("base64")) {
                props.setProperty("password", new String(Base64.decode(password), "UTF-8"));
            }
            this.setupLoggerFromProperties(props);
            LOGGER.log(Level.FINE, "Connecting with URL: {0}", url);
            long timeout = Driver.timeout(props);
            if (timeout <= 0L) {
                return Driver.makeConnection(url, props);
            }
            ConnectThread ct = new ConnectThread(url, props);
            Thread thread = new Thread((Runnable)ct, "Kingbase8 JDBC driver connection thread");
            thread.setDaemon(true);
            thread.start();
            return ct.getResult(timeout);
        }
        catch (KSQLException ex1) {
            LOGGER.log(Level.FINE, "Connection error: ", ex1);
            throw ex1;
        }
        catch (AccessControlException ace) {
            throw new KSQLException(GT.tr("Your security policy has prevented the connection from being attempted.  You probably need to grant the connect java.net.SocketPermission to the database server host and port that you wish to connect to.", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)ace);
        }
        catch (Exception ex2) {
            LOGGER.log(Level.FINE, "Unexpected connection error: ", ex2);
            throw new KSQLException(GT.tr("Something unusual has occurred to cause the driver to fail. Please report this exception.", new Object[0]), KSQLState.UNEXPECTED_ERROR, (Throwable)ex2);
        }
    }

    public static Properties initJDBCCONF(Properties props) throws Exception {
        Properties p = Driver.loadPropertyFiles(KBProperty.CONFIGUREPATH.get(props), props);
        return p;
    }

    public static Properties loadPropertyFiles(String name, Properties props) throws IOException {
        Properties p = new Properties(props);
        File f = Driver.getFile(name);
        if (!f.exists()) {
            throw new IOException("Configuration file " + f.getAbsolutePath() + " does not exist. Consider adding it to specify db host and login");
        }
        try {
            p.load(new FileInputStream(f));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return p;
    }

    public static File getFile(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null file name is not expected");
        }
        if (name.startsWith("/")) {
            return new File(name);
        }
        return new File(System.getProperty("user.dir"), name);
    }

    private void setupLoggerFromProperties(Properties props) {
        if (!isDebug) {
            String driverLogLevel = KBProperty.LOGGER_LEVEL.get(props);
            ExpressionProperties exprProps = new ExpressionProperties(props, System.getProperties());
            String driverLogFile = KBProperty.LOGGER_FILE.get(exprProps);
            isDebug = LOGGER.setDebugStatus(driverLogLevel, driverLogFile);
        }
    }

    private static Connection makeConnection(String url, Properties props) throws SQLException {
        AtomicLong t1 = new AtomicLong(System.currentTimeMillis());
        boolean useDispatch = KBProperty.USEDISPATCH.getBoolean(props);
        if (useDispatch) {
            DispatchConnection discon = ConnectionMangerV2.createConnection(url, props.getProperty("password", ""), Driver.database(props), props);
            AtomicLong t2 = new AtomicLong(System.currentTimeMillis() - t1.get());
            LOGGER.log(Level.INFO, "this connect consume time:::" + t2.get() + "(ms)", new Object[0]);
            LOGGER.log(Level.INFO, "ALL connect consume time:::" + ttotal.addAndGet(t2.get()) + "(ms)", new Object[0]);
            return discon;
        }
        KbConnection con = new KbConnection(Driver.hostSpecs(props), Driver.user(props), Driver.database(props), props, url);
        if (LOGGER.isLoggable(Level.INFO)) {
            AtomicLong t2 = new AtomicLong(System.currentTimeMillis() - t1.get());
            LOGGER.log(Level.INFO, "this connect consume time:::" + t2.get() + "(ms)", new Object[0]);
            LOGGER.log(Level.INFO, "ALL connect consume time:::" + ttotal.addAndGet(t2.get()) + "(ms)", new Object[0]);
        }
        return con;
    }

    @Override
    public boolean acceptsURL(String url) {
        return Driver.parseURL(url, null) != null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        Properties copy = new Properties(info);
        Properties parse = Driver.parseURL(url, copy);
        if (parse != null) {
            copy = parse;
        }
        KBProperty[] knownProperties = KBProperty.values();
        DriverPropertyInfo[] props = new DriverPropertyInfo[knownProperties.length];
        for (int i = 0; i < props.length; ++i) {
            props[i] = knownProperties[i].toDriverPropertyInfo(copy);
        }
        return props;
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Deprecated
    public static String getVersion() {
        return "Kingbase8 JDBC Driver V008R006C006B0021";
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public static Properties parseURL(String url, Properties defaults) {
        String[] args;
        Properties urlProps = new Properties(defaults);
        String urlServer = url;
        String urlArgs = "";
        int qPos = url.indexOf(63);
        if (qPos != -1) {
            urlServer = url.substring(0, qPos);
            urlArgs = url.substring(qPos + 1);
        }
        if (!urlServer.startsWith("jdbc:kingbase8:")) {
            LOGGER.log(Level.FINE, "JDBC URL must start with \"jdbc:kingbase8:\" but was: {0}", url);
            return null;
        }
        if ((urlServer = urlServer.substring("jdbc:kingbase8:".length())).startsWith("//")) {
            int slash = (urlServer = urlServer.substring(2)).indexOf(47);
            if (slash == -1) {
                LOGGER.log(Level.WARNING, "JDBC URL must contain a / at the end of the host or port: {0}", url);
                return null;
            }
            urlProps.setProperty("DBNAME", URLCoder.decode(urlServer.substring(slash + 1)));
            String[] addresses = urlServer.substring(0, slash).split(",");
            StringBuilder hosts = new StringBuilder();
            StringBuilder ports = new StringBuilder();
            for (String address : addresses) {
                int portIdx = address.lastIndexOf(58);
                if (portIdx != -1 && address.lastIndexOf(93) < portIdx) {
                    String portStr = address.substring(portIdx + 1);
                    try {
                        int port = Integer.parseInt(portStr);
                        if (port < 1 || port > 65535) {
                            LOGGER.log(Level.WARNING, "JDBC URL port: {0} not valid (1:65535) ", portStr);
                            return null;
                        }
                    }
                    catch (NumberFormatException ignore) {
                        LOGGER.log(Level.WARNING, "JDBC URL invalid port number: {0}", portStr);
                        return null;
                    }
                    ports.append(portStr);
                    hosts.append(address.subSequence(0, portIdx));
                } else {
                    ports.append(DEFAULT_PORT);
                    hosts.append(address);
                }
                ports.append(',');
                hosts.append(',');
            }
            ports.setLength(ports.length() - 1);
            hosts.setLength(hosts.length() - 1);
            urlProps.setProperty("PORT", ports.toString());
            urlProps.setProperty("HOST", hosts.toString());
        } else {
            if (defaults == null || !defaults.containsKey("PORT")) {
                urlProps.setProperty("PORT", DEFAULT_PORT);
            }
            if (defaults == null || !defaults.containsKey("HOST")) {
                urlProps.setProperty("HOST", "localhost");
            }
            if (defaults == null || !defaults.containsKey("DBNAME")) {
                urlProps.setProperty("DBNAME", URLCoder.decode(urlServer));
            }
        }
        for (String token : args = urlArgs.split("&")) {
            if (token.isEmpty()) continue;
            int pos = token.indexOf(61);
            if (pos == -1) {
                urlProps.setProperty(token, "");
                continue;
            }
            urlProps.setProperty(token.substring(0, pos), URLCoder.decode(token.substring(pos + 1)));
        }
        return urlProps;
    }

    public static HostSpec[] hostSpecs(Properties props) {
        String[] hosts = props.getProperty("HOST").split(",");
        String[] ports = props.getProperty("PORT").split(",");
        HostSpec[] hostSpecs = new HostSpec[hosts.length];
        for (int i = 0; i < hostSpecs.length; ++i) {
            hostSpecs[i] = new HostSpec(hosts[i], Integer.parseInt(ports[i]));
        }
        return hostSpecs;
    }

    public static String user(Properties props) {
        return props.getProperty("user", "");
    }

    public static String database(Properties props) {
        return props.getProperty("DBNAME", "");
    }

    private static long timeout(Properties props) {
        String timeout = KBProperty.LOGIN_TIMEOUT.get(props);
        if (timeout != null) {
            try {
                return (long)(Float.parseFloat(timeout) * 1000.0f);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "Couldn't parse loginTimeout value: {0}", timeout);
            }
        }
        return (long)DriverManager.getLoginTimeout() * 1000L;
    }

    public static SQLFeatureNotSupportedException notImplemented(Class<?> callClass, String functionName) {
        return new SQLFeatureNotSupportedException(GT.tr("Method {0} is not yet implemented.", callClass.getName() + "." + functionName), KSQLState.NOT_IMPLEMENTED.getState());
    }

    @Override
    public Logger getParentLogger() {
        return PARENT_LOGGER;
    }

    public static SharedTimer getSharedTimer() {
        return sharedTimer;
    }

    public static void register() throws SQLException {
        if (Driver.isRegistered()) {
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        Driver registeredDriver = new Driver();
        DriverManager.registerDriver(registeredDriver);
        Driver.registeredDriver = registeredDriver;
    }

    public static void deregister() throws SQLException {
        if (!Driver.isRegistered()) {
            throw new IllegalStateException("Driver is not registered (or it has not been registered using Driver.register() method)");
        }
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver = null;
    }

    public static boolean isRegistered() {
        return registeredDriver != null;
    }

    static {
        PARENT_LOGGER = Logger.getLogger("com.kingbase8");
        sharedTimer = new SharedTimer();
        ttotal = new AtomicLong(0L);
        isDebug = false;
        try {
            Driver.register();
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class ConnectThread
    implements Runnable {
        private final String url;
        private final Properties props;
        private Connection result;
        private Throwable resultException;
        private boolean abandoned;

        ConnectThread(String url, Properties props) {
            this.url = url;
            this.props = props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Throwable error;
            Connection conn;
            try {
                conn = Driver.makeConnection(this.url, this.props);
                error = null;
            }
            catch (Throwable t) {
                conn = null;
                error = t;
            }
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                if (this.abandoned) {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                } else {
                    this.result = conn;
                    this.resultException = error;
                    this.notify();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Connection getResult(long timeout) throws SQLException {
            long expiry = System.nanoTime() / 1000L + timeout;
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                while (this.result == null) {
                    if (this.resultException != null) {
                        if (this.resultException instanceof SQLException) {
                            this.resultException.fillInStackTrace();
                            throw (SQLException)this.resultException;
                        }
                        throw new KSQLException(GT.tr("Something unusual has occurred to cause the driver to fail. Please report this exception.", new Object[0]), KSQLState.UNEXPECTED_ERROR, this.resultException);
                    }
                    long delay = expiry - System.nanoTime() / 1000L;
                    if (delay <= 0L) {
                        this.abandoned = true;
                        throw new KSQLException(GT.tr("Connection attempt timed out.", new Object[0]), KSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                    try {
                        this.wait(delay);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        this.abandoned = true;
                        throw new RuntimeException(GT.tr("Interrupted while attempting to connect.", new Object[0]));
                    }
                }
                return this.result;
            }
        }
    }
}

