/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgresql.log.Log;
import org.postgresql.log.Logger;

public class JdbcBlackHole {
    static Log LOGGER = Logger.getLogger(JdbcBlackHole.class.getName());

    public static void close(Connection con) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e) {
            LOGGER.trace("Catch SQLException on close connection :", e);
        }
    }

    public static void close(Statement s) {
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (SQLException e) {
            LOGGER.trace("Catch SQLException on close statement :", e);
        }
    }

    public static void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            LOGGER.trace("Catch SQLException on close resultset :", e);
        }
    }
}

