/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.fldr;

import dm.jdbc.desc.Parameter;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.filter.fldr.Callback;
import dm.jdbc.filter.fldr.DmServerInfo;
import dm.jdbc.filter.fldr.FldrManager$1;
import dm.jdbc.filter.fldr.FldrManager$2;
import dm.jdbc.filter.fldr.FldrManager$3;
import dm.jdbc.filter.fldr.FldrManager$4;
import dm.jdbc.filter.fldr.FldrManager$5;
import dm.jdbc.filter.fldr.FldrTableInfo;
import dm.jdbc.filter.fldr.FldrTask;
import dm.jdbc.filter.fldr.HashCode;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.MiscUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FldrManager {
    public static void createConnection(DmdbConnection dmdbConnection) {
        List list = FldrManager.getMppPrimarySites(dmdbConnection);
        if (list == null || list.size() == 0) {
            return;
        }
        dmdbConnection.fldrInfo.fldrExecutor = Executors.newFixedThreadPool(Math.min(Runtime.getRuntime().availableProcessors(), list.size()));
        if (dmdbConnection.fldrInfo.fldrConnMap != null) {
            dmdbConnection.fldrInfo.fldrConnMap.clear();
        } else {
            dmdbConnection.fldrInfo.fldrConnMap = new ConcurrentHashMap();
        }
        FldrManager.doTaskOnEverySite(dmdbConnection.fldrInfo.fldrExecutor, list, list.size(), new FldrManager$1(dmdbConnection));
        dmdbConnection.fldrInfo.setFldrConnSize(dmdbConnection.fldrInfo.fldrConnMap.size());
    }

    public static void prepareStatement(DmdbPreparedStatement dmdbPreparedStatement, String string, int n2, int n3, int n4) {
        DmdbConnection dmdbConnection = dmdbPreparedStatement.connection;
        ConcurrentHashMap concurrentHashMap = dmdbConnection.fldrInfo.fldrConnMap;
        int n5 = dmdbConnection.fldrInfo.getFldrConnSize();
        if (concurrentHashMap == null || n5 == 0 || dmdbConnection.fldrInfo.fldrExecutor == null) {
            return;
        }
        dmdbPreparedStatement.fldrInfo.fldrStmtMap = new ConcurrentHashMap();
        FldrManager.doTaskOnEverySite(dmdbConnection.fldrInfo.fldrExecutor, concurrentHashMap.entrySet(), n5, new FldrManager$2(dmdbPreparedStatement, string, n2, n3, n4));
        dmdbPreparedStatement.fldrInfo.setFldrStmtSize(dmdbPreparedStatement.fldrInfo.fldrStmtMap.size());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fldrPrepareSql(DmdbConnection dmdbConnection, String string, PreparedStatement preparedStatement) {
        if (dmdbConnection.fldrInfo.fldrConnMap == null || dmdbConnection.fldrInfo.getFldrConnSize() <= 0) return;
        int n2 = ((DmdbPreparedStatement)preparedStatement).getRetType();
        if (n2 == 157 && dmdbConnection.isMppFldrInsertEnable()) {
            FldrTableInfo fldrTableInfo;
            ((DmdbPreparedStatement)preparedStatement).fldrInfo.fldrTableInfo = fldrTableInfo = dmdbConnection.dbAccess.b((DmdbPreparedStatement)preparedStatement);
            try {
                if (fldrTableInfo == null || !fldrTableInfo.isCanFastInsert()) return;
                dmdbConnection.dbAccess.a(((DmdbPreparedStatement)preparedStatement).fldrInfo.fldrTableInfo);
                if (!FldrManager.canFldrForInsert((DmdbPreparedStatement)preparedStatement)) return;
                FldrManager.prepareStatement((DmdbPreparedStatement)preparedStatement, string, preparedStatement.getResultSetType(), preparedStatement.getResultSetConcurrency(), preparedStatement.getResultSetHoldability());
                return;
            }
            catch (SQLException sQLException) {
                ((DmdbPreparedStatement)preparedStatement).fldrInfo.clearFldr();
                throw sQLException;
            }
        } else {
            if (n2 != 160 || !dmdbConnection.isMppFldrSelectEnable()) return;
            FldrManager.prepareStatement((DmdbPreparedStatement)preparedStatement, string, preparedStatement.getResultSetType(), preparedStatement.getResultSetConcurrency(), preparedStatement.getResultSetHoldability());
        }
    }

    public static int[] executeBatch(DmdbPreparedStatement dmdbPreparedStatement, int[] nArray) {
        if (!FldrManager.canFldrForInsert(dmdbPreparedStatement)) {
            return nArray;
        }
        int n2 = 0;
        for (DmdbStatement dmdbStatement : dmdbPreparedStatement.fldrInfo.fldrStmtMap.values()) {
            n2 += ((DmdbPreparedStatement)dmdbStatement).getBatchSize() > 0 ? ((DmdbPreparedStatement)dmdbStatement).getBatchSize() : 0;
        }
        FldrManager.doTaskOnEverySite(dmdbPreparedStatement.connection.fldrInfo.fldrExecutor, dmdbPreparedStatement.fldrInfo.fldrStmtMap.values(), dmdbPreparedStatement.fldrInfo.getFldrStmtSize(), new FldrManager$3());
        nArray = new int[n2];
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n3] = -2;
            ++n3;
        }
        return nArray;
    }

    public static List getMppPrimarySites(DmdbConnection dmdbConnection) {
        ArrayList<DmServerInfo> arrayList;
        block6: {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select distinct mailIni.INST_IP, mailIni.INST_PORT, mppItem.ep_seqno FROM");
            stringBuilder.append(" (select * from V$MPP_CFG_ITEM where " + FldrManager.getSeqnoStr() + ") mppItem, ");
            stringBuilder.append(" (select * from V$DM_MAL_INI where " + FldrManager.getSeqnoStr() + ") mailIni");
            stringBuilder.append(" WHERE mppItem.inst_name = mailIni.inst_name order by mppItem.ep_seqno asc;");
            DmdbResultSet dmdbResultSet = null;
            arrayList = new ArrayList<DmServerInfo>();
            try {
                try {
                    dmdbResultSet = DriverUtil.executeQuery(dmdbConnection, stringBuilder.toString());
                    while (dmdbResultSet.next()) {
                        DmServerInfo dmServerInfo = new DmServerInfo(dmdbResultSet.getString(1), Integer.parseInt(dmdbResultSet.getString(2)));
                        dmServerInfo.setEpSeqno(dmdbResultSet.getInt(3));
                        arrayList.add(dmServerInfo);
                    }
                }
                catch (Exception exception) {
                    arrayList.clear();
                    MiscUtil.close((ResultSet)dmdbResultSet);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                MiscUtil.close(dmdbResultSet);
                throw throwable;
            }
            MiscUtil.close((ResultSet)dmdbResultSet);
        }
        return arrayList;
    }

    private static String getSeqnoStr() {
        return "SF_GET_EP_SEQNO(rowid)=sf_get_self_ep_seqno()";
    }

    public static void addBatch(DmdbPreparedStatement dmdbPreparedStatement) {
        DmdbPreparedStatement dmdbPreparedStatement2;
        if (!FldrManager.canFldrForInsert(dmdbPreparedStatement)) {
            return;
        }
        Object[] objectArray = dmdbPreparedStatement.curRowDatas;
        int n2 = -1;
        if (dmdbPreparedStatement.fldrInfo.fldrTableInfo != null) {
            int n3 = dmdbPreparedStatement.fldrInfo.fldrTableInfo.getDisType();
            if (n3 == 2) {
                n2 = FldrManager.calcHashDisEpSeqno(dmdbPreparedStatement, objectArray);
            } else if (n3 == 1) {
                n2 = FldrManager.calcRandDisEpSeqno(dmdbPreparedStatement, objectArray);
            }
        }
        if ((dmdbPreparedStatement2 = (DmdbPreparedStatement)dmdbPreparedStatement.fldrInfo.fldrStmtMap.get(n2)) != null) {
            int n4 = 0;
            while (n4 < objectArray.length) {
                dmdbPreparedStatement2.do_setObject(n4 + 1, objectArray[n4]);
                ++n4;
            }
        } else {
            throw new SQLException("No pstmt for ep_seqno: " + n2);
        }
        dmdbPreparedStatement2.do_addBatch();
    }

    private static int calcRandDisEpSeqno(DmdbPreparedStatement dmdbPreparedStatement, Object[] objectArray) {
        int n2 = dmdbPreparedStatement.irow;
        return n2 % dmdbPreparedStatement.fldrInfo.getFldrStmtSize();
    }

    private static int calcHashDisEpSeqno(DmdbPreparedStatement dmdbPreparedStatement, Object[] objectArray) {
        int[] nArray = dmdbPreparedStatement.fldrInfo.fldrTableInfo.getDisColIds();
        int[] nArray2 = dmdbPreparedStatement.fldrInfo.fldrTableInfo.getPrepareColIds();
        int[] nArray3 = dmdbPreparedStatement.fldrInfo.fldrTableInfo.getHashMap();
        long l2 = 0L;
        if (nArray != null && nArray.length > 0 && nArray2 != null && nArray2.length > 0 && nArray3 != null && nArray3.length > 0) {
            long[] lArray = new long[nArray.length];
            int n2 = 0;
            while (n2 < nArray.length) {
                int n3 = 0;
                while (n3 < nArray2.length) {
                    if (nArray[n2] == nArray2[n3]) {
                        Parameter parameter = dmdbPreparedStatement.bindParameters[n3];
                        lArray[n2] = HashCode.hc_get_fold_fun(parameter, objectArray[n3], dmdbPreparedStatement.connection);
                    }
                    ++n3;
                }
                ++n2;
            }
            l2 = HashCode.hc_calc_fold_value(lArray);
            return nArray3[(int)(l2 % (long)nArray3.length)];
        }
        return -1;
    }

    public static boolean canFldrForSelect(DmdbStatement dmdbStatement) {
        return dmdbStatement.connection.isMppFldrSelectEnable() && dmdbStatement.fldrInfo.getFldrStmtSize() > 0;
    }

    public static boolean canFldrForInsert(DmdbPreparedStatement dmdbPreparedStatement) {
        if (!dmdbPreparedStatement.connection.isMppFldrInsertEnable()) {
            return false;
        }
        FldrTableInfo fldrTableInfo = dmdbPreparedStatement.fldrInfo.fldrTableInfo;
        if (fldrTableInfo == null || !fldrTableInfo.isCanFastInsert()) {
            return false;
        }
        if (fldrTableInfo.getDisType() == 1) {
            return true;
        }
        if (fldrTableInfo.getDisType() == 2) {
            return fldrTableInfo.isIncludeAllDisCols();
        }
        return false;
    }

    public static void createStatement(DmdbStatement dmdbStatement, int n2, int n3, int n4) {
        if (!dmdbStatement.connection.isMppFldrSelectEnable()) {
            return;
        }
        DmdbConnection dmdbConnection = dmdbStatement.connection;
        ConcurrentHashMap concurrentHashMap = dmdbConnection.fldrInfo.fldrConnMap;
        int n5 = dmdbConnection.fldrInfo.getFldrConnSize();
        if (concurrentHashMap == null || n5 == 0 || dmdbConnection.fldrInfo.fldrExecutor == null) {
            return;
        }
        if (dmdbStatement.fldrInfo.fldrStmtMap != null) {
            dmdbStatement.fldrInfo.fldrStmtMap.clear();
        } else {
            dmdbStatement.fldrInfo.fldrStmtMap = new ConcurrentHashMap();
        }
        FldrManager.doTaskOnEverySite(dmdbConnection.fldrInfo.fldrExecutor, concurrentHashMap.entrySet(), n5, new FldrManager$4(dmdbStatement, n2, n3, n4));
        dmdbStatement.fldrInfo.setFldrStmtSize(dmdbStatement.fldrInfo.fldrStmtMap.size());
    }

    public static boolean doTaskOnEverySite(ExecutorService executorService, Collection collection, int n2, Callback callback) {
        if (n2 == 0 || executorService == null) {
            return false;
        }
        CountDownLatch countDownLatch = new CountDownLatch(n2);
        FldrTask[] fldrTaskArray = new FldrTask[n2];
        int n3 = 0;
        for (Object e2 : collection) {
            fldrTaskArray[n3] = new FldrManager$5(countDownLatch, callback, e2);
            executorService.execute(fldrTaskArray[n3]);
            ++n3;
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {}
        boolean bl = true;
        FldrTask[] fldrTaskArray2 = fldrTaskArray;
        int n4 = fldrTaskArray.length;
        int n5 = 0;
        while (n5 < n4) {
            FldrTask fldrTask = fldrTaskArray2[n5];
            if (!fldrTask.isSuccess()) {
                if (fldrTask.getError() != null) {
                    throw fldrTask.getError();
                }
                bl = false;
                break;
            }
            ++n5;
        }
        return bl;
    }
}

