/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.convert.DB2J;
import dm.jdbc.desc.Column;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbSQLXML$SimpleSaxToReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.SQLXML;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;

public class DmdbSQLXML
implements SQLXML {
    private boolean isClosed = false;
    private boolean workingWithResult;
    private boolean fromResultSet;
    private byte[] bytes;
    private Column column;
    private DmdbConnection connection;
    private String stringRep;
    private XMLInputFactory inputFactory;
    private XMLOutputFactory outputFactory;
    private DOMResult asDOMResult;
    private SAXResult asSAXResult;
    private StringWriter asStringWriter;
    private ByteArrayOutputStream asByteArrayOutputStream;
    private DmdbSQLXML$SimpleSaxToReader saxToReaderConverter;

    protected DmdbSQLXML(byte[] byArray, Column column, DmdbConnection dmdbConnection) {
        this.bytes = byArray;
        this.column = column;
        this.connection = dmdbConnection;
        this.fromResultSet = true;
    }

    protected DmdbSQLXML() {
        this.fromResultSet = false;
    }

    @Override
    public synchronized void free() {
        this.stringRep = null;
        this.asDOMResult = null;
        this.asSAXResult = null;
        this.inputFactory = null;
        this.outputFactory = null;
        this.bytes = null;
        this.column = null;
        this.connection = null;
        this.workingWithResult = false;
        this.isClosed = true;
    }

    @Override
    public synchronized String getString() {
        this.checkClosed();
        this.checkWorkingWithResult();
        if (this.fromResultSet) {
            return DB2J.toString(this.bytes, this.column, this.connection);
        }
        return this.stringRep;
    }

    private synchronized void checkClosed() {
        if (this.isClosed) {
            DBError.ECJDBC_OBJ_CLOSED.throwz(new Object[0]);
        }
    }

    private synchronized void checkWorkingWithResult() {
        if (this.workingWithResult) {
            DBError.ECJDBC_SQLXML_WORKING_WITH_RESULT.throwz(new Object[0]);
        }
    }

    @Override
    public synchronized void setString(String string) {
        this.checkClosed();
        this.checkWorkingWithResult();
        this.stringRep = string;
        this.fromResultSet = false;
        this.workingWithResult = true;
    }

    public synchronized boolean isEmpty() {
        this.checkClosed();
        if (!this.fromResultSet) {
            return this.stringRep == null || this.stringRep.length() == 0;
        }
        return false;
    }

    @Override
    public synchronized InputStream getBinaryStream() {
        this.checkClosed();
        this.checkWorkingWithResult();
        return DB2J.toBinaryStream(this.bytes, this.column, this.connection);
    }

    @Override
    public synchronized Reader getCharacterStream() {
        this.checkClosed();
        this.checkWorkingWithResult();
        return DB2J.toCharacterStream(this.bytes, this.column, this.connection);
    }

    public Source getSource(Class clazz) {
        this.checkClosed();
        this.checkWorkingWithResult();
        if (clazz == null || clazz.equals(SAXSource.class)) {
            InputSource inputSource = null;
            inputSource = this.fromResultSet ? new InputSource(DB2J.toCharacterStream(this.bytes, this.column, this.connection)) : new InputSource(new StringReader(this.stringRep));
            return new SAXSource(inputSource);
        }
        if (clazz.equals(DOMSource.class)) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                InputSource inputSource = null;
                inputSource = this.fromResultSet ? new InputSource(DB2J.toCharacterStream(this.bytes, this.column, this.connection)) : new InputSource(new StringReader(this.stringRep));
                return new DOMSource(documentBuilder.parse(inputSource));
            }
            catch (Throwable throwable) {
                DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
            }
        } else {
            if (clazz.equals(StreamSource.class)) {
                Reader reader = null;
                reader = this.fromResultSet ? DB2J.toCharacterStream(this.bytes, this.column, this.connection) : new StringReader(this.stringRep);
                return new StreamSource(reader);
            }
            if (clazz.equals(StAXSource.class)) {
                try {
                    Reader reader = null;
                    reader = this.fromResultSet ? DB2J.toCharacterStream(this.bytes, this.column, this.connection) : new StringReader(this.stringRep);
                    return new StAXSource(this.inputFactory.createXMLStreamReader(reader));
                }
                catch (XMLStreamException xMLStreamException) {
                    DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
                }
            } else {
                DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
            }
        }
        return null;
    }

    @Override
    public synchronized OutputStream setBinaryStream() {
        this.checkClosed();
        this.checkWorkingWithResult();
        this.workingWithResult = true;
        this.asByteArrayOutputStream = new ByteArrayOutputStream();
        return this.asByteArrayOutputStream;
    }

    @Override
    public synchronized Writer setCharacterStream() {
        this.checkClosed();
        this.checkWorkingWithResult();
        this.workingWithResult = true;
        return this.setCharacterStreamInternal();
    }

    private synchronized Writer setCharacterStreamInternal() {
        this.asStringWriter = new StringWriter();
        return this.asStringWriter;
    }

    public Result setResult(Class clazz) {
        this.checkClosed();
        this.checkWorkingWithResult();
        this.workingWithResult = true;
        this.asDOMResult = null;
        this.asSAXResult = null;
        this.saxToReaderConverter = null;
        this.stringRep = null;
        this.asStringWriter = null;
        this.asByteArrayOutputStream = null;
        if (clazz == null || clazz.equals(SAXResult.class)) {
            this.saxToReaderConverter = new DmdbSQLXML$SimpleSaxToReader(this);
            this.asSAXResult = new SAXResult(this.saxToReaderConverter);
            return this.asSAXResult;
        }
        if (clazz.equals(DOMResult.class)) {
            this.asDOMResult = new DOMResult();
            return this.asDOMResult;
        }
        if (clazz.equals(StreamResult.class)) {
            return new StreamResult(this.setCharacterStreamInternal());
        }
        if (clazz.equals(StAXResult.class)) {
            try {
                if (this.outputFactory == null) {
                    this.outputFactory = XMLOutputFactory.newInstance();
                }
                return new StAXResult(this.outputFactory.createXMLEventWriter(this.setCharacterStreamInternal()));
            }
            catch (XMLStreamException xMLStreamException) {
                DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
            }
        } else {
            DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
        }
        return null;
    }

    private Reader binaryInputStreamStreamToReader(ByteArrayOutputStream byteArrayOutputStream) {
        try {
            String string = "UTF-8";
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                XMLStreamReader xMLStreamReader = this.inputFactory.createXMLStreamReader(byteArrayInputStream);
                int n2 = 0;
                while ((n2 = xMLStreamReader.next()) != 8) {
                    if (n2 != 7) continue;
                    String string2 = xMLStreamReader.getEncoding();
                    if (string2 != null) {
                        string = string2;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {}
            return new StringReader(new String(byteArrayOutputStream.toByteArray(), string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    protected String readerToString(Reader reader) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        char[] cArray = new char[512];
        try {
            while ((n2 = reader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(iOException);
        }
        return stringBuffer.toString();
    }

    public synchronized Reader serializeAsCharacterStream() {
        this.checkClosed();
        if (this.workingWithResult) {
            if (this.stringRep != null) {
                return new StringReader(this.stringRep);
            }
            if (this.asDOMResult != null) {
                return new StringReader(this.domSourceToString());
            }
            if (this.asStringWriter != null) {
                return new StringReader(this.asStringWriter.toString());
            }
            if (this.asSAXResult != null) {
                return this.saxToReaderConverter.toReader();
            }
            if (this.asByteArrayOutputStream != null) {
                return this.binaryInputStreamStreamToReader(this.asByteArrayOutputStream);
            }
        }
        return DB2J.toCharacterStream(this.bytes, this.column, this.connection);
    }

    protected String domSourceToString() {
        try {
            DOMSource dOMSource = new DOMSource(this.asDOMResult.getNode());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(dOMSource, streamResult);
            return stringWriter.toString();
        }
        catch (Throwable throwable) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(throwable);
            return null;
        }
    }

    public synchronized String serializeAsString() {
        this.checkClosed();
        if (this.workingWithResult) {
            if (this.stringRep != null) {
                return this.stringRep;
            }
            if (this.asDOMResult != null) {
                return this.domSourceToString();
            }
            if (this.asStringWriter != null) {
                return this.asStringWriter.toString();
            }
            if (this.asSAXResult != null) {
                return this.readerToString(this.saxToReaderConverter.toReader());
            }
            if (this.asByteArrayOutputStream != null) {
                return this.readerToString(this.binaryInputStreamStreamToReader(this.asByteArrayOutputStream));
            }
        }
        return DB2J.toString(this.bytes, this.column, this.connection);
    }

    public String toString() {
        try {
            return this.serializeAsString();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }
}

