/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc;

import dm.jdbc.desc.Configuration;
import dm.jdbc.desc.DmProperties;
import dm.jdbc.desc.EP;
import dm.jdbc.desc.EPGroup$EPSelector;
import dm.jdbc.desc.EPGroup$HeadFirstSelector;
import dm.jdbc.desc.EPGroup$WellDistributeSelector;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.filter.log.ILogger;
import dm.jdbc.filter.log.LogFactory;
import dm.jdbc.util.MiscUtil;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class EPGroup
implements Serializable {
    private static ILogger log = LogFactory.getLog(EPGroup.class);
    public String name;
    public List epList = null;
    public DmProperties props;
    public static final int RECONNECT_OFF = 0;
    public static final int RECONNECT_CONN_ERROR = 1;
    public static final int RECONNECT_HEAD_FIRST = 2;
    public static final int RECONNECT_LOAD_BALANCE = 4;
    public static final int RECONNECT_SERVER_NOTIFY = 8;
    public static final int RECONNECT_LOAD_BALANCE_AND_CONN_ERROR = 5;
    public static final int RECONNECT_HEAD_FIRST_AND_CONN_ERROR = 3;
    public static final int RECONNECT_WHEN_SERVER_NOTIFY_AND_CONN_ERROR = 9;
    public int reconnect = (Integer)Configuration.reconnect.getDefault();
    public int switchTimes = (Integer)Configuration.switchTimes.getDefault();
    public int switchInterval = (Integer)Configuration.switchInterval.getDefault();
    public int checkFreq = (Integer)Configuration.checkFreq.getDefault();
    public static final int LOGIN_MODE_PRIMARY_FIRST = 0;
    public static final int LOGIN_MODE_PRIMARY_ONLY = 1;
    public static final int LOGIN_MODE_STANDBY_ONLY = 2;
    public static final int LOGIN_MODE_STANDBY_FIRST = 3;
    public static final int LOGIN_MODE_NORMAL_FIRST = 4;
    public int loginMode = (Integer)Configuration.loginMode.getDefault();
    public static final int LOGIN_STATUS_OFF = 0;
    public static final int LOGIN_STATUS_OPEN = 4;
    public static final int LOGIN_STATUS_MOUNT = 3;
    public static final int LOGIN_STATUS_SUSPEND = 5;
    public int loginStatus = (Integer)Configuration.loginStatus.getDefault();
    public boolean loginDscCtrl = (Boolean)Configuration.loginDscCtrl.getDefault();
    public static final int CLUSTER_NORMAL = 0;
    public static final int CLUSTER_RW = 1;
    public static final int CLUSTER_DW = 2;
    public static final int CLUSTER_DSC = 3;
    public static final int CLUSTER_MPP = 4;
    public int cluster = (Integer)Configuration.cluster.getDefault();
    public EPGroup$EPSelector epSelector = null;
    public String user;
    public String password;
    public AtomicLong sessions = new AtomicLong(0L);
    public long checkTime = 0L;

    public EPGroup(String string, List list) {
        this.name = string;
        this.epList = list;
    }

    public EPGroup setAttributes(DmProperties dmProperties) {
        int n2 = this.cluster = dmProperties.getInt(Configuration.rwSeparate) == 1 ? 1 : this.cluster;
        if (this.cluster == 1) {
            this.loginMode = 1;
            this.loginStatus = 4;
            this.reconnect = 1;
        }
        if (dmProperties.contains(Configuration.user)) {
            this.user = dmProperties.getProperty(Configuration.user.getName());
        }
        if (dmProperties.contains(Configuration.password)) {
            this.password = dmProperties.getProperty(Configuration.password.getName());
        }
        if (dmProperties.contains(Configuration.cluster)) {
            this.cluster = Configuration.parseCluster(dmProperties);
        }
        if (dmProperties.contains(Configuration.loginMode)) {
            this.loginMode = dmProperties.getInt(Configuration.loginMode);
        }
        if (dmProperties.contains(Configuration.loginStatus)) {
            this.loginStatus = dmProperties.getInt(Configuration.loginStatus);
        }
        if (dmProperties.contains(Configuration.loginDscCtrl)) {
            this.loginDscCtrl = dmProperties.getBoolean(Configuration.loginDscCtrl);
        }
        if (dmProperties.contains(Configuration.switchTimes)) {
            this.switchTimes = dmProperties.getInt(Configuration.switchTimes);
        }
        if (dmProperties.contains(Configuration.switchInterval)) {
            this.switchInterval = dmProperties.getInt(Configuration.switchInterval);
        }
        if (dmProperties.contains(Configuration.reconnect)) {
            this.reconnect = dmProperties.getInt(Configuration.reconnect);
        }
        if (dmProperties.contains(Configuration.checkFreq)) {
            this.checkFreq = dmProperties.getInt(Configuration.checkFreq);
        }
        int n3 = dmProperties.getInt(Configuration.epSelector);
        if (this.epSelector == null || n3 != this.epSelector.type) {
            switch (n3) {
                case 0: {
                    this.epSelector = new EPGroup$WellDistributeSelector(this);
                    break;
                }
                case 1: {
                    this.epSelector = new EPGroup$HeadFirstSelector(this);
                }
            }
        }
        return this;
    }

    public void connect(DmdbConnection dmdbConnection) {
        EP[] ePArray = this.epSelector.start();
        SQLException sQLException = null;
        int n2 = this.epList.size() == 1 ? 1 : this.switchTimes + 1;
        int n3 = 0;
        while (n3 < n2) {
            if (n3 != 0) {
                MiscUtil.sleep(this.switchInterval);
            }
            log.debug("try connect loop " + n3);
            try {
                this.epSelector.select(ePArray, dmdbConnection, n3 == 0, n3 == n2 - 1);
                this.sessions.incrementAndGet();
                return;
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                ++n3;
            }
        }
        throw sQLException;
    }

    public void connect(DmdbConnection dmdbConnection, int n2) {
        EP eP = (EP)this.epList.get(n2);
        log.debug("try connect EP num: " + n2 + " [" + eP.host + ":" + eP.port + "]");
        eP.connect(dmdbConnection);
    }

    public void incrementSession(DmdbConnection dmdbConnection) {
        this.sessions.incrementAndGet();
    }

    public void decrementSession(DmdbConnection dmdbConnection) {
        this.sessions.decrementAndGet();
    }

    static /* synthetic */ ILogger access$0() {
        return log;
    }
}

