/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.jni;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.jni.DmUKeyInfo;
import dm.jdbc.util.ByteUtil;

public class DmUkeyDll {
    static {
        System.loadLibrary("dmukey_java");
    }

    public static native long crypto_load_library(byte[] var0, int var1);

    public static native long crypto_login(long var0, byte[] var2, int var3);

    public static native int crypto_get_name(long var0, byte[] var2, int var3);

    public static native int crypto_read_cert(long var0, long var2, byte[] var4, int var5);

    public static native int cipher_asym_sign(long var0, int var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8);

    public static native boolean crypto_logout(long var0, long var2);

    public static native int cipher_get_auth_type(DmUKeyInfo var0);

    public static native int cipher_user_auth_gen_key(DmUKeyInfo var0);

    public static native int cipher_user_auth_sign(DmUKeyInfo var0);

    public static native int cipher_user_auth_check_digest(DmUKeyInfo var0);

    public static native int cipher_user_auth_update(DmUKeyInfo var0);

    public static native int cipher_user_auth_destroy_key(DmUKeyInfo var0);

    public static DmUKeyInfo load(DmdbConnection dmdbConnection) {
        try {
            int n2;
            DmUKeyInfo dmUKeyInfo = new DmUKeyInfo();
            dmUKeyInfo.authType = 1;
            byte[] byArray = dmdbConnection.uKeyName.getBytes();
            dmUKeyInfo.handle = DmUkeyDll.crypto_load_library(byArray, byArray.length);
            byte[] byArray2 = dmdbConnection.uKeyPin.getBytes();
            dmUKeyInfo.para = DmUkeyDll.crypto_login(dmUKeyInfo.handle, byArray2, byArray2.length);
            dmUKeyInfo.name = new byte[128];
            dmUKeyInfo.nameLength = DmUkeyDll.crypto_get_name(dmUKeyInfo.handle, dmUKeyInfo.name, dmUKeyInfo.name.length);
            try {
                n2 = DmUkeyDll.cipher_get_auth_type(dmUKeyInfo);
                if (n2 != 0) {
                    DBError.throwRuntimeException("ukey init error!");
                }
            }
            catch (Throwable throwable) {
                dmUKeyInfo.authType = 1;
            }
            if (dmUKeyInfo.authType == 2) {
                n2 = DmUkeyDll.cipher_user_auth_gen_key(dmUKeyInfo);
                if (n2 != 0) {
                    DBError.throwRuntimeException("ukey init error!");
                }
            } else if (dmUKeyInfo.authType == 1) {
                dmUKeyInfo.cert = new byte[4096];
                dmUKeyInfo.certLength = DmUkeyDll.crypto_read_cert(dmUKeyInfo.handle, dmUKeyInfo.para, dmUKeyInfo.cert, dmUKeyInfo.cert.length);
            } else {
                DBError.throwRuntimeException("ukey init error! invalid auth type: " + dmUKeyInfo.authType);
            }
            return dmUKeyInfo;
        }
        catch (Throwable throwable) {
            DBError.throwRuntimeException("ukey init error!", throwable);
            return null;
        }
    }

    public static void auth(DmdbConnection dmdbConnection) {
        DmUKeyInfo dmUKeyInfo = dmdbConnection.dbAccess.i;
        if (dmUKeyInfo == null) {
            return;
        }
        try {
            if (dmUKeyInfo.authType == 2) {
                dmUKeyInfo.userName = ByteUtil.fromString(dmdbConnection.user, dmdbConnection.getServerEncoding());
                dmUKeyInfo.userPassword = ByteUtil.fromString(dmdbConnection.password, dmdbConnection.getServerEncoding());
                int n2 = DmUkeyDll.cipher_user_auth_sign(dmUKeyInfo);
                if (n2 != 0) {
                    DBError.ECJDBC_COMMUNITION_ERROR.throwz("ukey login failed!");
                }
            } else if (dmUKeyInfo.authType == 1) {
                dmUKeyInfo.signdata = new byte[4096];
                dmUKeyInfo.signdataLength = DmUkeyDll.cipher_asym_sign(dmUKeyInfo.handle, 0, null, 0, dmUKeyInfo.random, dmUKeyInfo.random.length, dmUKeyInfo.signdata, dmUKeyInfo.signdata.length);
            }
        }
        catch (Throwable throwable) {
            DBError.ECJDBC_COMMUNITION_ERROR.throwz(throwable);
        }
    }

    public static void login(DmdbConnection dmdbConnection) {
        DmUKeyInfo dmUKeyInfo = dmdbConnection.dbAccess.i;
        if (dmUKeyInfo == null) {
            return;
        }
        if (dmUKeyInfo.authType == 2) {
            byte[] byArray = dmdbConnection.dbAccess.b.e(0, 64);
            ByteUtil.setUB2(byArray, 14, 0);
            ByteUtil.setUB4(byArray, 6, 0L);
            dmUKeyInfo.msgDigest = byArray;
            int n2 = DmUkeyDll.cipher_user_auth_check_digest(dmUKeyInfo);
            if (n2 != 0) {
                DBError.ECJDBC_COMMUNITION_ERROR.throwz("ukey login failed!");
            }
        }
    }

    public static void logout(DmdbConnection dmdbConnection) {
        DmUKeyInfo dmUKeyInfo = dmdbConnection.dbAccess.i;
        if (dmUKeyInfo == null) {
            return;
        }
        if (dmUKeyInfo.authType == 2) {
            DmUkeyDll.cipher_user_auth_destroy_key(dmUKeyInfo);
        }
        try {
            DmUkeyDll.crypto_logout(dmUKeyInfo.handle, dmUKeyInfo.para);
        }
        catch (Throwable throwable) {}
    }
}

