/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.collect;

import com.jxdinfo.hussar.support.log.client.ElasticLowerClient;
import com.jxdinfo.hussar.support.log.collect.BaseLogCollect;
import com.jxdinfo.hussar.support.mq.HussarMQManager;
import com.jxdinfo.hussar.support.mq.consumer.HussarMQConsumer;
import com.jxdinfo.hussar.support.mq.consumer.HussarMQMessageListener;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationEventPublisher;

public class MqLogCollect
extends BaseLogCollect
implements DisposableBean {
    private final Logger logger = LoggerFactory.getLogger(MqLogCollect.class);
    private final HussarMQManager hussarMQManager;
    private HussarMQConsumer<List<String>> logConsumer;
    private HussarMQConsumer<List<String>> traceLogConsumer;

    public MqLogCollect(ElasticLowerClient elasticLowerClient, ApplicationEventPublisher applicationEventPublisher, HussarMQManager hussarMQManager) {
        this.elasticLowerClient = elasticLowerClient;
        this.applicationEventPublisher = applicationEventPublisher;
        this.hussarMQManager = hussarMQManager;
        this.logger.info("sending log ready!");
    }

    public void mqStart() {
        this.logConsumer = this.hussarMQManager.newConsumer("hussar_log_list").setListener((HussarMQMessageListener)new LogListener("hussar_log_list")).build();
        this.traceLogConsumer = this.hussarMQManager.newConsumer("hussar_log_trace_list").setListener((HussarMQMessageListener)new LogListener("hussar_log_trace_list")).build();
        this.logger.info("MqLogCollect is starting!");
    }

    public void destroy() throws Exception {
        if (this.logConsumer != null && this.logConsumer.isRunning()) {
            this.logger.warn("MqLogCollect: logConsumer not stopped!");
            this.logConsumer.stop();
        }
        if (this.traceLogConsumer != null && this.traceLogConsumer.isRunning()) {
            this.logger.warn("MqLogCollect: traceLogConsumer not stopped!");
            this.traceLogConsumer.stop();
        }
    }

    public class LogListener
    implements HussarMQMessageListener<List<String>> {
        private final String key;

        public LogListener(String key) {
            this.key = key;
        }

        public void onMessage(List<String> message) throws Throwable {
            if (MqLogCollect.this.logger.isDebugEnabled() && CollectionUtils.isNotEmpty(message)) {
                for (String log : message) {
                    MqLogCollect.this.logger.debug("Received log from {}: {}", (Object)this.key, (Object)log);
                }
            }
            if ("hussar_log_list".equals(this.key)) {
                MqLogCollect.this.sendLog(MqLogCollect.this.getRunLogIndex(), message);
                MqLogCollect.this.publisherMonitorEvent(message);
            } else if ("hussar_log_trace_list".equals(this.key)) {
                MqLogCollect.this.sendTraceLogList(MqLogCollect.this.getTraceLogIndex(), message);
            }
        }
    }
}

