/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.monitor;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.log.core.AbstractClient;
import com.jxdinfo.hussar.support.log.monitor.LogMonitorListener;
import com.jxdinfo.hussar.support.log.rule.entity.LogWarnRule;
import com.jxdinfo.hussar.support.log.rule.service.LogWarnRuleService;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LogMonitorRuleConfig {
    private static final Logger logger = LoggerFactory.getLogger(LogMonitorListener.class);
    @Autowired
    private AbstractClient cacheClient;
    @Autowired
    private LogWarnRuleService logWarnRuleService;

    private static void parserConfig(LogWarnRule logWarnRule, Map<String, List<LogWarnRule>> ruleMap) {
        String key = LogMonitorRuleConfig.getKey(logWarnRule.getServerName(), logWarnRule.getServerEnv());
        if (ruleMap.containsKey(key)) {
            List<LogWarnRule> warningRules = ruleMap.get(key);
            warningRules.add(logWarnRule);
            ruleMap.put(key, warningRules);
        } else {
            ArrayList<LogWarnRule> lists = new ArrayList<LogWarnRule>();
            lists.add(logWarnRule);
            ruleMap.put(key, lists);
        }
    }

    private static String getKey(String appName, String env) {
        return appName + ":" + env;
    }

    public List<LogWarnRule> getMonitorRuleConfig(Map<String, List<LogWarnRule>> ruleMap, String appName, String env) {
        if (HussarUtils.isEmpty(ruleMap)) {
            return null;
        }
        return ruleMap.get(LogMonitorRuleConfig.getKey(appName, env));
    }

    public Map<String, List<LogWarnRule>> getMonitorRuleMap() {
        LinkedHashMap<String, List<LogWarnRule>> ruleMap = (LinkedHashMap<String, List<LogWarnRule>>)this.cacheClient.get("hussarLog:warnRule");
        if (HussarUtils.isEmpty((Object)ruleMap) && this.initMonitorRuleConfig(ruleMap = new LinkedHashMap<String, List<LogWarnRule>>())) {
            this.cacheClient.setObj("hussarLog:warnRule", ruleMap);
        }
        return ruleMap;
    }

    private boolean initMonitorRuleConfig(Map<String, List<LogWarnRule>> ruleMap) {
        List ruleList = this.logWarnRuleService.list((Wrapper)new LambdaQueryWrapper().eq(LogWarnRule::getRuleStatus, (Object)"0"));
        if (HussarUtils.isEmpty((Object)ruleList)) {
            return false;
        }
        for (LogWarnRule logWarnRule : ruleList) {
            LogMonitorRuleConfig.parserConfig(logWarnRule, ruleMap);
        }
        return true;
    }
}

