/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.rule.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarTenantEntity;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.lang.MultiLangUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.log.core.AbstractClient;
import com.jxdinfo.hussar.support.log.rule.entity.LogWarnRule;
import com.jxdinfo.hussar.support.log.rule.mapper.LogWarnRuleMapper;
import com.jxdinfo.hussar.support.log.rule.service.LogWarnRuleService;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarDs(value="master")
public class LogWarnRuleServiceImpl
extends HussarServiceImpl<LogWarnRuleMapper, LogWarnRule>
implements LogWarnRuleService {
    @Autowired
    private AbstractClient cacheClient;

    @Override
    public boolean saveWarnRule(LogWarnRule logWarnRule) {
        boolean flag;
        String errorMsg;
        long num;
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)((Object)logWarnRule)), (String)MultiLangUtil.getTranslateName((String)"log::warn.rule.cannot.be.empty"));
        String ruleName = logWarnRule.getRuleName();
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)ruleName), (String)MultiLangUtil.getTranslateName((String)"log::warn.rule.name.cannot.be.empty"));
        Long ruleId = logWarnRule.getRuleId();
        String tenantCode = this.getCurrentTenantCode();
        if (HussarUtils.isEmpty((Object)ruleId)) {
            logWarnRule.setRuleStatus("0");
            logWarnRule.setTenantCode(tenantCode);
        } else {
            LogWarnRule old = (LogWarnRule)((Object)this.getById(ruleId));
            HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)((Object)old)), (String)MultiLangUtil.getTranslateName((String)"log::warn.rule.not.exists"));
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(LogWarnRule::getRuleName, (Object)ruleName);
        wrapper.eq(HussarTenantEntity::getTenantCode, (Object)tenantCode);
        if (HussarUtils.isNotEmpty((Object)ruleId)) {
            wrapper.ne(LogWarnRule::getRuleId, (Object)ruleId);
        }
        HussarException.throwBy(((num = this.count((Wrapper)wrapper)) > 0L ? 1 : 0) != 0, (String)MultiLangUtil.getTranslateName((String)"log::duplicate.rule.name"));
        wrapper.clear();
        String serverName = logWarnRule.getServerName();
        String className = logWarnRule.getClassName();
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)serverName), (String)MultiLangUtil.getTranslateName((String)"log::service.name.cannot.be.empty"));
        wrapper.eq(LogWarnRule::getServerName, (Object)serverName);
        wrapper.eq(HussarTenantEntity::getTenantCode, (Object)tenantCode);
        if (HussarUtils.isEmpty((Object)className)) {
            wrapper.isNull(LogWarnRule::getClassName);
            errorMsg = MultiLangUtil.getTranslateName((String)"log::global.warn.rule.for.service.name.already.exists");
        } else {
            wrapper.eq(LogWarnRule::getClassName, (Object)className);
            errorMsg = MultiLangUtil.getTranslateName((String)"log::class.name.warn.rule.for.service.name.already.exists");
        }
        if (HussarUtils.isNotEmpty((Object)ruleId)) {
            wrapper.ne(LogWarnRule::getRuleId, (Object)ruleId);
        }
        HussarException.throwBy(((num = this.count((Wrapper)wrapper)) > 0L ? 1 : 0) != 0, (String)errorMsg);
        String env = logWarnRule.getServerEnv();
        if (HussarUtils.isEmpty((Object)env)) {
            logWarnRule.setServerEnv("default");
        }
        if (flag = this.saveOrUpdate((BaseEntity)logWarnRule)) {
            this.cacheClient.del("hussarLog:warnRule");
        }
        return flag;
    }

    @Override
    public boolean deleteWarnRule(Long ruleId) {
        if (HussarUtils.isEmpty((Object)ruleId)) {
            throw new HussarException(MultiLangUtil.getTranslateName((String)"log::rule.id.to.delete.cannot.be.empty"));
        }
        boolean flag = this.removeById(ruleId);
        if (flag) {
            this.cacheClient.del("hussarLog:warnRule");
        }
        return flag;
    }

    @Override
    public Page<LogWarnRule> getWarnRulePage(Page<LogWarnRule> page, LogWarnRule logWarnRule) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (HussarUtils.isEmpty((Object)((Object)logWarnRule))) {
            return (Page)this.page((IPage)page);
        }
        String serverName = logWarnRule.getServerName();
        String ruleName = logWarnRule.getRuleName();
        if (HussarUtils.isNotEmpty((Object)serverName)) {
            wrapper.like(LogWarnRule::getServerName, (Object)serverName);
        }
        if (HussarUtils.isNotEmpty((Object)ruleName)) {
            wrapper.like(LogWarnRule::getRuleName, (Object)ruleName);
        }
        wrapper.eq(HussarTenantEntity::getTenantCode, (Object)this.getCurrentTenantCode());
        wrapper.orderByDesc(HussarBaseEntity::getCreateTime);
        return (Page)this.page((IPage)page, (Wrapper)wrapper);
    }

    private String getCurrentTenantCode() {
        UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
        String tenantCode = HussarUtils.isNotEmpty((Object)userDetails) && HussarUtils.isNotEmpty((Object)userDetails.getTenantCode()) ? userDetails.getTenantCode() : "0";
        return tenantCode;
    }
}

