/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.support.log.InitConfig;
import com.jxdinfo.hussar.support.log.client.http.SkipHostnameVerifier;
import com.jxdinfo.hussar.support.log.client.http.SkipSslVerificationHttpRequestFactory;
import com.jxdinfo.hussar.support.log.core.util.ThreadPoolUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ElasticLowerClient {
    private static ElasticLowerClient instance;
    private static ThreadPoolExecutor threadPoolExecutor;
    private final Logger logger = LoggerFactory.getLogger(ElasticLowerClient.class);
    private RestClient client;

    public ElasticLowerClient(String hosts, String userName, String passWord, boolean trustSelfSigned, boolean hostnameVerification, RestClientBuilder.RequestConfigCallback requestConfigCallback) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(userName, passWord));
        String[] hostsAndPorts = hosts.split(",");
        HttpHost[] httpHosts = new HttpHost[hostsAndPorts.length];
        for (int i = 0; i < hostsAndPorts.length; ++i) {
            String hostAndPort = hostsAndPorts[i].trim();
            if (StringUtils.isEmpty((Object)hostAndPort)) continue;
            if (trustSelfSigned) {
                String[] hostAndPorts = hostAndPort.split(":");
                String host = hostAndPorts[0];
                int port = hostAndPorts.length == 1 ? 9200 : Integer.parseInt(hostAndPorts[1]);
                httpHosts[i] = new HttpHost(host, port, "https");
                continue;
            }
            httpHosts[i] = HttpHost.create((String)hostAndPort);
        }
        this.client = RestClient.builder((HttpHost[])httpHosts).setRequestConfigCallback(requestConfigCallback).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider, trustSelfSigned, hostnameVerification){
            final /* synthetic */ CredentialsProvider val$credentialsProvider;
            final /* synthetic */ boolean val$trustSelfSigned;
            final /* synthetic */ boolean val$hostnameVerification;
            {
                this.val$credentialsProvider = credentialsProvider;
                this.val$trustSelfSigned = bl;
                this.val$hostnameVerification = bl2;
            }

            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                httpClientBuilder.disableAuthCaching();
                httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                if (this.val$trustSelfSigned && !this.val$hostnameVerification) {
                    httpClientBuilder.setSSLContext(SkipSslVerificationHttpRequestFactory.getSSLContext());
                    httpClientBuilder.setSSLHostnameVerifier((HostnameVerifier)new SkipHostnameVerifier());
                } else if (this.val$trustSelfSigned) {
                    httpClientBuilder.setSSLContext(SkipSslVerificationHttpRequestFactory.getSSLContext());
                }
                return httpClientBuilder;
            }
        }).build();
    }

    public ElasticLowerClient(String hosts, String keyStorePass, String sslFile, String keyStoreName) {
        try {
            Path keyStorePath = Paths.get(sslFile, new String[0]);
            KeyStore truststore = KeyStore.getInstance(keyStoreName);
            try (InputStream is = Files.newInputStream(keyStorePath, new OpenOption[0]);){
                truststore.load(is, keyStorePass.toCharArray());
            }
            SSLContextBuilder sslBuilder = SSLContexts.custom().loadTrustMaterial(truststore, null);
            final SSLContext sslContext = sslBuilder.build();
            String[] hostsAndPorts = hosts.split(",");
            HttpHost[] httpHosts = new HttpHost[hostsAndPorts.length];
            for (int i = 0; i < hostsAndPorts.length; ++i) {
                String hostAndPort = hostsAndPorts[i].trim();
                if (StringUtils.isEmpty((Object)hostAndPort)) continue;
                httpHosts[i] = HttpHost.create((String)hostAndPort);
            }
            this.client = RestClient.builder((HttpHost[])httpHosts).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

                public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                    httpClientBuilder.disableAuthCaching();
                    return httpClientBuilder.setSSLContext(sslContext);
                }
            }).build();
        }
        catch (Exception e) {
            this.logger.error("ElasticSearch init fail!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ElasticLowerClient getInstance(String hosts, String userName, String passWord, boolean trustSelfSigned, boolean hostnameVerification, RestClientBuilder.RequestConfigCallback requestConfigCallback) {
        if (instance != null) return instance;
        Class<ElasticLowerClient> clazz = ElasticLowerClient.class;
        synchronized (ElasticLowerClient.class) {
            if (instance != null) return instance;
            instance = new ElasticLowerClient(hosts, userName, passWord, trustSelfSigned, hostnameVerification, requestConfigCallback);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return instance;
        }
    }

    public boolean existIndice(String indice) {
        try {
            Request request = new Request("HEAD", "/" + indice + "");
            Response res = this.client.performRequest(request);
            if (res.getStatusLine().getStatusCode() == 200) {
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
        }
        return false;
    }

    public String getVersion() {
        try {
            Request request = new Request("GET", "/");
            Response res = this.client.performRequest(request);
            if (res.getStatusLine().getStatusCode() == 200) {
                String jsonStr = EntityUtils.toString((HttpEntity)res.getEntity(), (String)"utf-8");
                JSONObject jsonObject = JSON.parseObject((String)jsonStr);
                return JSON.parseObject((String)jsonObject.getString("version")).getString("number");
            }
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
        }
        return null;
    }

    public boolean creatIndice(String indice) {
        try {
            Request request = new Request("PUT", "/" + indice + "");
            String properties = "\"properties\":{\"appName\":{\"type\":\"keyword\"},\"env\":{\"type\":\"keyword\"},\"appNameWithEnv\":{\"type\":\"keyword\"},\"className\":{\"type\":\"keyword\"},\"clientIp\":{\"type\":\"text\",\"fields\":{\"keyword\":{\"type\":\"keyword\",\"ignore_above\":256}}},\"content\":{\"type\":\"keyword\"},\"dateTime\":{\"type\":\"text\",\"fields\":{\"keyword\":{\"type\":\"keyword\",\"ignore_above\":256}}},\"logLevel\":{\"type\":\"keyword\"},\"serverName\":{\"type\":\"keyword\"},\"tenantCode\":{\"type\":\"keyword\"},\"traceId\":{\"type\":\"keyword\"},\"dtTime\":{\"type\":\"date\",\"format\":\"strict_date_optional_time||epoch_millis\"},\"method\":{\"type\":\"text\",\"fields\":{\"keyword\":{\"type\":\"keyword\",\"ignore_above\":256}}},\"threadName\":{\"type\":\"text\",\"fields\":{\"keyword\":{\"type\":\"keyword\",\"ignore_above\":256}}},\"seq\":{\"type\":\"long\"}}";
            String ent = "{\"settings\":{\"number_of_shards\":" + InitConfig.ES_INDEX_SHARDS + ",\"number_of_replicas\":" + InitConfig.ES_INDEX_REPLICAS + ",\"refresh_interval\":\"" + InitConfig.ES_REFRESH_INTERVAL + "\",\"max_result_window\":" + InitConfig.MAX_RESULT + "}";
            ent = ent + ",\"mappings\":{" + properties + "}}";
            request.setJsonEntity(ent);
            Response res = this.client.performRequest(request);
            if (res.getStatusLine().getStatusCode() == 200) {
                this.logger.info("creat indice {}", (Object)indice);
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
        }
        return false;
    }

    public boolean creatIndiceTrace(String indice) {
        try {
            Request request = new Request("PUT", "/" + indice + "");
            String properties = "\"properties\":{\"appName\":{\"type\":\"keyword\"},\"appNameWithEnv\":{\"type\":\"keyword\"},\"clientIp\":{\"type\":\"text\",\"fields\":{\"keyword\":{\"type\":\"keyword\",\"ignore_above\":256}}},\"env\":{\"type\":\"keyword\"},\"method\":{\"type\":\"text\",\"fields\":{\"keyword\":{\"type\":\"keyword\",\"ignore_above\":256}}},\"position\":{\"type\":\"text\",\"fields\":{\"keyword\":{\"type\":\"keyword\",\"ignore_above\":256}}},\"positionNum\":{\"type\":\"long\"},\"serverName\":{\"type\":\"text\",\"fields\":{\"keyword\":{\"type\":\"keyword\",\"ignore_above\":256}}},\"time\":{\"type\":\"long\"},\"tenantCode\":{\"type\":\"keyword\"},\"traceId\":{\"type\":\"keyword\"}}";
            String ent = "{\"settings\":{\"number_of_shards\":" + InitConfig.ES_INDEX_SHARDS + ",\"number_of_replicas\":" + InitConfig.ES_INDEX_REPLICAS + ",\"refresh_interval\":\"" + InitConfig.ES_REFRESH_INTERVAL + "\"}";
            ent = ent + ",\"mappings\":{" + properties + "}}";
            request.setJsonEntity(ent);
            Response res = this.client.performRequest(request);
            if (res.getStatusLine().getStatusCode() == 200) {
                this.logger.info("creat indice {}", (Object)indice);
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
        }
        return false;
    }

    public boolean creatIndiceNomal(String indice) {
        try {
            Request request = new Request("PUT", "/" + indice + "");
            String ent = "{\"settings\":{\"number_of_shards\":5,\"number_of_replicas\":0,\"refresh_interval\":\"10s\"}}";
            request.setJsonEntity(ent);
            Response res = this.client.performRequest(request);
            if (res.getStatusLine().getStatusCode() == 200) {
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
        }
        return false;
    }

    public void insertListLog(List<String> list, String baseIndex) throws IOException {
        if (!this.existIndice(baseIndex)) {
            if (baseIndex.startsWith("hs_log_")) {
                this.creatIndice(baseIndex);
            } else {
                this.creatIndiceNomal(baseIndex);
            }
            this.logger.info("creatIndex:{}", (Object)baseIndex);
        }
        this.insertListV1(list, baseIndex);
    }

    public void insertListTrace(List<String> list, String baseIndex) throws IOException {
        this.insertListV1(list, baseIndex);
    }

    public void insertListComm(List<String> list, String baseIndex) throws IOException {
        this.insertListV1(list, baseIndex);
    }

    private void insertList(List<String> list, String baseIndex) throws IOException {
        StringBuffer sendStr = new StringBuffer();
        int size = list.size();
        for (int a = 0; a < size; ++a) {
            String map = list.get(a);
            String ent = "{\"index\":{}}";
            sendStr.append(ent);
            sendStr.append("\r\n");
            sendStr.append(map);
            sendStr.append("\r\n");
        }
        String endpoint = "/" + baseIndex + "/_bulk";
        final Request request = new Request("PUT", endpoint);
        request.setJsonEntity(sendStr.toString());
        this.client.performRequestAsync(request, new ResponseListener(){

            public void onSuccess(Response response) {
                request.setEntity(null);
                try {
                    if (response.getStatusLine().getStatusCode() == 200) {
                        ElasticLowerClient.this.logger.info("ElasticSearch commit! success");
                    } else {
                        String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
                        ElasticLowerClient.this.logger.error("ElasticSearch commit Failure! {}", (Object)responseStr);
                    }
                }
                catch (IOException e) {
                    ElasticLowerClient.this.logger.error("ElasticSearch commit Failure!", (Throwable)e);
                }
            }

            public void onFailure(Exception e) {
                ElasticLowerClient.this.logger.error("ElasticSearch commit Failure!", (Throwable)e);
            }
        });
    }

    private void insertListV1(List<String> list, String baseIndex) throws IOException {
        StringBuffer sendStr = new StringBuffer();
        int size = list.size();
        for (int a = 0; a < size; ++a) {
            String map = list.get(a);
            String ent = "{\"index\":{}}";
            sendStr.append(ent);
            sendStr.append("\r\n");
            sendStr.append(map);
            sendStr.append("\r\n");
        }
        String endpoint = "/" + baseIndex + "/_bulk";
        Request request = new Request("PUT", endpoint);
        request.setJsonEntity(sendStr.toString());
        Request requestStr = request;
        threadPoolExecutor.execute(() -> {
            try {
                long startTime = System.currentTimeMillis();
                Response response = this.client.performRequest(requestStr);
                long endTime = System.currentTimeMillis();
                requestStr.setEntity(null);
                if (response.getStatusLine().getStatusCode() == 200) {
                    this.logger.debug("ElasticSearch commit! success,\u65e5\u5fd7\u63d0\u4ea4ES\u8017\u65f6\uff1a{}", (Object)(endTime - startTime));
                } else {
                    String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
                    this.logger.error("ElasticSearch commit Failure! {},\u65e5\u5fd7\u63d0\u4ea4ES\u8017\u65f6\uff1a{}", (Object)responseStr, (Object)(endTime - startTime));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public String cat(String index) {
        String reStr = "";
        Request request = new Request("GET", "/_cat/indices/" + index + "?v");
        try {
            String str;
            Response res = this.client.performRequest(request);
            InputStream inputStream = res.getEntity().getContent();
            byte[] bytes = new byte[]{};
            bytes = new byte[inputStream.available()];
            inputStream.read(bytes);
            reStr = str = new String(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            reStr = "";
        }
        return reStr;
    }

    public String get(String url, String queryStr) throws Exception {
        StringEntity stringEntity = new StringEntity(queryStr, "utf-8");
        stringEntity.setContentType("application/json");
        Request request = new Request("GET", url);
        request.setEntity((HttpEntity)stringEntity);
        Response res = this.client.performRequest(request);
        return EntityUtils.toString((HttpEntity)res.getEntity(), (String)"utf-8");
    }

    public List<String> getExistIndices(String[] indices) {
        ArrayList<String> existIndexList = new ArrayList<String>();
        for (String index : indices) {
            try {
                Request request = new Request("HEAD", "/" + index + "");
                Response res = this.client.performRequest(request);
                if (res.getStatusLine().getStatusCode() != 200) continue;
                existIndexList.add(index);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return existIndexList;
    }

    public boolean deleteIndex(String index) {
        try {
            Request request = new Request("DELETE", "/" + index + "");
            Response res = this.client.performRequest(request);
            if (res.getStatusLine().getStatusCode() == 200) {
                return true;
            }
        }
        catch (ResponseException e) {
            if (e.getResponse().getStatusLine().getStatusCode() != 404) {
                e.printStackTrace();
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public void close() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            this.logger.error("", (Throwable)e);
        }
    }

    static {
        threadPoolExecutor = ThreadPoolUtil.getPool((int)5, (int)5, (int)100);
    }
}

