/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.logback.appender;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import com.jxdinfo.hussar.support.log.core.AbstractClient;
import com.jxdinfo.hussar.support.log.core.MessageAppenderFactory;
import com.jxdinfo.hussar.support.log.core.constant.LogMessageConstant;
import com.jxdinfo.hussar.support.log.core.dto.BaseLogMessage;
import com.jxdinfo.hussar.support.log.core.dto.RunLogMessage;
import com.jxdinfo.hussar.support.log.core.mq.MqClient;
import com.jxdinfo.hussar.support.log.core.util.GfJsonUtil;
import com.jxdinfo.hussar.support.log.core.util.ThreadPoolUtil;
import com.jxdinfo.hussar.support.log.logback.util.LogMessageUtil;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.StringUtils;

public class MqAppender
extends AppenderBase<ILoggingEvent> {
    private static final String[] IGNORE_PACKAGES = new String[]{"io.lettuce.", "redis.clients.jedis.", "com.jxdinfo.hussar.support.mq."};
    private static final ThreadPoolExecutor threadPoolExecutor = ThreadPoolUtil.getPool();
    private MqClient mqClient;
    private String appName;
    private String env = "default";
    private String runModel;
    private String expand;
    private int maxCount = 100;
    private int logQueueSize = 10000;
    private int threadPoolSize = 1;

    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getRunModel() {
        return this.runModel;
    }

    public void setRunModel(String runModel) {
        this.runModel = runModel;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public int getLogQueueSize() {
        return this.logQueueSize;
    }

    public void setLogQueueSize(int logQueueSize) {
        this.logQueueSize = logQueueSize;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    protected void append(ILoggingEvent event) {
        if (event == null || this.shouldIgnore(event)) {
            return;
        }
        this.send(event);
    }

    protected void send(ILoggingEvent event) {
        BaseLogMessage logMessage = LogMessageUtil.getLogMessage(this.appName, this.env, event);
        if (logMessage instanceof RunLogMessage) {
            String message = LogMessageUtil.getLogMessage(logMessage, event);
            MessageAppenderFactory.pushRundataQueue((String)message);
        } else {
            MessageAppenderFactory.pushTracedataQueue((String)GfJsonUtil.toJSONString((Object)logMessage));
        }
    }

    private boolean shouldIgnore(ILoggingEvent event) {
        if (event.getLevel().toInt() <= Level.DEBUG.toInt()) {
            String name = event.getLoggerName();
            return StringUtils.startsWithAny((CharSequence)name, (CharSequence[])IGNORE_PACKAGES);
        }
        return false;
    }

    public void start() {
        int a;
        super.start();
        if (this.runModel != null) {
            LogMessageConstant.RUN_MODEL = Integer.parseInt(this.runModel);
        }
        if (this.mqClient == null) {
            this.mqClient = MqClient.getInstance();
        }
        if (this.expand != null && LogMessageConstant.EXPANDS.contains(this.expand)) {
            LogMessageConstant.EXPAND = this.expand;
        }
        MessageAppenderFactory.initQueue((int)this.logQueueSize);
        for (a = 0; a < this.threadPoolSize; ++a) {
            threadPoolExecutor.execute(() -> MessageAppenderFactory.startRunLog((AbstractClient)this.mqClient, (int)this.maxCount));
        }
        for (a = 0; a < this.threadPoolSize; ++a) {
            threadPoolExecutor.execute(() -> MessageAppenderFactory.startTraceLog((AbstractClient)this.mqClient, (int)this.maxCount));
        }
    }
}

