/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.log4j2.appender;

import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.log.core.AbstractClient;
import com.jxdinfo.hussar.support.log.core.MessageAppenderFactory;
import com.jxdinfo.hussar.support.log.core.cache.CacheClient;
import com.jxdinfo.hussar.support.log.core.constant.LogMessageConstant;
import com.jxdinfo.hussar.support.log.core.dto.BaseLogMessage;
import com.jxdinfo.hussar.support.log.core.dto.RunLogMessage;
import com.jxdinfo.hussar.support.log.core.util.GfJsonUtil;
import com.jxdinfo.hussar.support.log.core.util.ThreadPoolUtil;
import com.jxdinfo.hussar.support.log.log4j2.util.LogMessageUtil;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="CacheAppender", category="Core", elementType="appender", printObject=true)
public class CacheAppender
extends AbstractAppender {
    private static AbstractClient cacheClient;
    private static final ThreadPoolExecutor threadPoolExecutor;
    private final String appName;
    private final String env;
    private final String expand;
    private final String runModel;
    private int maxCount = 500;
    private int logQueueSize = 10000;
    private int threadPoolSize = 5;
    private boolean compressor = false;
    private boolean isInitQueue = false;

    protected CacheAppender(String name, String appName, String env, String runModel, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, String expand, int maxCount, int logQueueSize, int threadPoolSize, boolean compressor) {
        super(name, filter, layout, ignoreExceptions);
        this.appName = appName;
        this.env = env;
        this.runModel = runModel;
        this.expand = expand;
        this.maxCount = maxCount;
        this.logQueueSize = logQueueSize;
        this.threadPoolSize = threadPoolSize;
        this.compressor = compressor;
    }

    @PluginFactory
    public static CacheAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="appName") String appName, @PluginAttribute(value="env") String env, @PluginAttribute(value="maxCount") int maxCount, @PluginAttribute(value="runModel") String runModel, @PluginAttribute(value="expand") String expand, @PluginAttribute(value="logQueueSize") int logQueueSize, @PluginAttribute(value="threadPoolSize") int threadPoolSize, @PluginAttribute(value="compressor") boolean compressor, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter) {
        if (env == null) {
            env = "default";
        }
        if (runModel != null) {
            LogMessageConstant.RUN_MODEL = Integer.parseInt(runModel);
        }
        if (expand != null && LogMessageConstant.EXPANDS.contains(expand)) {
            LogMessageConstant.EXPAND = expand;
        }
        cacheClient = new CacheClient();
        if (maxCount == 0) {
            maxCount = 100;
        }
        if (logQueueSize == 0) {
            logQueueSize = 10000;
        }
        if (threadPoolSize == 0) {
            threadPoolSize = 1;
        }
        return new CacheAppender(name, appName, env, runModel, filter, layout, true, expand, maxCount, logQueueSize, threadPoolSize, compressor);
    }

    public void append(LogEvent logEvent) {
        boolean enableHussarLog = Optional.ofNullable(SpringContextUtil.getEnvironment()).map(env -> (Boolean)env.getProperty("hussar.log.enable", Boolean.class)).orElse(false);
        if (enableHussarLog) {
            if (!this.isInitQueue) {
                this.initQueue();
                this.isInitQueue = true;
            }
            this.send(logEvent);
        }
    }

    private void initQueue() {
        int count = this.maxCount;
        MessageAppenderFactory.initQueue((int)this.logQueueSize);
        for (int a = 0; a < this.threadPoolSize; ++a) {
            threadPoolExecutor.execute(() -> MessageAppenderFactory.startRunLog((AbstractClient)cacheClient, (int)count, (String)(this.compressor ? "hussar_log_list_compress" : "hussar_log_list"), (boolean)this.compressor));
            threadPoolExecutor.execute(() -> MessageAppenderFactory.startTraceLog((AbstractClient)cacheClient, (int)count, (String)(this.compressor ? "hussar_log_trace_list_compress" : "hussar_log_trace_list"), (boolean)this.compressor));
        }
    }

    protected void send(LogEvent logEvent) {
        BaseLogMessage logMessage = LogMessageUtil.getLogMessage(this.appName, this.env, logEvent);
        if (logMessage == null) {
            return;
        }
        if (logMessage instanceof RunLogMessage) {
            String message = LogMessageUtil.getLogMessage(logMessage, logEvent);
            MessageAppenderFactory.pushRundataQueue((String)message);
        } else {
            MessageAppenderFactory.pushTracedataQueue((String)GfJsonUtil.toJSONString((Object)logMessage));
        }
    }

    public String getAppName() {
        return this.appName;
    }

    public String getRunModel() {
        return this.runModel;
    }

    public String getExpand() {
        return this.expand;
    }

    public String getEnv() {
        return this.env;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public int getLogQueueSize() {
        return this.logQueueSize;
    }

    public boolean isCompressor() {
        return this.compressor;
    }

    static {
        threadPoolExecutor = ThreadPoolUtil.getPool();
    }
}

