/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.log4j2.util;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.platform.core.utils.DataSize;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.apache.logging.log4j.core.appender.rolling.CompositeTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.CronTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;

public class TriggeringPolicyCloneUtil {
    public static TriggeringPolicy clone(TriggeringPolicy original, Configuration config) {
        if (HussarUtils.isEmpty((Object)original)) {
            return original;
        }
        for (TriggeringPolicyEnum policyType : TriggeringPolicyEnum.values()) {
            if (!original.getClass().equals(policyType.type)) continue;
            return (TriggeringPolicy)policyType.function.apply(original, config);
        }
        System.out.println("TriggeringPolicy is UnsupportedOperation " + original.getClass());
        return original;
    }

    private static TriggeringPolicy cloneTimeBasedPolicy(TriggeringPolicy source, Configuration config) {
        try {
            Map<String, Object> objectMap = TriggeringPolicyCloneUtil.object2Map(source);
            Long maxRandomDelayMillis = (Long)objectMap.get("maxRandomDelayMillis");
            Long second = TimeUnit.MILLISECONDS.toSeconds(maxRandomDelayMillis);
            return TimeBasedTriggeringPolicy.newBuilder().withInterval(((TimeBasedTriggeringPolicy)source).getInterval()).withModulate(((Boolean)objectMap.get("modulate")).booleanValue()).withMaxRandomDelay(second.intValue()).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return source;
        }
    }

    private static TriggeringPolicy cloneSizeBasedPolicy(TriggeringPolicy original, Configuration config) {
        try {
            SizeBasedTriggeringPolicy source = (SizeBasedTriggeringPolicy)original;
            long maxFileSize = source.getMaxFileSize();
            String size = DataSize.ofBytes((long)maxFileSize).toString();
            return SizeBasedTriggeringPolicy.createPolicy((String)size);
        }
        catch (Exception e) {
            return original;
        }
    }

    private static TriggeringPolicy cloneCronPolicy(TriggeringPolicy source, Configuration config) {
        try {
            Map<String, Object> objectMap = TriggeringPolicyCloneUtil.object2Map(source);
            return CronTriggeringPolicy.createPolicy((Configuration)config, (String)String.valueOf(objectMap.get("evaluateOnStartup")), (String)((CronTriggeringPolicy)source).getCronExpression().getCronExpression());
        }
        catch (Exception e) {
            return source;
        }
    }

    private static TriggeringPolicy cloneCompositePolicy(TriggeringPolicy source, Configuration config) {
        try {
            CompositeTriggeringPolicy original = (CompositeTriggeringPolicy)source;
            TriggeringPolicy[] triggeringPolicies = original.getTriggeringPolicies();
            ArrayList triggeringPolicyList = Lists.newArrayListWithExpectedSize((int)triggeringPolicies.length);
            for (int i = 0; i < triggeringPolicies.length; ++i) {
                triggeringPolicyList.add(TriggeringPolicyCloneUtil.clone(triggeringPolicies[i], config));
            }
            return CompositeTriggeringPolicy.createPolicy((TriggeringPolicy[])triggeringPolicyList.toArray(new TriggeringPolicy[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            return source;
        }
    }

    public static <T> Map<String, Object> object2Map(T source) throws IllegalAccessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field declaredField : source.getClass().getDeclaredFields()) {
            declaredField.setAccessible(true);
            map.put(declaredField.getName(), declaredField.get(source));
        }
        return map;
    }

    static enum TriggeringPolicyEnum {
        TIME_BASED_TRIGGERING_POLICY(TimeBasedTriggeringPolicy.class, (x$0, x$1) -> TriggeringPolicyCloneUtil.access$300(x$0, x$1)),
        SIZE_BASED_TRIGGERING_POLICY(SizeBasedTriggeringPolicy.class, (x$0, x$1) -> TriggeringPolicyCloneUtil.access$200(x$0, x$1)),
        CRON_TRIGGERING_POLICY(CronTriggeringPolicy.class, (x$0, x$1) -> TriggeringPolicyCloneUtil.access$100(x$0, x$1)),
        COMPOSITE_TRIGGERING_POLICY(CompositeTriggeringPolicy.class, (x$0, x$1) -> TriggeringPolicyCloneUtil.access$000(x$0, x$1));

        private final Class<? extends TriggeringPolicy> type;
        private final BiFunction<TriggeringPolicy, Configuration, TriggeringPolicy> function;

        private TriggeringPolicyEnum(Class<? extends TriggeringPolicy> type, BiFunction<TriggeringPolicy, Configuration, TriggeringPolicy> function) {
            this.type = type;
            this.function = function;
        }
    }
}

