/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.log.log4j.appender;

import com.jxdinfo.hussar.support.log.core.AbstractClient;
import com.jxdinfo.hussar.support.log.core.MessageAppenderFactory;
import com.jxdinfo.hussar.support.log.core.cache.CacheClient;
import com.jxdinfo.hussar.support.log.core.constant.LogMessageConstant;
import com.jxdinfo.hussar.support.log.core.dto.BaseLogMessage;
import com.jxdinfo.hussar.support.log.core.dto.RunLogMessage;
import com.jxdinfo.hussar.support.log.core.util.GfJsonUtil;
import com.jxdinfo.hussar.support.log.core.util.ThreadPoolUtil;
import com.jxdinfo.hussar.support.log.log4j.util.LogMessageUtil;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class CacheAppender
extends AppenderSkeleton {
    private static AbstractClient cacheClient;
    private static final ThreadPoolExecutor threadPoolExecutor;
    private String appName;
    private String env;
    private String expand;
    private String runModel;
    private int maxCount = 500;
    private int logQueueSize = 10000;
    private int threadPoolSize = 5;
    private final boolean compressor = false;

    protected void append(LoggingEvent loggingEvent) {
        if (this.env == null) {
            this.env = "default";
        }
        if (this.runModel != null) {
            LogMessageConstant.RUN_MODEL = Integer.parseInt(this.runModel);
        }
        if (this.expand != null && LogMessageConstant.EXPANDS.contains(this.expand)) {
            LogMessageConstant.EXPAND = this.expand;
        }
        cacheClient = new CacheClient();
        if (this.maxCount == 0) {
            this.maxCount = 100;
        }
        if (this.logQueueSize == 0) {
            this.logQueueSize = 10000;
        }
        if (this.threadPoolSize == 0) {
            this.threadPoolSize = 1;
        }
        int count = this.maxCount;
        MessageAppenderFactory.initQueue((int)this.logQueueSize);
        for (int a = 0; a < this.threadPoolSize; ++a) {
            threadPoolExecutor.execute(() -> MessageAppenderFactory.startRunLog((AbstractClient)cacheClient, (int)count, (String)"hussar_log_list", (boolean)false));
            threadPoolExecutor.execute(() -> MessageAppenderFactory.startTraceLog((AbstractClient)cacheClient, (int)count, (String)"hussar_log_trace_list", (boolean)false));
        }
        BaseLogMessage logMessage = LogMessageUtil.getLogMessage(this.appName, this.env, loggingEvent);
        if (logMessage instanceof RunLogMessage) {
            String message = LogMessageUtil.getLogMessage(logMessage, loggingEvent);
            MessageAppenderFactory.pushRundataQueue((String)message);
        } else {
            MessageAppenderFactory.pushTracedataQueue((String)GfJsonUtil.toJSONString((Object)logMessage));
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    static {
        threadPoolExecutor = ThreadPoolUtil.getPool();
    }
}

