/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.jsonschema.plugin.data;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.convert.HussarConverter;
import com.jxdinfo.hussar.support.jsonschema.plugin.data.JsonGeneratorException;
import com.jxdinfo.hussar.support.jsonschema.plugin.validator.exception.MissingPathException;
import com.jxdinfo.hussar.support.jsonschema.plugin.validator.exception.ValidationException;
import com.jxdinfo.hussar.support.jsonschema.plugin.validator.support.struct.Schema;
import com.jxdinfo.hussar.support.jsonschema.plugin.validator.support.struct.TypeInferrer;
import com.jxdinfo.hussar.support.jsonschema.plugin.validator.support.validate.CombinedSchema;
import com.jxdinfo.hussar.support.jsonschema.plugin.validator.support.validate.Validator;
import com.jxdinfo.hussar.support.jsonschema.plugin.validator.utils.PathUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Generator {
    private static final Logger logger = LoggerFactory.getLogger(Generator.class);
    private static final String CONVERSION_KEY = "mapping";
    private static final String CONVERSION = "conversion";
    private static final String ROOT_PATH = "#";
    private static final String ROOT_PATH_EXPRESS = "$root";
    private static final String ARRAY_ITEM_EXPRESS = "$item";
    private static final String ARRAY_ITEM_INDEX_EXPRESS = "\\[(.?+)]";

    public Object generate(Schema schema, Schema targetSchema, Object document) throws JsonGeneratorException, ValidationException {
        if (Boolean.TRUE.equals(targetSchema.isFalse())) {
            throw new JsonGeneratorException(schema.getUri() + " : nothing can validate against a false schema");
        }
        Object schemaObject = targetSchema.getSchemaObject();
        Boolean conversion = this.getSchemaObjectValue(schemaObject, CONVERSION, Boolean.class);
        if (schema != null) {
            new Validator().validate(schema, document);
        }
        Object object = document;
        if (Boolean.TRUE.equals(conversion)) {
            URI root = URI.create("");
            object = this.generateUnvalidated(targetSchema, document, "", root, new ArrayList<Integer>(), ROOT_PATH);
        }
        return object;
    }

    private <T> T getSchemaObjectValue(Object schemaObject, String key, Class<T> clazz) {
        return (T)HussarConverter.convert(clazz, ((Map)schemaObject).get(key));
    }

    private Object generateUnvalidated(Schema schema, Object document, String mapping, URI uri, List<Integer> itemsValue, String rootpath) {
        Object object;
        Cloneable _const = schema.getConst();
        CombinedSchema combinedSchema = new CombinedSchema(schema);
        String type = this.getType(combinedSchema);
        if (HussarUtils.equals((Object)type, (Object)"array")) {
            boolean loop;
            String arrayMapping = this.packagePropertiesPath(rootpath, mapping);
            if (HussarUtils.isNotEmpty((Object)arrayMapping)) {
                _const = this.getObject(document, arrayMapping, itemsValue);
            }
            Schema items = schema.getItems();
            String itemsMapping = this.getSchemaObjectValue(items.getSchemaObject(), CONVERSION_KEY, String.class);
            boolean bl = loop = HussarUtils.isEmpty((Object)items.getProperties()) && HussarUtils.isEmpty((Object)itemsMapping);
            if (HussarUtils.isNotEmpty((Object)arrayMapping) && !loop) {
                rootpath = arrayMapping;
                ArrayList<Object> jsonArray = new ArrayList<Object>();
                HashMap object2 = _const;
                if (object2 instanceof List && HussarUtils.isNotEmpty(object2)) {
                    List list = (List)((Object)object2);
                    for (int i = 0; i < list.size(); ++i) {
                        URI newUri = PathUtils.append((URI)uri, (String)String.valueOf(i));
                        if (HussarUtils.isEmpty((Object)itemsMapping)) {
                            itemsMapping = ROOT_PATH_EXPRESS;
                        }
                        itemsMapping = this.packagePropertiesPath(rootpath, itemsMapping);
                        List<Integer> newItemsValue = this.getNewItemsValue(itemsValue, i);
                        Object value = this.generateUnvalidated(items, document, itemsMapping, newUri, newItemsValue, rootpath);
                        jsonArray.add(value);
                    }
                }
                _const = jsonArray;
            }
        } else if (HussarUtils.equals((Object)type, (Object)"object")) {
            Map properties = combinedSchema.getProperties();
            HashMap jsonObject = new HashMap();
            mapping = this.packagePropertiesPath(rootpath, mapping);
            if (HussarUtils.isEmpty((Object)properties) && HussarUtils.isNotEmpty((Object)mapping)) {
                return this.getObject(document, mapping, itemsValue);
            }
            for (Map.Entry entry : properties.entrySet()) {
                Schema propertySchema = (Schema)entry.getValue();
                String propertyMapping = this.getSchemaObjectValue(propertySchema.getSchemaObject(), CONVERSION_KEY, String.class);
                Object value = this.generateUnvalidated(propertySchema, document, propertyMapping, PathUtils.append((URI)uri, (String)((String)entry.getKey())), itemsValue, rootpath);
                if (!HussarUtils.isNotEmpty((Object)propertyMapping) && !HussarUtils.isNotEmpty((Object)value)) continue;
                jsonObject.put(entry.getKey(), value);
            }
            _const = jsonObject;
        } else if (HussarUtils.isNotEmpty((Object)mapping) && HussarUtils.isNotEmpty((Object)(object = this.getObject(document, mapping = this.packagePropertiesPath(rootpath, mapping), itemsValue)))) {
            _const = HussarConverter.convert(this.getClassNameByType(type), (Object)object);
        }
        return _const;
    }

    private String replaceItemsValue(String path, List<Integer> items) {
        String newPath = path;
        for (int i = 0; i < items.size(); ++i) {
            Integer value = items.get(i);
            newPath = newPath.replaceFirst("\\$item", String.valueOf(value));
        }
        return newPath;
    }

    private List<Integer> getNewItemsValue(List<Integer> itemsValue, int i) {
        ArrayList<Integer> newItemsValue = new ArrayList<Integer>(itemsValue);
        newItemsValue.add(i);
        return newItemsValue;
    }

    private String formatPathByMapping(String mapping) {
        String mappingPath = mapping;
        if (mapping.startsWith(ROOT_PATH_EXPRESS)) {
            mappingPath = mapping.replace(ROOT_PATH_EXPRESS, "");
        }
        mappingPath = mappingPath.replace(".", "/");
        if (!(mappingPath = mappingPath.replaceAll(ARRAY_ITEM_INDEX_EXPRESS, "/$1")).startsWith("/") && !mappingPath.startsWith(ROOT_PATH)) {
            mappingPath = "/" + mappingPath;
        }
        return mappingPath;
    }

    private String packagePropertiesPath(String rootPath, String mapping) {
        String mappingPath = this.formatPathByMapping(mapping);
        if (mapping.startsWith(ARRAY_ITEM_EXPRESS)) {
            mappingPath = rootPath + mappingPath;
        } else if (!mapping.startsWith(ROOT_PATH)) {
            mappingPath = ROOT_PATH + mappingPath;
        }
        return mappingPath;
    }

    private Class<?> getClassNameByType(String type) {
        if (HussarUtils.equals((Object)type, (Object)"string")) {
            return String.class;
        }
        if (HussarUtils.equals((Object)type, (Object)"number")) {
            return Number.class;
        }
        if (HussarUtils.equals((Object)type, (Object)"integer")) {
            return Integer.class;
        }
        if (HussarUtils.equals((Object)type, (Object)"boolean")) {
            return Boolean.class;
        }
        return null;
    }

    private String getType(CombinedSchema combinedSchema) {
        HashSet inferredTypes = combinedSchema.getInferredTypes();
        HashSet types = inferredTypes.isEmpty() ? TypeInferrer.getNonProhibitedTypes((CombinedSchema)combinedSchema) : inferredTypes;
        if ((types = new HashSet(types)).size() > 1) {
            types.remove("array");
        }
        if (types.size() > 1) {
            types.remove("object");
        }
        if (types.isEmpty()) {
            throw new IllegalStateException("No types");
        }
        return (String)types.iterator().next();
    }

    private Object getObject(Object document, String mapping, List<Integer> itemsValue) {
        String uriPath = HussarUtils.isNotEmpty(itemsValue) ? this.replaceItemsValue(mapping, itemsValue) : mapping;
        try {
            return Validator.getObject((Object)document, (URI)URI.create(uriPath));
        }
        catch (MissingPathException i) {
            return null;
        }
    }

    public Object translation(Schema schema, Object document) {
        Boolean trans = this.getSchemaObjectValue(schema.getSchemaObject(), "trans", Boolean.class);
        if (!Boolean.TRUE.equals(trans)) {
            return document;
        }
        HashMap<URI, Map<String, Object>> cache = new HashMap<URI, Map<String, Object>>();
        this.translationForSimple(schema, document, URI.create(""), cache);
        cache.clear();
        return document;
    }

    private void translationForSimple(Schema schema, Object document, URI uri, Map<URI, Map<String, Object>> cache) {
        block7: {
            Map<String, Object> trans;
            String type;
            CombinedSchema combinedSchema;
            block5: {
                Object object;
                block6: {
                    combinedSchema = new CombinedSchema(schema);
                    type = this.getType(combinedSchema);
                    trans = cache.get(uri);
                    if (!HussarUtils.equals((Object)type, (Object)"array")) break block5;
                    trans = this.getTrans(schema.getItems(), uri, cache, trans);
                    object = this.getObject(document, uri.toString(), null);
                    if (trans == null) break block6;
                    this.dictionaryTranslation(object, trans, true);
                    break block7;
                }
                if (!(object instanceof List) || !HussarUtils.isNotEmpty((Object)object)) break block7;
                Schema items = schema.getItems();
                List list = (List)object;
                for (int i = 0; i < list.size(); ++i) {
                    this.translationForSimple(items, document, PathUtils.append((URI)uri, (String)String.valueOf(i)), cache);
                }
                break block7;
            }
            if (HussarUtils.equals((Object)type, (Object)"object")) {
                if ((trans = this.getTrans(schema, uri, cache, trans)) != null) {
                    Object object = this.getObject(document, uri.toString(), null);
                    this.dictionaryTranslation(object, trans, false);
                } else {
                    Map properties = combinedSchema.getProperties();
                    for (Map.Entry entry : properties.entrySet()) {
                        Schema propertySchema = (Schema)entry.getValue();
                        this.translationForSimple(propertySchema, document, PathUtils.append((URI)uri, (String)((String)entry.getKey())), cache);
                    }
                }
            }
        }
    }

    private Map<String, Object> getTrans(Schema schema, URI uri, Map<URI, Map<String, Object>> cache, Map<String, Object> trans) {
        if (trans == null) {
            HashMap<String, Object> newTrans = new HashMap<String, Object>();
            if (!schema.getProperties().isEmpty()) {
                for (Map.Entry schemaEntry : schema.getProperties().entrySet()) {
                    String key = (String)schemaEntry.getKey();
                    Schema value = (Schema)schemaEntry.getValue();
                    Map propertyTrans = this.getSchemaObjectValue(value.getSchemaObject(), "trans", Map.class);
                    if (propertyTrans == null) continue;
                    newTrans.put(key, propertyTrans);
                }
            }
            if (newTrans.isEmpty()) {
                return null;
            }
            cache.put(uri, newTrans);
            return newTrans;
        }
        return trans;
    }

    private void dictionaryTranslation(Object object, Map<String, Object> trans, boolean isArr) {
        block4: {
            block5: {
                if (!HussarUtils.isNotEmpty(trans) || !HussarUtils.isNotEmpty((Object)object)) break block4;
                if (!isArr || !(object instanceof List)) break block5;
                List list = (List)object;
                for (Object o : list) {
                    this.dictionaryTranslation(o, trans, false);
                }
                break block4;
            }
            if (!(object instanceof Map)) break block4;
            Map map = (Map)object;
            for (Map.Entry<String, Object> entry : trans.entrySet()) {
                String key = entry.getKey();
                Map transValue = (Map)entry.getValue();
                String type = (String)transValue.get("type");
                String namespace = (String)transValue.get("namespace");
                String ref = (String)transValue.get("ref");
                Object value = map.get(key);
                Map<String, Object> dictMap = this.getDictValue(namespace + "_" + value);
                if (HussarUtils.isEmpty(dictMap)) {
                    return;
                }
                String[] refSetting = ref.split(ROOT_PATH);
                if (refSetting.length == 1) {
                    if (dictMap.size() <= 0) continue;
                    map.put(refSetting[0], dictMap.values().iterator().next());
                    continue;
                }
                if (refSetting.length != 2) continue;
                map.put(refSetting[0], dictMap.get(refSetting[1]));
            }
        }
    }

    private Map<String, Object> getDictValue(String s) {
        HashMap cache = new HashMap();
        HashMap<String, String> sysTenant1 = new HashMap<String, String>();
        sysTenant1.put("name", "aa");
        sysTenant1.put("code", "0");
        HashMap<String, String> sysTenant2 = new HashMap<String, String>();
        sysTenant2.put("name", "bb");
        sysTenant2.put("code", "0");
        cache.put("sysTenant_1", sysTenant1);
        cache.put("sysTenant_2", sysTenant2);
        return (Map)cache.get(s);
    }
}

