/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.execution.core.tracker.processor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.support.job.execution.core.tracker.processor.ProcessorTracker;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class ProcessorTrackerPool {
    private static final Map<Long, Map<String, ProcessorTracker>> processorTrackerPool = Maps.newHashMap();

    public static synchronized ProcessorTracker getProcessorTracker(Long instanceId, String address, Supplier<ProcessorTracker> creator) {
        ProcessorTracker processorTracker = (ProcessorTracker)processorTrackerPool.getOrDefault(instanceId, Collections.emptyMap()).get(address);
        if (processorTracker == null) {
            processorTracker = creator.get();
            processorTrackerPool.computeIfAbsent(instanceId, ignore -> Maps.newHashMap()).put(address, processorTracker);
        }
        return processorTracker;
    }

    public static synchronized List<ProcessorTracker> removeProcessorTracker(Long instanceId) {
        LinkedList res = Lists.newLinkedList();
        Map<String, ProcessorTracker> ttAddress2Pt = processorTrackerPool.remove(instanceId);
        if (ttAddress2Pt != null) {
            res.addAll(ttAddress2Pt.values());
            ttAddress2Pt.clear();
        }
        return res;
    }
}

