/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.execution.background;

import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.job.core.enums.LogLevel;
import com.jxdinfo.hussar.support.job.core.model.InstanceLogContent;
import com.jxdinfo.hussar.support.job.core.request.WorkerLogReportReq;
import com.jxdinfo.hussar.support.job.core.service.DispatchReceiveReqService;
import com.jxdinfo.hussar.support.job.execution.background.ServerDiscoveryService;
import com.jxdinfo.hussar.support.job.execution.common.utils.AkkaUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class OmsLogHandler {
    private static final Logger log = LoggerFactory.getLogger(OmsLogHandler.class);
    private final Boolean enableSingleModel;
    private final String workerAddress;
    private final ActorSystem actorSystem;
    private final ServerDiscoveryService serverDiscoveryService;
    public final Runnable logSubmitter = new LogSubmitter();
    private final Lock reportLock = new ReentrantLock();
    private final BlockingQueue<InstanceLogContent> logQueue = Queues.newLinkedBlockingQueue();
    private static final int BATCH_SIZE = 20;
    private static final int REPORT_SIZE = 1024;

    public OmsLogHandler(Boolean enableSingleModel, String workerAddress, ActorSystem actorSystem, ServerDiscoveryService serverDiscoveryService) {
        this.enableSingleModel = enableSingleModel;
        this.workerAddress = workerAddress;
        this.actorSystem = actorSystem;
        this.serverDiscoveryService = serverDiscoveryService;
    }

    public void submitLog(long instanceId, LogLevel logLevel, String logContent) {
        if (this.logQueue.size() > 1024) {
            new Thread(this.logSubmitter).start();
        }
        InstanceLogContent tuple = new InstanceLogContent(instanceId, System.currentTimeMillis(), logLevel.getV(), logContent);
        this.logQueue.offer(tuple);
    }

    private class LogSubmitter
    implements Runnable {
        private LogSubmitter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean lockResult = OmsLogHandler.this.reportLock.tryLock();
            if (!lockResult) {
                return;
            }
            try {
                ActorSelection serverActor = null;
                String serverPath = AkkaUtils.getServerActorPath(OmsLogHandler.this.serverDiscoveryService.getCurrentServerAddress());
                if (StringUtils.isEmpty((Object)serverPath)) {
                    if (!OmsLogHandler.this.logQueue.isEmpty()) {
                        OmsLogHandler.this.logQueue.clear();
                        log.warn("[OmsLogHandler] because there is no available server to report logs which leads to queue accumulation, oms discarded all logs.");
                    }
                    return;
                }
                if (!OmsLogHandler.this.enableSingleModel.booleanValue()) {
                    serverActor = OmsLogHandler.this.actorSystem.actorSelection(serverPath);
                }
                LinkedList logs = Lists.newLinkedList();
                while (!OmsLogHandler.this.logQueue.isEmpty()) {
                    try {
                        InstanceLogContent logContent = (InstanceLogContent)OmsLogHandler.this.logQueue.poll(100L, TimeUnit.MILLISECONDS);
                        logs.add(logContent);
                        if (logs.size() < 20) continue;
                        WorkerLogReportReq req = new WorkerLogReportReq(OmsLogHandler.this.workerAddress, (List)Lists.newLinkedList((Iterable)logs));
                        if (OmsLogHandler.this.enableSingleModel.booleanValue()) {
                            ((DispatchReceiveReqService)SpringContextUtil.getBean(DispatchReceiveReqService.class)).onReceiveWorkerLogReportReq(req);
                        } else {
                            serverActor.tell((Object)req, null);
                        }
                        logs.clear();
                    }
                    catch (Exception ignore) {
                        // empty catch block
                        break;
                    }
                }
                if (!logs.isEmpty()) {
                    WorkerLogReportReq req = new WorkerLogReportReq(OmsLogHandler.this.workerAddress, (List)logs);
                    serverActor.tell((Object)req, null);
                }
            }
            finally {
                OmsLogHandler.this.reportLock.unlock();
            }
        }
    }
}

