/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.execution.container;

import com.google.common.collect.Maps;
import com.jxdinfo.hussar.support.job.core.exception.JobRuntimeException;
import com.jxdinfo.hussar.support.job.execution.container.JobExecutionClassLoader;
import com.jxdinfo.hussar.support.job.execution.container.OmsContainer;
import com.jxdinfo.hussar.support.job.execution.container.OmsContainerFactory;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.util.StringUtils;

public class OmsJarContainer
implements OmsContainer {
    private static final Logger log = LoggerFactory.getLogger(OmsJarContainer.class);
    private final Long containerId;
    private final String name;
    private final String version;
    private final File localJarFile;
    private final Long deployedTime;
    private final AtomicInteger referenceCount = new AtomicInteger(0);
    private JobExecutionClassLoader containerClassLoader;
    private ClassPathXmlApplicationContext container;
    private final Map<String, BasicProcessor> processorCache = Maps.newConcurrentMap();

    public OmsJarContainer(Long containerId, String name, String version, File localJarFile) {
        this.containerId = containerId;
        this.name = name;
        this.version = version;
        this.localJarFile = localJarFile;
        this.deployedTime = System.currentTimeMillis();
    }

    @Override
    public BasicProcessor getProcessor(String className) {
        BasicProcessor basicProcessor = this.processorCache.computeIfAbsent(className, ignore -> {
            Class<?> targetClass;
            try {
                targetClass = this.containerClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException cnf) {
                log.error("[OmsJarContainer-{}] can't find class: {} in container.", (Object)this.containerId, (Object)className);
                return null;
            }
            try {
                return (BasicProcessor)this.container.getBean(targetClass);
            }
            catch (BeansException be) {
                log.warn("[OmsJarContainer-{}] load instance from spring container failed, try to build instance directly.", (Object)this.containerId);
            }
            catch (ClassCastException cce) {
                log.error("[OmsJarContainer-{}] {} should implements the Processor interface!", (Object)this.containerId, (Object)className);
                return null;
            }
            catch (Exception e) {
                log.error("[OmsJarContainer-{}] get bean failed for {}.", new Object[]{this.containerId, className, e});
                return null;
            }
            try {
                Object obj = targetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return (BasicProcessor)obj;
            }
            catch (Exception e) {
                log.error("[OmsJarContainer-{}] load {} failed", new Object[]{this.containerId, className, e});
                return null;
            }
        });
        if (basicProcessor != null) {
            this.referenceCount.getAndIncrement();
        }
        return basicProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws Exception {
        log.info("[OmsJarContainer-{}] start to init container(name={},jarPath={})", new Object[]{this.containerId, this.name, this.localJarFile.getPath()});
        URL jarURL = this.localJarFile.toURI().toURL();
        this.containerClassLoader = new JobExecutionClassLoader(new URL[]{jarURL}, this.getClass().getClassLoader());
        Properties properties = new Properties();
        try (InputStream propertiesURLStream = this.containerClassLoader.getResourceAsStream("oms-worker-container.properties");){
            if (propertiesURLStream == null) {
                log.error("[OmsJarContainer-{}] can't find {} in jar {}.", new Object[]{this.containerId, "oms-worker-container.properties", this.localJarFile.getPath()});
                throw new JobRuntimeException("invalid jar file because of no oms-worker-container.properties");
            }
            properties.load(propertiesURLStream);
            log.info("[OmsJarContainer-{}] load container properties successfully: {}", (Object)this.containerId, (Object)properties);
        }
        String packageName = properties.getProperty("PACKAGE_NAME");
        if (StringUtils.isEmpty((Object)packageName)) {
            log.error("[OmsJarContainer-{}] get package name failed, developer should't modify the properties file!", (Object)this.containerId);
            throw new JobRuntimeException("invalid jar file");
        }
        this.containerClassLoader.load(packageName);
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.containerClassLoader);
        try {
            this.container = new ClassPathXmlApplicationContext(new String[]{"oms-worker-container-spring-context.xml"}, false);
            this.container.setClassLoader((ClassLoader)this.containerClassLoader);
            this.container.refresh();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
        log.info("[OmsJarContainer-{}] init container(name={},jarPath={}) successfully", new Object[]{this.containerId, this.name, this.localJarFile.getPath()});
    }

    @Override
    public void destroy() throws Exception {
        if (this.referenceCount.get() <= 0) {
            try {
                if (this.localJarFile.exists()) {
                    FileUtils.forceDelete((File)this.localJarFile);
                }
            }
            catch (Exception e) {
                log.warn("[OmsJarContainer-{}] delete jarFile({}) failed.", new Object[]{this.containerId, this.localJarFile.getPath(), e});
            }
            try {
                this.processorCache.clear();
                this.container.close();
                this.containerClassLoader.close();
                log.info("[OmsJarContainer-{}] container destroyed successfully", (Object)this.containerId);
            }
            catch (Exception e) {
                log.error("[OmsJarContainer-{}] container destroyed failed", (Object)this.containerId, (Object)e);
            }
            return;
        }
        log.warn("[OmsJarContainer-{}] container's reference count is {}, won't destroy now!", (Object)this.containerId, (Object)this.referenceCount.get());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Long getContainerId() {
        return this.containerId;
    }

    @Override
    public Long getDeployedTime() {
        return this.deployedTime;
    }

    @Override
    public JobExecutionClassLoader getContainerClassLoader() {
        return this.containerClassLoader;
    }

    @Override
    public void tryRelease() {
        OmsContainer container;
        log.debug("[OmsJarContainer-{}] tryRelease, current reference is {}.", (Object)this.containerId, (Object)this.referenceCount.get());
        if (this.referenceCount.decrementAndGet() <= 0 && (container = OmsContainerFactory.fetchContainer(this.containerId, null)) != this) {
            try {
                this.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

