/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.execution.actors;

import akka.actor.AbstractActor;
import akka.actor.Props;
import akka.japi.Creator;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.job.core.execution.request.ProcessorMapTaskRequest;
import com.jxdinfo.hussar.support.job.core.execution.request.ProcessorReportTaskStatusReq;
import com.jxdinfo.hussar.support.job.core.execution.request.ProcessorTrackerStatusReportReq;
import com.jxdinfo.hussar.support.job.core.request.ServerQueryInstanceStatusReq;
import com.jxdinfo.hussar.support.job.core.request.ServerScheduleJobReq;
import com.jxdinfo.hussar.support.job.core.request.ServerStopInstanceReq;
import com.jxdinfo.hussar.support.job.core.response.AskResponse;
import com.jxdinfo.hussar.support.job.core.service.ExecutionReceiveReqService;
import com.jxdinfo.hussar.support.job.execution.common.WorkerRuntime;
import com.jxdinfo.hussar.support.job.execution.common.constants.TaskStatus;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskTrackerActor
extends AbstractActor {
    private static final Logger log = LoggerFactory.getLogger(TaskTrackerActor.class);
    private final WorkerRuntime workerRuntime;
    private final ExecutionReceiveReqService executionReceiveReqService;

    public static Props props(WorkerRuntime workerRuntime) {
        return Props.create(TaskTrackerActor.class, (Creator & Serializable)() -> new TaskTrackerActor(workerRuntime, (ExecutionReceiveReqService)SpringContextUtil.getBean(ExecutionReceiveReqService.class)));
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(ProcessorReportTaskStatusReq.class, this::onReceiveProcessorReportTaskStatusReq).match(ServerScheduleJobReq.class, this::onReceiveServerScheduleJobReq).match(ProcessorMapTaskRequest.class, this::onReceiveProcessorMapTaskRequest).match(ProcessorTrackerStatusReportReq.class, this::onReceiveProcessorTrackerStatusReportReq).match(ServerStopInstanceReq.class, this::onReceiveServerStopInstanceReq).match(ServerQueryInstanceStatusReq.class, this::onReceiveServerQueryInstanceStatusReq).matchAny(obj -> log.warn("[ServerRequestActor] receive unknown request: {}.", obj)).build();
    }

    private void onReceiveProcessorReportTaskStatusReq(ProcessorReportTaskStatusReq req) {
        int taskStatus = req.getStatus();
        if (TaskStatus.finishedStatus.contains(taskStatus)) {
            AskResponse askResponse = AskResponse.succeed(null);
            this.getSender().tell((Object)askResponse, this.getSelf());
        }
        this.executionReceiveReqService.onReceiveProcessorReportTaskStatusReq(req);
    }

    private void onReceiveProcessorMapTaskRequest(ProcessorMapTaskRequest req) {
        AskResponse response = this.executionReceiveReqService.onReceiveProcessorMapTaskRequest(req);
        if (!response.isSuccess()) {
            return;
        }
        this.getSender().tell((Object)response, this.getSelf());
    }

    private void onReceiveServerScheduleJobReq(ServerScheduleJobReq req) {
        this.executionReceiveReqService.onReceiveServerScheduleJobReq(req);
    }

    private void onReceiveProcessorTrackerStatusReportReq(ProcessorTrackerStatusReportReq req) {
        this.executionReceiveReqService.onReceiveProcessorTrackerStatusReportReq(req);
    }

    private void onReceiveServerStopInstanceReq(ServerStopInstanceReq req) {
        this.executionReceiveReqService.onReceiveServerStopInstanceReq(req);
    }

    private void onReceiveServerQueryInstanceStatusReq(ServerQueryInstanceStatusReq req) {
        AskResponse response = this.executionReceiveReqService.onReceiveServerQueryInstanceStatusReq(req);
        this.getSender().tell((Object)response, this.getSelf());
    }

    public TaskTrackerActor(WorkerRuntime workerRuntime, ExecutionReceiveReqService executionReceiveReqService) {
        this.executionReceiveReqService = executionReceiveReqService;
        this.workerRuntime = workerRuntime;
    }

    public WorkerRuntime getWorkerRuntime() {
        return this.workerRuntime;
    }
}

