/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.execution.service;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.support.job.core.execution.model.TaskDO;
import com.jxdinfo.hussar.support.job.core.execution.request.ProcessorMapTaskRequest;
import com.jxdinfo.hussar.support.job.core.execution.request.ProcessorReportTaskStatusReq;
import com.jxdinfo.hussar.support.job.core.execution.request.ProcessorTrackerStatusReportReq;
import com.jxdinfo.hussar.support.job.core.execution.request.TaskTrackerStartTaskReq;
import com.jxdinfo.hussar.support.job.core.execution.request.TaskTrackerStopInstanceReq;
import com.jxdinfo.hussar.support.job.core.model.InstanceDetail;
import com.jxdinfo.hussar.support.job.core.request.ServerQueryInstanceStatusReq;
import com.jxdinfo.hussar.support.job.core.request.ServerScheduleJobReq;
import com.jxdinfo.hussar.support.job.core.request.ServerStopInstanceReq;
import com.jxdinfo.hussar.support.job.core.response.AskResponse;
import com.jxdinfo.hussar.support.job.core.service.ExecutionReceiveReqService;
import com.jxdinfo.hussar.support.job.execution.common.WorkerRuntime;
import com.jxdinfo.hussar.support.job.execution.common.constants.TaskStatus;
import com.jxdinfo.hussar.support.job.execution.core.tracker.processor.ProcessorTracker;
import com.jxdinfo.hussar.support.job.execution.core.tracker.processor.ProcessorTrackerPool;
import com.jxdinfo.hussar.support.job.execution.core.tracker.task.TaskTracker;
import com.jxdinfo.hussar.support.job.execution.core.tracker.task.TaskTrackerPool;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ExecutionReceiveReqServiceImpl
implements ExecutionReceiveReqService {
    private static Logger log = LoggerFactory.getLogger(ExecutionReceiveReqServiceImpl.class);
    private WorkerRuntime workerRuntime;

    public void onReceiveTaskTrackerStartTaskReq(TaskTrackerStartTaskReq req) {
        Long instanceId = req.getInstanceInfo().getInstanceId();
        ProcessorTracker processorTracker = ProcessorTrackerPool.getProcessorTracker(instanceId, req.getTaskTrackerAddress(), () -> new ProcessorTracker(req, this.workerRuntime));
        TaskDO task = new TaskDO();
        task.setTaskId(req.getTaskId());
        task.setTaskName(req.getTaskName());
        task.setTaskContent(req.getTaskContent());
        task.setFailedCnt(Integer.valueOf(req.getTaskCurrentRetryNums()));
        task.setSubInstanceId(Long.valueOf(req.getSubInstanceId()));
        processorTracker.submitTask(task);
    }

    public void onReceiveTaskTrackerStopInstanceReq(TaskTrackerStopInstanceReq req) {
        Long instanceId = req.getInstanceId();
        List<ProcessorTracker> removedPts = ProcessorTrackerPool.removeProcessorTracker(instanceId);
        if (!CollectionUtils.isEmpty(removedPts)) {
            removedPts.forEach(ProcessorTracker::destroy);
        }
    }

    public void onReceiveProcessorReportTaskStatusReq(ProcessorReportTaskStatusReq req) {
        int taskStatus = req.getStatus();
        TaskTracker taskTracker = TaskTrackerPool.getTaskTrackerPool(req.getInstanceId());
        if (taskTracker == null) {
            log.warn("[TaskTrackerActor] receive ProcessorReportTaskStatusReq({}) but system can't find TaskTracker.", (Object)req);
            return;
        }
        if (ProcessorReportTaskStatusReq.BROADCAST.equals(req.getCmd())) {
            taskTracker.broadcast(taskStatus == TaskStatus.WORKER_PROCESS_SUCCESS.getValue(), req.getSubInstanceId(), req.getTaskId(), req.getResult());
        }
        taskTracker.updateTaskStatus(req.getSubInstanceId(), req.getTaskId(), taskStatus, req.getReportTime(), req.getResult());
        taskTracker.updateAppendedWfContext(req.getAppendedWfContext());
    }

    public AskResponse onReceiveProcessorMapTaskRequest(ProcessorMapTaskRequest req) {
        AskResponse response = new AskResponse();
        TaskTracker taskTracker = TaskTrackerPool.getTaskTrackerPool(req.getInstanceId());
        if (taskTracker == null) {
            log.warn("[TaskTrackerActor] receive ProcessorMapTaskRequest({}) but system can't find TaskTracker.", (Object)req);
            response.setSuccess(false);
            return response;
        }
        boolean success = false;
        LinkedList subTaskList = Lists.newLinkedList();
        try {
            req.getSubTasks().forEach(originSubTask -> {
                TaskDO subTask = new TaskDO();
                subTask.setTaskName(req.getTaskName());
                subTask.setSubInstanceId(req.getSubInstanceId());
                subTask.setTaskId(originSubTask.getTaskId());
                subTask.setTaskContent(originSubTask.getTaskContent());
                subTaskList.add(subTask);
            });
            success = taskTracker.submitTask(subTaskList);
        }
        catch (Exception e) {
            log.warn("[TaskTrackerActor] process map task(instanceId={}) failed.", (Object)req.getInstanceId(), (Object)e);
        }
        response.setSuccess(success);
        return response;
    }

    public void onReceiveServerScheduleJobReq(ServerScheduleJobReq req) {
        Long instanceId = req.getInstanceId();
        TaskTracker taskTracker = TaskTrackerPool.getTaskTrackerPool(instanceId);
        if (taskTracker != null) {
            log.warn("[TaskTrackerActor] TaskTracker({}) for instance(id={}) already exists.", (Object)taskTracker, (Object)instanceId);
            return;
        }
        log.debug("[TaskTrackerActor] server schedule job by request: {}.", (Object)req);
        TaskTrackerPool.atomicCreateTaskTracker(instanceId, ignore -> TaskTracker.create(req, this.workerRuntime));
    }

    public void onReceiveProcessorTrackerStatusReportReq(ProcessorTrackerStatusReportReq req) {
        TaskTracker taskTracker = TaskTrackerPool.getTaskTrackerPool(req.getInstanceId());
        if (taskTracker == null) {
            log.warn("[TaskTrackerActor] receive ProcessorTrackerStatusReportReq({}) but system can't find TaskTracker.", (Object)req);
            return;
        }
        taskTracker.receiveProcessorTrackerHeartbeat(req);
    }

    public void onReceiveServerStopInstanceReq(ServerStopInstanceReq req) {
        TaskTracker taskTracker = TaskTrackerPool.getTaskTrackerPool(req.getInstanceId());
        if (taskTracker == null) {
            log.warn("[TaskTrackerActor] receive ServerStopInstanceReq({}) but system can't find TaskTracker.", (Object)req);
            return;
        }
        taskTracker.destroy();
    }

    public AskResponse onReceiveServerQueryInstanceStatusReq(ServerQueryInstanceStatusReq req) {
        AskResponse response;
        TaskTracker taskTracker = TaskTrackerPool.getTaskTrackerPool(req.getInstanceId());
        if (taskTracker == null) {
            log.warn("[TaskTrackerActor] receive ServerQueryInstanceStatusReq({}) but system can't find TaskTracker.", (Object)req);
            response = AskResponse.failed((String)"can't find TaskTracker");
        } else {
            InstanceDetail instanceDetail = taskTracker.fetchRunningStatus();
            response = AskResponse.succeed((Object)instanceDetail);
        }
        return response;
    }

    public void init(Object workerRuntime) {
        this.workerRuntime = (WorkerRuntime)workerRuntime;
    }
}

