/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.execution.common.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class SpringUtils {
    private static Logger log = LoggerFactory.getLogger(SpringUtils.class);
    private static boolean supportSpringBean = false;
    private static ApplicationContext context;

    public static void inject(ApplicationContext ctx) {
        context = ctx;
        supportSpringBean = true;
    }

    public static boolean supportSpringBean() {
        return supportSpringBean;
    }

    public static <T> T getBean(Class<T> clz) {
        return (T)context.getBean(clz);
    }

    public static <T> T getBean(String className) throws Exception {
        ClassLoader classLoader = context.getClassLoader();
        if (classLoader != null) {
            return (T)context.getBean(classLoader.loadClass(className));
        }
        String[] split = className.split("\\.");
        String beanName = split[split.length - 1];
        char[] cs = beanName.toCharArray();
        cs[0] = (char)(cs[0] + 32);
        String beanName0 = String.valueOf(cs);
        log.warn("[SpringUtils] can't get ClassLoader from context[{}], try to load by beanName:{}", (Object)context, (Object)beanName0);
        return (T)context.getBean(beanName0);
    }
}

