/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.execution.background;

import akka.actor.ActorSelection;
import com.jxdinfo.hussar.support.job.core.JobSerializable;
import com.jxdinfo.hussar.support.job.core.enums.Protocol;
import com.jxdinfo.hussar.support.job.core.model.SystemMetrics;
import com.jxdinfo.hussar.support.job.core.request.WorkerHeartbeat;
import com.jxdinfo.hussar.support.job.execution.common.JobExecutionVersion;
import com.jxdinfo.hussar.support.job.execution.common.WorkerRuntime;
import com.jxdinfo.hussar.support.job.execution.common.utils.AkkaUtils;
import com.jxdinfo.hussar.support.job.execution.common.utils.SystemInfoUtils;
import com.jxdinfo.hussar.support.job.execution.container.OmsContainerFactory;
import com.jxdinfo.hussar.support.job.execution.core.tracker.singlemodel.SingleServerTrackerActor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class WorkerHealthReporter
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(WorkerHealthReporter.class);
    private final WorkerRuntime workerRuntime;

    @Override
    public void run() {
        String currentServer = this.workerRuntime.getServerDiscoveryService().getCurrentServerAddress();
        if (StringUtils.isEmpty((Object)currentServer)) {
            return;
        }
        SystemMetrics systemMetrics = this.workerRuntime.getWorkerConfig().getSystemMetricsCollector() == null ? SystemInfoUtils.getSystemMetrics() : this.workerRuntime.getWorkerConfig().getSystemMetricsCollector().collect();
        WorkerHeartbeat heartbeat = new WorkerHeartbeat();
        heartbeat.setSystemMetrics(systemMetrics);
        heartbeat.setWorkerAddress(this.workerRuntime.getWorkerAddress());
        heartbeat.setAppName(this.workerRuntime.getWorkerConfig().getAppName());
        heartbeat.setAppId(this.workerRuntime.getAppId());
        heartbeat.setHeartbeatTime(System.currentTimeMillis());
        heartbeat.setVersion(JobExecutionVersion.getVersion());
        heartbeat.setProtocol(this.workerRuntime.isSingleModel() ? Protocol.SINGLE_INSTANCE.name() : Protocol.AKKA.name());
        heartbeat.setClient("Atlantis");
        heartbeat.setTag(this.workerRuntime.getWorkerConfig().getTag());
        heartbeat.setContainerInfos(OmsContainerFactory.getDeployedContainerInfos());
        if (this.workerRuntime.isSingleModel()) {
            SingleServerTrackerActor.tell((JobSerializable)heartbeat);
        } else {
            String serverPath = AkkaUtils.getServerActorPath(currentServer);
            if (StringUtils.isEmpty((Object)serverPath)) {
                return;
            }
            ActorSelection actorSelection = this.workerRuntime.getActorSystem().actorSelection(serverPath);
            actorSelection.tell((Object)heartbeat, null);
        }
    }

    public WorkerHealthReporter(WorkerRuntime workerRuntime) {
        this.workerRuntime = workerRuntime;
    }

    public WorkerRuntime getWorkerRuntime() {
        return this.workerRuntime;
    }
}

