/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.execution.background;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.job.core.exception.JobRuntimeException;
import com.jxdinfo.hussar.support.job.core.response.ResultDTO;
import com.jxdinfo.hussar.support.job.core.serialize.JsonUtils;
import com.jxdinfo.hussar.support.job.core.support.JobAppInfoService;
import com.jxdinfo.hussar.support.job.core.support.entity.JobAppInfoEntity;
import com.jxdinfo.hussar.support.job.core.utils.CommonUtils;
import com.jxdinfo.hussar.support.job.core.utils.HttpUtils;
import com.jxdinfo.hussar.support.job.core.utils.NetUtils;
import com.jxdinfo.hussar.support.job.execution.common.JobWorkerConfig;
import com.jxdinfo.hussar.support.job.execution.core.tracker.task.TaskTracker;
import com.jxdinfo.hussar.support.job.execution.core.tracker.task.TaskTrackerPool;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public class ServerDiscoveryService {
    private static Logger log = LoggerFactory.getLogger(ServerDiscoveryService.class);
    private final Long appId;
    private final JobWorkerConfig config;
    private String currentServerAddress;
    private final Map<String, String> ip2Address = Maps.newHashMap();
    private static final String DISCOVERY_URL = "http://%s/server/acquire?appId=%d&currentServer=%s&protocol=AKKA";
    private static final String akkaConfig = "hussar.job.dispatch.akka-port";
    private static int FAILED_COUNT = 0;
    private static final int MAX_FAILED_COUNT = 3;

    public ServerDiscoveryService(Long appId, JobWorkerConfig config) {
        this.appId = appId;
        this.config = config;
    }

    public void start(ScheduledExecutorService timingPool) {
        this.currentServerAddress = this.discovery();
        if (HussarUtils.isEmpty((Object)this.currentServerAddress) && !this.config.isEnableServer()) {
            throw new JobRuntimeException("can't find any available server, this worker has been quarantined.");
        }
        timingPool.scheduleAtFixedRate(() -> {
            this.currentServerAddress = this.discovery();
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    public String getCurrentServerAddress() {
        return this.currentServerAddress;
    }

    private String discovery() {
        Object ip;
        String firstServerAddress;
        if (this.ip2Address.isEmpty()) {
            this.config.getServerAddress().forEach(x -> this.ip2Address.put(x.split(":")[0], (String)x));
        }
        String result = null;
        String currentServer = this.currentServerAddress;
        if (!StringUtils.isEmpty((CharSequence)currentServer) && (firstServerAddress = this.ip2Address.get(ip = currentServer.split(":")[0])) != null) {
            result = this.acquire(firstServerAddress);
        }
        for (String httpServerAddress : this.config.getServerAddress()) {
            if (!StringUtils.isEmpty(result)) break;
            result = this.acquire(httpServerAddress);
        }
        if (StringUtils.isEmpty(result)) {
            log.warn("[PowerDiscovery] can't find any available server, this worker has been quarantined.");
            if (FAILED_COUNT++ > 3) {
                log.warn("[PowerDiscovery] can't find any available server for 3 consecutive times, It's time to kill all frequent job in this worker.");
                List<Long> frequentInstanceIds = TaskTrackerPool.getAllFrequentTaskTrackerKeys();
                if (!CollectionUtils.isEmpty(frequentInstanceIds)) {
                    frequentInstanceIds.forEach(instanceId -> {
                        TaskTracker taskTracker = TaskTrackerPool.remove(instanceId);
                        taskTracker.destroy();
                        log.warn("[PowerDiscovery] kill frequent instance(instanceId={}) due to can't find any available server.", instanceId);
                    });
                }
                FAILED_COUNT = 0;
            }
            return null;
        }
        FAILED_COUNT = 0;
        log.debug("[PowerDiscovery] current server is {}.", result);
        return result;
    }

    private String acquire(String httpServerAddress) {
        String result = null;
        if (this.config.isEnableServer()) {
            return this.acquireServerBySingle();
        }
        String url = String.format(DISCOVERY_URL, httpServerAddress, this.appId, this.currentServerAddress);
        try {
            result = (String)CommonUtils.executeWithRetry0(() -> HttpUtils.get((String)url));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!StringUtils.isEmpty(result)) {
            try {
                ResultDTO resultDTO = (ResultDTO)JsonUtils.parseObject((String)result, ResultDTO.class);
                if (resultDTO.isSuccess()) {
                    return resultDTO.getData().toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String acquireServerBySingle() {
        Integer port;
        JobAppInfoService jobAppInfoService = (JobAppInfoService)SpringContextUtil.getBean(JobAppInfoService.class);
        if (HussarUtils.isEmpty((Object)jobAppInfoService)) {
            return null;
        }
        if (HussarUtils.isEmpty((Object)this.config.getAppName())) {
            throw new JobRuntimeException("appName can't empty");
        }
        JobAppInfoEntity jobAppInfoEntity = (JobAppInfoEntity)jobAppInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(JobAppInfoEntity::getAppName, (Object)this.config.getAppName()));
        if (HussarUtils.isEmpty((Object)jobAppInfoEntity)) {
            return null;
        }
        Environment environment = SpringContextUtil.getApplicationContext().getEnvironment();
        String serverIp = NetUtils.getLocalHost();
        if (this.config.isEnableSingleModel()) {
            port = (Integer)environment.getProperty("server.port", Integer.class);
        } else {
            String serverAkkaIp;
            port = (Integer)environment.getProperty(akkaConfig, Integer.class);
            if (HussarUtils.isEmpty((Object)port)) {
                Integer serverPort = HussarUtils.isEmpty((Object)environment.getProperty("server.port")) ? Integer.valueOf(10086) : (Integer)environment.getProperty("server.port", Integer.class);
                port = serverPort + 2333;
            }
            if (HussarUtils.isNotEmpty((Object)(serverAkkaIp = environment.getProperty("hussar.job.dispatch.akka-ip")))) {
                serverIp = serverAkkaIp;
            }
        }
        String serverAddr = serverIp + ":" + port;
        if (HussarUtils.isEmpty((Object)jobAppInfoEntity.getCurrentServer()) || !HussarUtils.equals((Object)serverAddr, (Object)jobAppInfoEntity.getCurrentServer())) {
            jobAppInfoEntity.setCurrentServer(serverAddr);
            jobAppInfoService.saveOrUpdate((Object)jobAppInfoEntity);
        }
        return serverAddr;
    }
}

