/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.execution.actors;

import akka.actor.AbstractActor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.japi.Creator;
import com.jxdinfo.hussar.support.job.core.request.ServerDeployContainerRequest;
import com.jxdinfo.hussar.support.job.core.request.ServerDestroyContainerRequest;
import com.jxdinfo.hussar.support.job.core.request.ServerQueryInstanceStatusReq;
import com.jxdinfo.hussar.support.job.core.request.ServerScheduleJobReq;
import com.jxdinfo.hussar.support.job.core.request.ServerStopInstanceReq;
import com.jxdinfo.hussar.support.job.execution.container.OmsContainerFactory;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerActor
extends AbstractActor {
    private static Logger log = LoggerFactory.getLogger(WorkerActor.class);
    private final ActorRef taskTrackerActorRef;

    public static Props props(ActorRef taskTrackerActorRef) {
        return Props.create(WorkerActor.class, (Creator & Serializable)() -> new WorkerActor(taskTrackerActorRef));
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(ServerDeployContainerRequest.class, this::onReceiveServerDeployContainerRequest).match(ServerDestroyContainerRequest.class, this::onReceiveServerDestroyContainerRequest).match(ServerScheduleJobReq.class, this::forward2TaskTracker).match(ServerStopInstanceReq.class, this::forward2TaskTracker).match(ServerQueryInstanceStatusReq.class, this::forward2TaskTracker).matchAny(obj -> log.warn("[WorkerActor] receive unknown request: {}.", obj)).build();
    }

    private void onReceiveServerDeployContainerRequest(ServerDeployContainerRequest request) {
        OmsContainerFactory.deployContainer(request);
    }

    private void onReceiveServerDestroyContainerRequest(ServerDestroyContainerRequest request) {
        OmsContainerFactory.destroyContainer(request.getContainerId());
    }

    private void forward2TaskTracker(Object obj) {
        this.taskTrackerActorRef.forward(obj, (ActorContext)this.getContext());
    }

    public WorkerActor(ActorRef taskTrackerActorRef) {
        this.taskTrackerActorRef = taskTrackerActorRef;
    }

    public ActorRef getTaskTrackerActorRef() {
        return this.taskTrackerActorRef;
    }
}

