/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.execution;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.DeadLetter;
import akka.actor.Props;
import akka.routing.RoundRobinPool;
import akka.routing.RouterConfig;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.job.core.exception.JobRuntimeException;
import com.jxdinfo.hussar.support.job.core.serialize.JsonUtils;
import com.jxdinfo.hussar.support.job.core.service.ExecutionReceiveReqService;
import com.jxdinfo.hussar.support.job.core.support.JobAppInfoService;
import com.jxdinfo.hussar.support.job.core.support.entity.JobAppInfoEntity;
import com.jxdinfo.hussar.support.job.core.utils.CommonUtils;
import com.jxdinfo.hussar.support.job.core.utils.HttpUtils;
import com.jxdinfo.hussar.support.job.core.utils.NetUtils;
import com.jxdinfo.hussar.support.job.execution.actors.ProcessorTrackerActor;
import com.jxdinfo.hussar.support.job.execution.actors.TaskTrackerActor;
import com.jxdinfo.hussar.support.job.execution.actors.TroubleshootingActor;
import com.jxdinfo.hussar.support.job.execution.actors.WorkerActor;
import com.jxdinfo.hussar.support.job.execution.background.OmsLogHandler;
import com.jxdinfo.hussar.support.job.execution.background.ServerDiscoveryService;
import com.jxdinfo.hussar.support.job.execution.background.WorkerHealthReporter;
import com.jxdinfo.hussar.support.job.execution.common.JobWorkerConfig;
import com.jxdinfo.hussar.support.job.execution.common.PowerBannerPrinter;
import com.jxdinfo.hussar.support.job.execution.common.WorkerRuntime;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import com.jxdinfo.hussar.support.job.execution.core.tracker.singlemodel.SingleProcessorTrackerActor;
import com.jxdinfo.hussar.support.job.execution.core.tracker.singlemodel.SingleServerTrackerActor;
import com.jxdinfo.hussar.support.job.execution.core.tracker.singlemodel.SingleTaskTrackerActor;
import com.jxdinfo.hussar.support.job.execution.core.tracker.task.TaskTracker;
import com.jxdinfo.hussar.support.job.execution.persistence.TaskPersistenceService;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;

public class JobExecution
implements ApplicationListener<ApplicationStartedEvent>,
ApplicationContextAware,
InitializingBean,
DisposableBean {
    private static Logger log = LoggerFactory.getLogger(TaskTracker.class);
    private ScheduledExecutorService timingPool;
    private final WorkerRuntime workerRuntime = new WorkerRuntime();
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final String appPassword = "123456";

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringUtils.inject(applicationContext);
    }

    public void afterPropertiesSet() throws Exception {
    }

    public void init() throws Exception {
        if (!this.initialized.compareAndSet(false, true)) {
            log.warn("[HussarJobWorker] please do not repeat the initialization");
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.info("[HussarJobWorker] start to initialize HussarJobWorker...");
        JobWorkerConfig config = this.workerRuntime.getWorkerConfig();
        CommonUtils.requireNonNull((Object)config, (String)"can't find OhMyConfig, please set OhMyConfig first");
        try {
            PowerBannerPrinter.print();
            if (!config.isEnableServer()) {
                this.assertAppName();
            } else {
                this.assertAppNameBySingle();
            }
            String workerAddress = NetUtils.getLocalHost() + ":" + config.getPort();
            this.workerRuntime.setWorkerAddress(workerAddress);
            ThreadFactory timingPoolFactory = new ThreadFactoryBuilder().setNameFormat("oms-worker-timing-pool-%d").build();
            this.timingPool = Executors.newScheduledThreadPool(3, timingPoolFactory);
            ServerDiscoveryService serverDiscoveryService = new ServerDiscoveryService(this.workerRuntime.getAppId(), this.workerRuntime.getWorkerConfig());
            serverDiscoveryService.start(this.timingPool);
            this.workerRuntime.setServerDiscoveryService(serverDiscoveryService);
            ActorSystem actorSystem = null;
            ExecutionReceiveReqService executionReceiveReqService = (ExecutionReceiveReqService)SpringContextUtil.getBean(ExecutionReceiveReqService.class);
            executionReceiveReqService.init((Object)this.workerRuntime);
            if (config.isEnableSingleModel()) {
                SingleTaskTrackerActor.init(executionReceiveReqService, this.workerRuntime);
                SingleProcessorTrackerActor.init();
                SingleServerTrackerActor.init();
            } else {
                HashMap overrideConfig = Maps.newHashMap();
                overrideConfig.put("akka.remote.artery.canonical.hostname", NetUtils.getLocalHost());
                overrideConfig.put("akka.remote.artery.canonical.port", config.getPort());
                Config akkaBasicConfig = ConfigFactory.load((String)"oms-worker.akka.conf");
                Config akkaFinalConfig = ConfigFactory.parseMap((Map)overrideConfig).withFallback((ConfigMergeable)akkaBasicConfig);
                int cores = Runtime.getRuntime().availableProcessors();
                actorSystem = ActorSystem.create((String)"oms", (Config)akkaFinalConfig);
                this.workerRuntime.setActorSystem(actorSystem);
                ActorRef taskTrackerActorRef = actorSystem.actorOf(TaskTrackerActor.props(this.workerRuntime).withDispatcher("akka.task-tracker-dispatcher").withRouter((RouterConfig)new RoundRobinPool(cores * 2)), "task_tracker");
                actorSystem.actorOf(ProcessorTrackerActor.props(this.workerRuntime).withDispatcher("akka.processor-tracker-dispatcher").withRouter((RouterConfig)new RoundRobinPool(cores)), "processor_tracker");
                actorSystem.actorOf(WorkerActor.props(taskTrackerActorRef).withDispatcher("akka.worker-common-dispatcher").withRouter((RouterConfig)new RoundRobinPool(cores)), "worker");
                ActorRef troubleshootingActor = actorSystem.actorOf(Props.create(TroubleshootingActor.class, (Object[])new Object[0]), "troubleshooting");
                actorSystem.eventStream().subscribe(troubleshootingActor, DeadLetter.class);
                log.info("[HussarJobExecution] akka-remote listening address: {}", (Object)workerAddress);
                log.info("[HussarJobExecution] akka ActorSystem({}) initialized successfully.", (Object)actorSystem);
            }
            OmsLogHandler omsLogHandler = new OmsLogHandler(config.isEnableSingleModel(), workerAddress, actorSystem, serverDiscoveryService);
            this.workerRuntime.setOmsLogHandler(omsLogHandler);
            this.timingPool.scheduleAtFixedRate(new WorkerHealthReporter(this.workerRuntime), 0L, 15L, TimeUnit.SECONDS);
            this.timingPool.scheduleWithFixedDelay(omsLogHandler.logSubmitter, 0L, 5L, TimeUnit.SECONDS);
            log.info("[HussarJobExecution] HussarJobExecution initialized successfully, using time: {}, congratulations!", (Object)stopwatch);
        }
        catch (Exception e) {
            log.error("[HussarJobExecution] initialize HussarJobExecution failed, using {}.", (Object)stopwatch, (Object)e);
            throw e;
        }
    }

    public void setTaskPersistenceService(TaskPersistenceService taskPersistenceService) {
        this.workerRuntime.setTaskPersistenceService(taskPersistenceService);
        log.info("[HussarJobExecution] local storage initialized successfully.");
    }

    public void setConfig(JobWorkerConfig config) {
        this.workerRuntime.setWorkerConfig(config);
    }

    private void assertAppName() {
        JobWorkerConfig config = this.workerRuntime.getWorkerConfig();
        String appName = config.getAppName();
        Objects.requireNonNull(appName, "appName can't be empty!");
        String url = "http://%s/server/assert?appName=%s";
        for (String server : config.getServerAddress()) {
            String realUrl = String.format(url, server, appName);
            try {
                String apiResponseStr = (String)CommonUtils.executeWithRetry0(() -> HttpUtils.get((String)realUrl));
                ApiResponse apiResponse = (ApiResponse)JsonUtils.parseObject((String)apiResponseStr, ApiResponse.class);
                if (apiResponse.isSuccess()) {
                    Long appId = Long.valueOf(apiResponse.getData().toString());
                    log.info("[HussarJobExecution] assert appName({}) succeed, the appId for this application is {}.", (Object)appName, (Object)appId);
                    this.workerRuntime.setAppId(appId);
                    return;
                }
                log.error("[HussarJobExecution] assert appName failed, this appName is invalid, please register the appName {} first.", (Object)appName);
                throw new JobRuntimeException(apiResponse.getMsg());
            }
            catch (JobRuntimeException oe) {
                throw oe;
            }
            catch (Exception ignore) {
                log.warn("[HussarJobExecution] assert appName by url({}) failed, please check the server address.", (Object)realUrl);
            }
        }
        log.error("[HussarJobExecution] no available server in {}.", config.getServerAddress());
        throw new JobRuntimeException("no server available!");
    }

    private void assertAppNameBySingle() {
        JobWorkerConfig config = this.workerRuntime.getWorkerConfig();
        JobAppInfoService jobAppInfoService = (JobAppInfoService)SpringContextUtil.getBean(JobAppInfoService.class);
        if (HussarUtils.isEmpty((Object)jobAppInfoService)) {
            return;
        }
        String appName = config.getAppName();
        if (HussarUtils.isEmpty((Object)appName)) {
            throw new JobRuntimeException("appName can't be empty,please set hussar.job.execution.app-name");
        }
        JobAppInfoEntity jobAppInfoEntity = jobAppInfoService.getAppInfoByAppName(appName);
        if (HussarUtils.isEmpty((Object)jobAppInfoEntity)) {
            jobAppInfoEntity = this.addNewAppInfo(appName);
        }
        this.workerRuntime.setAppId(jobAppInfoEntity.getId());
        log.warn("[hussar-job-execution] using single model now.");
    }

    private JobAppInfoEntity addNewAppInfo(String appName) {
        JobAppInfoEntity appInfo = new JobAppInfoEntity();
        appInfo.setAppName(appName);
        appInfo.setPassword("123456");
        JobAppInfoService jobAppInfoService = (JobAppInfoService)SpringContextUtil.getBean(JobAppInfoService.class);
        if (HussarUtils.isEmpty((Object)jobAppInfoService)) {
            return null;
        }
        jobAppInfoService.save((Object)appInfo);
        return appInfo;
    }

    public WorkerRuntime getWorkerRuntime() {
        return this.workerRuntime;
    }

    public void destroy() throws Exception {
        this.timingPool.shutdownNow();
        if (!this.workerRuntime.isSingleModel()) {
            this.workerRuntime.getActorSystem().terminate();
        }
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        try {
            this.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

