/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.execution;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.core.properties.JobProperties;
import com.jxdinfo.hussar.support.job.core.service.ExecutionReceiveReqService;
import com.jxdinfo.hussar.support.job.core.utils.CommonUtils;
import com.jxdinfo.hussar.support.job.core.utils.NetUtils;
import com.jxdinfo.hussar.support.job.execution.JobExecution;
import com.jxdinfo.hussar.support.job.execution.JobExecutionProperties;
import com.jxdinfo.hussar.support.job.execution.JobLocalCacheConfiguration;
import com.jxdinfo.hussar.support.job.execution.common.JobWorkerConfig;
import com.jxdinfo.hussar.support.job.execution.core.processor.impl.SleepTimeProcessor;
import com.jxdinfo.hussar.support.job.execution.persistence.TaskPersistenceService;
import com.jxdinfo.hussar.support.job.execution.service.ExecutionReceiveReqServiceImpl;
import com.jxdinfo.hussar.support.job.execution.support.DefaultProcessorListener;
import com.jxdinfo.hussar.support.job.execution.support.ProcessorListener;
import java.util.Arrays;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={JobProperties.class, JobExecutionProperties.class})
@Conditional(value={JobExecutionCondition.class})
@Import(value={JobLocalCacheConfiguration.class})
public class JobExecutionAutoConfiguration {
    @Bean
    public ExecutionReceiveReqService executionReceiveReqService() {
        return new ExecutionReceiveReqServiceImpl();
    }

    @Bean
    public TaskPersistenceService taskPersistenceService() {
        return new TaskPersistenceService();
    }

    @Bean
    @ConditionalOnMissingBean
    public ProcessorListener processListener() {
        return new DefaultProcessorListener();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="hussar.job", name={"enable-executor"}, havingValue="true", matchIfMissing=true)
    public JobExecution initExecutionJob(JobProperties jobProperties, JobExecutionProperties properties, Environment environment) {
        CommonUtils.requireNonNull((Object)properties.getServerAddress(), (String)"serverAddress can't be empty!");
        List<String> serverAddress = Arrays.asList(properties.getServerAddress().split(","));
        JobWorkerConfig config = new JobWorkerConfig();
        Integer port = properties.getAkkaPort();
        if (jobProperties.isEnableSingleModel()) {
            port = (Integer)environment.getProperty("server.port", Integer.class);
        } else {
            if (HussarUtils.isEmpty((Object)port)) {
                Integer serverPort = HussarUtils.isEmpty((Object)environment.getProperty("server.port")) ? Integer.valueOf(27777) : (Integer)environment.getProperty("server.port", Integer.class);
                port = serverPort + 2222;
            }
            if (port <= 0) {
                port = NetUtils.getRandomPort();
            }
        }
        config.setEnableSingleModel(jobProperties.isEnableSingleModel());
        config.setPort(port.intValue());
        config.setAkkaIp(properties.getAkkaIp());
        config.setAppName(properties.getAppName());
        config.setAppId(properties.getAppId());
        config.setServerAddress(serverAddress);
        config.setEnableServer(jobProperties.isEnableServer());
        config.setMaxAppendedWfContextLength(properties.getMaxAppendedWfContextLength());
        JobExecution jobExecution = new JobExecution();
        jobExecution.setConfig(config);
        jobExecution.setTaskPersistenceService(this.taskPersistenceService());
        return jobExecution;
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar.job", name={"enable-executor"}, havingValue="true", matchIfMissing=true)
    public SleepTimeProcessor initSleepTimeProcessor() {
        return new SleepTimeProcessor();
    }

    static class JobExecutionCondition
    extends AnyNestedCondition {
        public JobExecutionCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(prefix="hussar.job.execution", name={"server-address"})
        static class JobExecutionProperty {
            JobExecutionProperty() {
            }
        }
    }
}

