/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.web.response;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.platform.core.utils.DateTimeUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.core.JobSerializable;
import com.jxdinfo.hussar.support.job.core.enums.InstanceStatus;
import com.jxdinfo.hussar.support.job.core.model.InstanceDetail;
import com.jxdinfo.hussar.support.job.core.utils.CommonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

@ApiModel(value="\u4efb\u52a1\u5b9e\u4f8b\u7684\u8fd0\u884c\u8be6\u7ec6\u4fe1\u606f")
public class InstanceDetailVO {
    @ApiModelProperty(value="\u4efb\u52a1\u9884\u8ba1\u6267\u884c\u65f6\u95f4")
    private LocalDateTime expectedTriggerTime;
    @ApiModelProperty(value="\u4efb\u52a1\u6574\u4f53\u5f00\u59cb\u65f6\u95f4")
    private LocalDateTime actualTriggerTime;
    @ApiModelProperty(value="\u4efb\u52a1\u6574\u4f53\u7ed3\u675f\u65f6\u95f4")
    private LocalDateTime finishedTime;
    @ApiModelProperty(value="\u4efb\u52a1\u72b6\u6001")
    private Integer status;
    @ApiModelProperty(value="\u865a\u62df\u6574\u5408\u540e\u7684\u4efb\u52a1\u72b6\u6001")
    private Integer virtualStatus;
    @ApiModelProperty(value="\u4efb\u52a1\u6267\u884c\u7ed3\u679c")
    private String result;
    @ApiModelProperty(value="TaskTracker\u5730\u5740")
    private String taskTrackerAddress;
    @ApiModelProperty(value="\u4efb\u52a1\u53c2\u6570")
    private String jobParams;
    @ApiModelProperty(value="\u542f\u52a8\u53c2\u6570")
    private String instanceParams;
    @ApiModelProperty(value="MR\u6216BD\u4efb\u52a1\u6269\u5c55\u4fe1\u606f")
    private TaskDetail taskDetail;
    @ApiModelProperty(value="\u79d2\u7ea7\u4efb\u52a1\u5b50\u4efb\u52a1\u8be6\u60c5")
    private List<SubInstanceDetail> subInstanceDetails;
    @ApiModelProperty(value="\u4efb\u52a1\u9884\u8ba1\u6267\u884c\u65f6\u95f4")
    private Long runningTimes;

    public LocalDateTime getExpectedTriggerTime() {
        return this.expectedTriggerTime;
    }

    public void setExpectedTriggerTime(LocalDateTime expectedTriggerTime) {
        this.expectedTriggerTime = expectedTriggerTime;
    }

    public LocalDateTime getActualTriggerTime() {
        return this.actualTriggerTime;
    }

    public void setActualTriggerTime(LocalDateTime actualTriggerTime) {
        this.actualTriggerTime = actualTriggerTime;
    }

    public LocalDateTime getFinishedTime() {
        return this.finishedTime;
    }

    public void setFinishedTime(LocalDateTime finishedTime) {
        this.finishedTime = finishedTime;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getTaskTrackerAddress() {
        return this.taskTrackerAddress;
    }

    public void setTaskTrackerAddress(String taskTrackerAddress) {
        this.taskTrackerAddress = taskTrackerAddress;
    }

    public String getJobParams() {
        return this.jobParams;
    }

    public void setJobParams(String jobParams) {
        this.jobParams = jobParams;
    }

    public String getInstanceParams() {
        return this.instanceParams;
    }

    public void setInstanceParams(String instanceParams) {
        this.instanceParams = instanceParams;
    }

    public TaskDetail getTaskDetail() {
        return this.taskDetail;
    }

    public void setTaskDetail(TaskDetail taskDetail) {
        this.taskDetail = taskDetail;
    }

    public List<SubInstanceDetail> getSubInstanceDetails() {
        return this.subInstanceDetails;
    }

    public void setSubInstanceDetails(List<SubInstanceDetail> subInstanceDetails) {
        this.subInstanceDetails = subInstanceDetails;
    }

    public Long getRunningTimes() {
        return this.runningTimes;
    }

    public void setRunningTimes(Long runningTimes) {
        this.runningTimes = runningTimes;
    }

    public Integer getVirtualStatus() {
        return this.virtualStatus;
    }

    public void setVirtualStatus(Integer virtualStatus) {
        this.virtualStatus = virtualStatus;
    }

    public static InstanceDetailVO from(InstanceDetail origin) {
        InstanceDetailVO vo = new InstanceDetailVO();
        BeanUtils.copyProperties((Object)origin, (Object)vo);
        if (HussarUtils.isNotEmpty((Object)origin.getActualTriggerTime())) {
            vo.setActualTriggerTime(DateTimeUtil.toDateTime((long)origin.getActualTriggerTime()));
        }
        if (HussarUtils.isNotEmpty((Object)origin.getExpectedTriggerTime())) {
            vo.setExpectedTriggerTime(DateTimeUtil.toDateTime((long)origin.getExpectedTriggerTime()));
        }
        if (HussarUtils.isNotEmpty((Object)origin.getFinishedTime())) {
            vo.setFinishedTime(DateTimeUtil.toDateTime((long)origin.getFinishedTime()));
        }
        if (origin.getTaskDetail() != null) {
            TaskDetail voDetail = new TaskDetail();
            BeanUtils.copyProperties((Object)origin.getTaskDetail(), (Object)voDetail);
            vo.setTaskDetail(voDetail);
        }
        vo.setVirtualStatus(origin.getStatus());
        if (!CollectionUtils.isEmpty((Collection)origin.getSubInstanceDetails())) {
            vo.subInstanceDetails = Lists.newLinkedList();
            origin.getSubInstanceDetails().forEach(subDetail -> {
                SubInstanceDetail voSubDetail = new SubInstanceDetail();
                BeanUtils.copyProperties((Object)subDetail, (Object)voSubDetail);
                voSubDetail.setStartTime(CommonUtils.formatTime((Long)subDetail.getStartTime()));
                voSubDetail.setFinishedTime(CommonUtils.formatTime((Long)subDetail.getFinishedTime()));
                vo.subInstanceDetails.add(voSubDetail);
            });
            if (vo.subInstanceDetails.stream().allMatch(item -> InstanceStatus.FINISHED_STATUS.contains(item.getStatus()))) {
                vo.setVirtualStatus(InstanceStatus.VIRTUAL_STATUS_EXECUTION_WAIT_NEXT_TASK.getV());
            }
        }
        return vo;
    }

    @ApiModel(value="MR\u6216BD\u4efb\u52a1\u6269\u5c55\u4fe1\u606f")
    public static class TaskDetail
    implements JobSerializable {
        @ApiModelProperty(value="\u603b\u4efb\u52a1\u6570")
        private long totalTaskNum;
        @ApiModelProperty(value="\u6267\u884c\u6210\u529f\u4efb\u52a1\u6570")
        private long succeedTaskNum;
        @ApiModelProperty(value="\u6267\u884c\u5931\u8d25\u4efb\u52a1\u6570")
        private long failedTaskNum;

        public long getTotalTaskNum() {
            return this.totalTaskNum;
        }

        public void setTotalTaskNum(long totalTaskNum) {
            this.totalTaskNum = totalTaskNum;
        }

        public long getSucceedTaskNum() {
            return this.succeedTaskNum;
        }

        public void setSucceedTaskNum(long succeedTaskNum) {
            this.succeedTaskNum = succeedTaskNum;
        }

        public long getFailedTaskNum() {
            return this.failedTaskNum;
        }

        public void setFailedTaskNum(long failedTaskNum) {
            this.failedTaskNum = failedTaskNum;
        }
    }

    @ApiModel(value="\u79d2\u7ea7\u4efb\u52a1\u5b50\u4efb\u52a1\u8be6\u60c5")
    public static class SubInstanceDetail
    implements JobSerializable {
        @ApiModelProperty(value="\u5b50\u5b9e\u4f8bid")
        private long subInstanceId;
        @ApiModelProperty(value="\u5f00\u59cb\u65f6\u95f4")
        private String startTime;
        @ApiModelProperty(value="\u7ed3\u675f\u65f6\u95f4")
        private String finishedTime;
        @ApiModelProperty(value="\u6267\u884c\u7ed3\u679c\u63cf\u8ff0")
        private String result;
        @ApiModelProperty(value="\u5b50\u5b9e\u4f8b\u72b6\u6001")
        private int status;

        public long getSubInstanceId() {
            return this.subInstanceId;
        }

        public void setSubInstanceId(long subInstanceId) {
            this.subInstanceId = subInstanceId;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getFinishedTime() {
            return this.finishedTime;
        }

        public void setFinishedTime(String finishedTime) {
            this.finishedTime = finishedTime;
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }
    }
}

