/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.config;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
public class WebLogAspect {
    private static final Logger log = LoggerFactory.getLogger(WebLogAspect.class);

    @Pointcut(value="execution(public * com.jxdinfo.hussar.support.job.dispatch.web.controller..*.*(..))")
    public void include() {
    }

    @Pointcut(value="execution(public * com.jxdinfo.hussar.support.job.dispatch.web.controller.ServerController.*(..))")
    public void exclude() {
    }

    @Pointcut(value="include() && !exclude()")
    public void webLog() {
    }

    @Before(value="webLog()")
    public void doBefore(JoinPoint joinPoint) {
        try {
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (requestAttributes == null) {
                return;
            }
            HttpServletRequest request = requestAttributes.getRequest();
            String[] classNameSplit = joinPoint.getSignature().getDeclaringTypeName().split("\\.");
            String classNameMini = classNameSplit[classNameSplit.length - 1];
            String classMethod = classNameMini + "." + joinPoint.getSignature().getName();
            log.info("{}|{}|{}|{}", new Object[]{request.getRemoteAddr(), request.getMethod(), classMethod, WebLogAspect.stringify(joinPoint.getArgs())});
        }
        catch (Exception e) {
            log.error("[WebLogAspect] aop occur exception, please concat @KFCFans to fix the bug!", (Throwable)e);
        }
    }

    private static String stringify(Object[] args) {
        Object obj;
        if (ArrayUtils.isEmpty((Object[])args)) {
            return null;
        }
        LinkedList objList = Lists.newLinkedList();
        Object[] objectArray = args;
        int n = objectArray.length;
        for (int i = 0; !(i >= n || (obj = objectArray[i]) instanceof HttpServletRequest || obj instanceof HttpServletResponse || obj instanceof MultipartFile || obj instanceof Resource); ++i) {
            objList.add(obj);
        }
        return JSONObject.toJSONString((Object)objList);
    }
}

