/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;

@Configuration
@EnableWebSocket
public class JobDispatchWebConfig
implements WebMvcConfigurer {
    @Value(value="${hussar.cors.enabled:false}")
    private Boolean hussarCorsEnabled;

    public void addCorsMappings(CorsRegistry registry) {
        if (!this.hussarCorsEnabled.booleanValue()) {
            registry.addMapping("/**").allowedMethods(new String[]{"HEAD", "GET", "PUT", "POST", "DELETE", "PATCH"});
        }
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar.job.dispatch", name={"package-type"}, havingValue="jar", matchIfMissing=true)
    public ServerEndpointExporter serverEndpointExporter() {
        return new ServerEndpointExporter();
    }
}

