/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.web.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarTenantEntity;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.job.core.request.http.SaveJobInfoRequest;
import com.jxdinfo.hussar.support.job.dispatch.api.entity.JobInfoEntity;
import com.jxdinfo.hussar.support.job.dispatch.common.constants.SwitchableStatus;
import com.jxdinfo.hussar.support.job.dispatch.core.service.JobService;
import com.jxdinfo.hussar.support.job.dispatch.dao.service.JobInfoService;
import com.jxdinfo.hussar.support.job.dispatch.web.response.JobInfoVO;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.text.ParseException;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/job"})
@AuditLog(moduleName="\u4efb\u52a1\u7ba1\u7406")
@Api(value="job", tags={"\u4efb\u52a1\u7ba1\u7406"})
public class JobController {
    @Resource
    private JobService jobService;
    @Resource
    private JobInfoService jobInfoService;

    @PostMapping(value={"/save"})
    @AuditLog(eventDesc="\u4fdd\u5b58\u4efb\u52a1", evnetType=AuditEventType.INSERT, eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE)
    @ApiOperation(value="\u4fdd\u5b58\u4efb\u52a1", notes="\u4fdd\u5b58\u4efb\u52a1")
    public ApiResponse saveJobInfo(@ApiParam(value="\u5f85\u4fdd\u5b58\u4efb\u52a1\u4fe1\u606f") @RequestBody SaveJobInfoRequest request) throws Exception {
        this.jobService.saveJob(request);
        return ApiResponse.success();
    }

    @PostMapping(value={"/saveJobApi"})
    @AuditLog(eventDesc="api\u4fdd\u5b58\u4efb\u52a1", evnetType=AuditEventType.INSERT, eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE)
    @ApiOperation(value="api\u4fdd\u5b58\u4efb\u52a1", notes="\u4fdd\u5b58\u4efb\u52a1")
    public ApiResponse saveJobApi(@ApiParam(value="\u5f85\u4fdd\u5b58\u4efb\u52a1\u4fe1\u606f") @RequestBody SaveJobInfoRequest request) throws Exception {
        this.jobService.saveJobApi(request);
        return ApiResponse.success();
    }

    @PostMapping(value={"/copy"})
    @AuditLog(eventDesc="\u590d\u5236\u4efb\u52a1", evnetType=AuditEventType.INSERT, eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE)
    @ApiOperation(value="\u590d\u5236\u4efb\u52a1", notes="\u590d\u5236\u4efb\u52a1")
    public ApiResponse<JobInfoVO> copyJob(@ApiParam(value="\u4efb\u52a1id") @RequestBody String jobId) {
        return ApiResponse.success((Object)JobInfoVO.from(this.jobService.copyJob(Long.valueOf(jobId))));
    }

    @GetMapping(value={"/disable"})
    @AuditLog(eventDesc="\u505c\u6b62\u4efb\u52a1", evnetType=AuditEventType.UPDATE, eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE)
    @ApiOperation(value="\u505c\u6b62\u4efb\u52a1", notes="\u505c\u6b62\u4efb\u52a1")
    public ApiResponse disableJob(@ApiParam(value="\u4efb\u52a1id") String jobId) {
        this.jobService.disableJob(Long.valueOf(jobId));
        return ApiResponse.success();
    }

    @GetMapping(value={"/enable"})
    @AuditLog(eventDesc="\u542f\u7528\u4efb\u52a1", evnetType=AuditEventType.UPDATE, eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE)
    @ApiOperation(value="\u542f\u7528\u4efb\u52a1", notes="\u542f\u7528\u4efb\u52a1")
    public ApiResponse enableJob(@ApiParam(value="\u4efb\u52a1id") String jobId) throws ParseException {
        this.jobService.enableJob(Long.valueOf(jobId));
        return ApiResponse.success();
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664\u4efb\u52a1", notes="\u5220\u9664\u4efb\u52a1")
    @AuditLog(eventDesc="\u5220\u9664\u4efb\u52a1", evnetType=AuditEventType.UPDATE, eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE)
    public ApiResponse deleteJob(@ApiParam(value="\u4efb\u52a1id") @RequestBody String jobId) {
        this.jobService.deleteJob(Long.valueOf(jobId));
        return ApiResponse.success();
    }

    @PostMapping(value={"/deleteJobApi"})
    @ApiOperation(value="\u5220\u9664\u4efb\u52a1", notes="\u5220\u9664\u4efb\u52a1")
    @AuditLog(eventDesc="api\u5220\u9664\u4efb\u52a1", evnetType=AuditEventType.UPDATE, eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE)
    public ApiResponse deleteJobApi(@ApiParam(value="\u4efb\u52a1id") @RequestBody String jobId) {
        this.jobService.deleteJobApi(Long.valueOf(jobId));
        return ApiResponse.success();
    }

    @GetMapping(value={"/run"})
    @AuditLog(eventDesc="\u8fd0\u884c\u4efb\u52a1", evnetType=AuditEventType.INSERT, eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE)
    @ApiOperation(value="\u8fd0\u884c\u4efb\u52a1", notes="\u8fd0\u884c\u4efb\u52a1")
    public ApiResponse<Long> runImmediately(@ApiParam(value="\u5e94\u7528id") String appId, @ApiParam(value="\u4efb\u52a1id") String jobId) {
        return ApiResponse.success((Object)this.jobService.runJob(Long.valueOf(appId), Long.valueOf(jobId), null, Long.valueOf(0L)));
    }

    @GetMapping(value={"/list"})
    @AuditLog(eventDesc="\u5206\u9875\u67e5\u8be2\u4efb\u52a1\u5217\u8868", evnetType=AuditEventType.QUERY, eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE)
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u4efb\u52a1\u5217\u8868", notes="\u5206\u9875\u67e5\u8be2\u4efb\u52a1\u5217\u8868")
    public ApiResponse<Page<JobInfoVO>> listJobs(Page<JobInfoEntity> page, JobInfoEntity jobInfoEntity) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.orderByAsc(JobInfoEntity::getId)).eq(JobInfoEntity::getAppId, (Object)jobInfoEntity.getAppId())).ne(JobInfoEntity::getStatus, (Object)SwitchableStatus.DELETED.getV())).like(HussarUtils.isNotEmpty((Object)jobInfoEntity.getJobName()), JobInfoEntity::getJobName, (Object)jobInfoEntity.getJobName());
        if (HussarUtils.isNotEmpty((Object)jobInfoEntity.getSubAppId())) {
            queryWrapper.eq(JobInfoEntity::getSubAppId, (Object)jobInfoEntity.getSubAppId());
        }
        if (HussarUtils.isNotEmpty((Object)jobInfoEntity.getTenantCode())) {
            queryWrapper.eq(HussarTenantEntity::getTenantCode, (Object)jobInfoEntity.getTenantCode());
        } else {
            UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
            String tenantCode = "0";
            if (HussarUtils.isNotEmpty((Object)userDetails) && HussarUtils.isNotEmpty((Object)userDetails.getTenantCode())) {
                tenantCode = userDetails.getTenantCode();
            }
            queryWrapper.eq(HussarTenantEntity::getTenantCode, (Object)tenantCode);
        }
        page = (Page)this.jobInfoService.page(page, (Wrapper)queryWrapper);
        return ApiResponse.success(JobController.convertPage((Page<JobInfoEntity>)page));
    }

    @GetMapping(value={"/jobList"})
    @ApiOperation(value="\u67e5\u8be2\u4efb\u52a1\u5217\u8868", notes="\u67e5\u8be2\u4efb\u52a1\u5217\u8868")
    public ApiResponse<List<JobInfoEntity>> jobList(HttpServletRequest request) {
        return this.jobService.getJobListApi(request.getParameterMap());
    }

    @PostMapping(value={"/saveJobList"})
    @ApiOperation(value="\u6279\u91cf\u4fdd\u5b58\u4efb\u52a1", notes="\u6279\u91cf\u4fdd\u5b58\u4efb\u52a1")
    public ApiResponse<Boolean> saveJobList(@RequestBody List<JobInfoEntity> jobInfoEntities) throws ParseException {
        return this.jobService.saveJobList(jobInfoEntities);
    }

    @PostMapping(value={"/physicalDeleteJob"})
    @ApiOperation(value="\u7269\u7406\u5220\u9664\u4efb\u52a1", notes="\u7269\u7406\u5220\u9664\u4efb\u52a1")
    public ApiResponse<Boolean> physicalDeleteJob(@RequestBody Long jobId) {
        return this.jobService.physicalDeleteJob(jobId);
    }

    private static Page<JobInfoVO> convertPage(Page<JobInfoEntity> jobInfoPage) {
        List jobInfoVOList = jobInfoPage.getRecords().stream().map(JobInfoVO::from).collect(Collectors.toList());
        Page page = new Page(jobInfoPage.getCurrent(), jobInfoPage.getSize());
        page.setRecords(jobInfoVOList);
        page.setTotal(jobInfoPage.getTotal());
        return page;
    }
}

